/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.editor.IMakefileDocumentProvider;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefilePartitionScanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

public class MakefileDocumentProvider
extends FileDocumentProvider
implements IMakefileDocumentProvider {
    private static MakefilePartitionScanner scanner = null;

    protected IDocument createDocument(Object object) throws CoreException {
        IDocument iDocument = super.createDocument(object);
        if (iDocument != null) {
            IDocumentPartitioner iDocumentPartitioner = this.createPartitioner();
            iDocumentPartitioner.connect(iDocument);
            iDocument.setDocumentPartitioner(iDocumentPartitioner);
        }
        return iDocument;
    }

    private IDocumentPartitioner createPartitioner() {
        return new DefaultPartitioner((IPartitionTokenScanner)this.getPartitionScanner(), MakefilePartitionScanner.TYPES);
    }

    private MakefilePartitionScanner getPartitionScanner() {
        if (scanner == null) {
            scanner = new MakefilePartitionScanner();
        }
        return scanner;
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object object) throws CoreException {
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            IMakefile iMakefile = this.createMakefile(iFileEditorInput.getFile());
            if (iMakefile == null) {
                return super.createElementInfo(object);
            }
            try {
                this.refreshFile(iFileEditorInput.getFile());
            }
            catch (CoreException coreException) {
                this.handleCoreException(coreException, MakeUIPlugin.getResourceString("MakeDocumentProvider.exception.createElementInfo"));
            }
            IDocument iDocument = null;
            IStatus iStatus = null;
            try {
                iDocument = this.createDocument(object);
            }
            catch (CoreException coreException) {
                iStatus = coreException.getStatus();
                iDocument = this.createEmptyDocument();
            }
            IAnnotationModel iAnnotationModel = this.createAnnotationModel(object);
            FileDocumentProvider.FileSynchronizer fileSynchronizer = new FileDocumentProvider.FileSynchronizer((FileDocumentProvider)this, iFileEditorInput);
            fileSynchronizer.install();
            MakefileInfo makefileInfo = new MakefileInfo(iDocument, iAnnotationModel, fileSynchronizer, iMakefile);
            makefileInfo.fModificationStamp = this.computeModificationStamp((IResource)iFileEditorInput.getFile());
            makefileInfo.fStatus = iStatus;
            makefileInfo.fEncoding = this.getPersistedEncoding(iFileEditorInput);
            return makefileInfo;
        }
        return super.createElementInfo(object);
    }

    private IMakefile createMakefile(IFile iFile) {
        return MakeCorePlugin.getDefault().createMakefile(iFile);
    }

    protected void doSaveDocument(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(object);
        if (elementInfo instanceof MakefileInfo) {
            MakefileInfo makefileInfo = (MakefileInfo)elementInfo;
            String string = iDocument.get();
            StringReader stringReader = new StringReader(string);
            try {
                makefileInfo.fCopy.parse(makefileInfo.fCopy.getFileName(), (Reader)stringReader);
            }
            catch (IOException iOException) {}
        }
        super.doSaveDocument(iProgressMonitor, object, iDocument, bl);
    }

    public void shutdown() {
        Iterator iterator = this.getConnectedElements();
        while (iterator.hasNext()) {
            this.disconnect(iterator.next());
        }
    }

    public IMakefile getWorkingCopy(Object object) {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(object);
        if (elementInfo instanceof MakefileInfo) {
            MakefileInfo makefileInfo = (MakefileInfo)elementInfo;
            return makefileInfo.fCopy;
        }
        return null;
    }

    protected class MakefileInfo
    extends FileDocumentProvider.FileInfo {
        IMakefile fCopy;

        public MakefileInfo(IDocument iDocument, IAnnotationModel iAnnotationModel, FileDocumentProvider.FileSynchronizer fileSynchronizer, IMakefile iMakefile) {
            super((FileDocumentProvider)MakefileDocumentProvider.this, iDocument, iAnnotationModel, fileSynchronizer);
            this.fCopy = iMakefile;
        }

        public void setModificationStamp(long l) {
            this.fModificationStamp = l;
        }
    }
}

