/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import java.util.ResourceBundle;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.editor.MakefileContentOutlinePage;
import org.eclipse.cdt.make.internal.ui.editor.MakefileSourceConfiguration;
import org.eclipse.cdt.make.internal.ui.editor.OpenDeclarationAction;
import org.eclipse.cdt.make.internal.ui.text.MakefileColorManager;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefileWordDetector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;

public class MakefileEditor
extends TextEditor
implements ISelectionChangedListener {
    protected MakefileContentOutlinePage page;
    private FindReplaceDocumentAdapter fFindReplaceDocumentAdapter;
    static /* synthetic */ Class class$0;

    public MakefileContentOutlinePage getOutlinePage() {
        if (this.page == null) {
            this.page = new MakefileContentOutlinePage(this);
            this.page.addSelectionChangedListener(this);
            this.page.setInput(this.getEditorInput());
        }
        return this.page;
    }

    protected void initializeEditor() {
        this.setSourceViewerConfiguration(new MakefileSourceConfiguration(new MakefileColorManager(), this));
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setEditorContextMenuId("#MakefileEditorContext");
        this.setRulerContextMenuId("#MakefileRulerContext");
        this.setDocumentProvider(MakeUIPlugin.getDefault().getMakefileDocumentProvider());
        this.setPreferenceStore(MakeUIPlugin.getDefault().getPreferenceStore());
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return this.getOutlinePage();
        }
        return super.getAdapter(clazz);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        super.doSave(iProgressMonitor);
        if (this.page != null) {
            this.page.update();
        }
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle resourceBundle = MakeUIPlugin.getDefault().getResourceBundle();
        Object object = new TextOperationAction(resourceBundle, "ContentAssistProposal.", (ITextEditor)this, 13);
        object.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)object);
        object = new TextOperationAction(resourceBundle, "ContentAssistTip.", (ITextEditor)this, 14);
        object.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)object);
        object = new TextOperationAction(resourceBundle, "Comment.", (ITextEditor)this, 11);
        object.setActionDefinitionId("org.eclipse.cdt.make.ui.edit.text.makefile.uncomment");
        this.setAction("Comment", (IAction)object);
        this.markAsStateDependentAction("Comment", true);
        object = new TextOperationAction(resourceBundle, "Uncomment.", (ITextEditor)this, 12);
        object.setActionDefinitionId("org.eclipse.cdt.make.ui.edit.text.makefile.comment");
        this.setAction("Uncomment", (IAction)object);
        this.markAsStateDependentAction("Uncomment", true);
        object = new OpenDeclarationAction((ITextEditor)this);
        object.setActionDefinitionId("org.eclipse.cdt.make.ui.edit.text.makefile.open_declaration");
        this.setAction("OpenDeclarationAction", (IAction)object);
        this.markAsStateDependentAction("OpenDeclarationAction", true);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection.isEmpty()) {
            this.resetHighlightRange();
        } else if (iSelection instanceof IStructuredSelection) {
            Object object;
            if (!this.isActivePart() && MakeUIPlugin.getActivePage() != null) {
                MakeUIPlugin.getActivePage().bringToTop((IWorkbenchPart)this);
            }
            if ((object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof IDirective) {
                IDirective iDirective = (IDirective)object;
                this.setSelection(iDirective, !this.isActivePart());
            }
        }
    }

    private boolean isActivePart() {
        IWorkbenchWindow iWorkbenchWindow = this.getSite().getWorkbenchWindow();
        IPartService iPartService = iWorkbenchWindow.getPartService();
        IWorkbenchPart iWorkbenchPart = iPartService.getActivePart();
        return iWorkbenchPart != null && iWorkbenchPart.equals((Object)this);
    }

    private FindReplaceDocumentAdapter getFindRepalceDocumentAdapter() {
        if (this.fFindReplaceDocumentAdapter == null) {
            IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            this.fFindReplaceDocumentAdapter = new FindReplaceDocumentAdapter(iDocument);
        }
        return this.fFindReplaceDocumentAdapter;
    }

    public void setSelection(IDirective iDirective, boolean bl) {
        int n = iDirective.getStartLine() - 1;
        int n2 = iDirective.getEndLine() - 1;
        try {
            IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            int n3 = iDocument.getLineOffset(n);
            int n4 = iDocument.getLineLength(n2) - 1;
            int n5 = iDocument.getLineOffset(n2) + n4 - n3;
            this.setHighlightRange(n3, n5, true);
            if (bl) {
                IRegion iRegion;
                String string = iDirective.toString().trim();
                MakefileWordDetector makefileWordDetector = new MakefileWordDetector();
                n4 = 0;
                while (n4 < string.length()) {
                    char c = string.charAt(n4);
                    if (!makefileWordDetector.isWordPart(c) && !makefileWordDetector.isWordStart(c) && c != '-' && c != '_') break;
                    ++n4;
                }
                if (n4 > 0) {
                    string = string.substring(0, n4);
                }
                if ((iRegion = this.getFindRepalceDocumentAdapter().find(n3, string, true, true, true, false)) != null) {
                    n4 = iRegion.getOffset();
                    n5 = iRegion.getLength();
                    this.getSourceViewer().revealRange(n4, n5);
                    this.getSourceViewer().setSelectedRange(n4, n5);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.resetHighlightRange();
        }
        catch (BadLocationException badLocationException) {
            this.resetHighlightRange();
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        super.editorContextMenuAboutToShow(iMenuManager);
        this.addAction(iMenuManager, "group.edit", "Comment");
        this.addAction(iMenuManager, "group.edit", "Uncomment");
    }
}

