/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.editor.MakefileEditor;
import org.eclipse.cdt.make.internal.ui.text.WordPartDetector;
import org.eclipse.cdt.make.ui.IWorkingCopyManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class OpenDeclarationAction
extends TextEditorAction {
    public OpenDeclarationAction() {
        this(null);
    }

    public OpenDeclarationAction(ITextEditor iTextEditor) {
        super(MakeUIPlugin.getDefault().getResourceBundle(), "OpenDeclarationAction.", iTextEditor);
    }

    public void run() {
        ITextEditor iTextEditor = this.getTextEditor();
        if (iTextEditor == null) {
            return;
        }
        ISelectionProvider iSelectionProvider = iTextEditor.getSelectionProvider();
        if (iSelectionProvider == null) {
            return;
        }
        IDirective[] iDirectiveArray = null;
        IWorkingCopyManager iWorkingCopyManager = MakeUIPlugin.getDefault().getWorkingCopyManager();
        IMakefile iMakefile = iWorkingCopyManager.getWorkingCopy(iTextEditor.getEditorInput());
        if (iMakefile != null) {
            IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
            IDocument iDocument = iDocumentProvider.getDocument((Object)iTextEditor.getEditorInput());
            try {
                ITextSelection iTextSelection = (ITextSelection)iSelectionProvider.getSelection();
                int n = iTextSelection.getOffset();
                WordPartDetector wordPartDetector = new WordPartDetector(iDocument, iTextSelection.getOffset());
                String string = wordPartDetector.toString();
                if (WordPartDetector.inMacro(iDocument, n)) {
                    iDirectiveArray = iMakefile.getMacroDefinitions(string);
                    if (iDirectiveArray.length == 0) {
                        iDirectiveArray = iMakefile.getBuiltinMacroDefinitions(string);
                    }
                } else {
                    iDirectiveArray = iMakefile.getTargetRules(string);
                }
                if (iDirectiveArray != null && iDirectiveArray.length > 0) {
                    OpenDeclarationAction.openInEditor(iDirectiveArray[0]);
                }
            }
            catch (Exception exception) {}
        }
    }

    private static IEditorPart openInEditor(IDirective iDirective) throws PartInitException {
        IWorkbenchPage iWorkbenchPage;
        String string = iDirective.getFileName();
        Path path = new Path(string);
        IFile iFile = MakeUIPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (iFile != null && (iWorkbenchPage = MakeUIPlugin.getActivePage()) != null) {
            IEditorPart iEditorPart = IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
            if (iEditorPart instanceof MakefileEditor) {
                ((MakefileEditor)iEditorPart).setSelection(iDirective, true);
            }
            return iEditorPart;
        }
        return null;
    }
}

