/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.part;

import java.text.MessageFormat;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.part.CheckboxTablePart;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class WizardCheckboxTablePart
extends CheckboxTablePart {
    public static final String KEY_SELECT_ALL = MakeUIPlugin.getResourceString("WizardCheckboxTablePart.WizardCheckboxTablePart.selectAll");
    public static final String KEY_DESELECT_ALL = MakeUIPlugin.getResourceString("WizardCheckboxTablePart.WizardCheckboxTablePart.deselectAll");
    public static final String KEY_COUNTER = MakeUIPlugin.getResourceString("WizardCheckboxTablePart.WizardCheckboxTablePart.counter");
    private final String EMPTY_STRING = "";
    private int selectAllIndex = -1;
    private int deselectAllIndex = -1;
    private String tableName;
    private int counter;
    private Label counterLabel;

    public WizardCheckboxTablePart(String string, String[] stringArray) {
        super(stringArray);
        this.tableName = string;
    }

    public WizardCheckboxTablePart(String string) {
        this(string, new String[]{MakeUIPlugin.getResourceString(KEY_SELECT_ALL), MakeUIPlugin.getResourceString(KEY_DESELECT_ALL)});
        this.setSelectAllIndex(0);
        this.setDeselectAllIndex(1);
    }

    public void setSelectAllIndex(int n) {
        this.selectAllIndex = n;
    }

    public void setDeselectAllIndex(int n) {
        this.deselectAllIndex = n;
    }

    protected void buttonSelected(Button button, int n) {
        if (n == this.selectAllIndex) {
            this.handleSelectAll(true);
        }
        if (n == this.deselectAllIndex) {
            this.handleSelectAll(false);
        }
    }

    public Object[] getSelection() {
        CheckboxTableViewer checkboxTableViewer = this.getTableViewer();
        return checkboxTableViewer.getCheckedElements();
    }

    public void setSelection(Object[] objectArray) {
        CheckboxTableViewer checkboxTableViewer = this.getTableViewer();
        checkboxTableViewer.setCheckedElements(objectArray);
        this.updateCounter(objectArray.length);
    }

    public void createControl(Composite composite) {
        this.createControl(composite, 0, 2);
        this.counterLabel = new Label(composite, 0);
        GridData gridData = new GridData(258);
        gridData.horizontalSpan = 2;
        this.counterLabel.setLayoutData((Object)gridData);
        this.updateCounter(0);
    }

    protected Button createButton(Composite composite, String string, int n) {
        Button button = super.createButton(composite, string, n);
        return button;
    }

    protected StructuredViewer createStructuredViewer(Composite composite, int n) {
        StructuredViewer structuredViewer = super.createStructuredViewer(composite, n);
        return structuredViewer;
    }

    protected void createMainLabel(Composite composite, int n) {
        if (this.tableName == null) {
            return;
        }
        Label label = new Label(composite, 0);
        label.setText(this.tableName);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
    }

    protected void updateCounter(int n) {
        this.counter = n;
        this.updateCounterLabel();
    }

    protected void updateCounterLabel() {
        String string = "" + this.getSelectionCount();
        String string2 = "" + this.getTotalCount();
        String string3 = MessageFormat.format(MakeUIPlugin.getResourceString(KEY_COUNTER), string, string2);
        this.counterLabel.setText(string3);
    }

    public int getSelectionCount() {
        return this.counter;
    }

    public void selectAll(boolean bl) {
        this.handleSelectAll(bl);
    }

    private int getTotalCount() {
        CheckboxTableViewer checkboxTableViewer = this.getTableViewer();
        return checkboxTableViewer.getTable().getItemCount();
    }

    protected void handleSelectAll(boolean bl) {
        CheckboxTableViewer checkboxTableViewer = this.getTableViewer();
        checkboxTableViewer.setAllChecked(bl);
        int n = !bl ? 0 : this.getTotalCount();
        this.updateCounter(n);
    }

    protected void elementChecked(Object object, boolean bl) {
        int n = this.getSelectionCount();
        this.updateCounter(bl ? n + 1 : n - 1);
    }
}

