/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.properties;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.MakeProjectOptionBlock;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class MakePropertyPage
extends PropertyPage
implements ICOptionContainer {
    MakeProjectOptionBlock fOptionBlock = new MakeProjectOptionBlock();
    private static final String MSG_CLOSEDPROJECT = "MakeProjectPropertyPage.closedproject";

    public void setContainer(IPreferencePageContainer iPreferencePageContainer) {
        super.setContainer(iPreferencePageContainer);
        this.fOptionBlock.setOptionContainer(this);
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FillLayout());
        IProject iProject = this.getProject();
        if (!iProject.isOpen()) {
            this.contentForClosedProject(composite2);
        } else {
            this.contentForCProject(composite2);
        }
        return composite2;
    }

    private void contentForCProject(Composite composite) {
        this.fOptionBlock.createContents(composite);
    }

    private void contentForClosedProject(Composite composite) {
        Label label = new Label(composite, 16384);
        label.setText(MakeUIPlugin.getResourceString(MSG_CLOSEDPROJECT));
        label.setFont(composite.getFont());
        this.noDefaultAndApplyButton();
    }

    public boolean performOk() {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                MakePropertyPage.this.fOptionBlock.performApply(iProgressMonitor);
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), iRunnableWithProgress, (ISchedulingRule)MakeUIPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            MakeUIPlugin.errorDialog(this.getShell(), MakeUIPlugin.getResourceString("MakeProjectPropertyPage.internalError"), throwable.toString(), throwable);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public IProject getProject() {
        IAdaptable iAdaptable = this.getElement();
        if (iAdaptable instanceof IProject) {
            return (IProject)iAdaptable;
        }
        return null;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.fOptionBlock.setVisible(bl);
    }

    public void updateContainer() {
        this.fOptionBlock.update();
        this.setValid(this.fOptionBlock.isValid());
        this.setErrorMessage(this.fOptionBlock.getErrorMessage());
    }

    protected void performDefaults() {
        this.fOptionBlock.performDefaults();
        super.performDefaults();
    }

    public boolean isValid() {
        this.updateContainer();
        return super.isValid();
    }

    public Preferences getPreferences() {
        return MakeCorePlugin.getDefault().getPluginPreferences();
    }
}

