/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.scannerconfig;

import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.scannerconfig.DiscoveredElement;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class DiscoveredElementLabelProvider
extends LabelProvider
implements IColorProvider {
    private final Color inDirect = new Color((Device)Display.getDefault(), new RGB(170, 170, 170));
    private ImageDescriptor fIncludeIcon;
    private ImageDescriptor fMacroIcon;
    private ImageDescriptor fContainerImage;
    private ImageDescriptor fRemovedIncludeIcon;
    private ImageDescriptor fRemovedMacroIcon;
    private ImageDescriptorRegistry fRegistry;
    private final String DISABLED_LABEL = MakeUIPlugin.getResourceString("ManageScannerConfigDialogCommon.discoveredGroup.annotation.disabled");

    public DiscoveredElementLabelProvider() {
        this.fRegistry = CUIPlugin.getImageDescriptorRegistry();
        this.fIncludeIcon = CPluginImages.DESC_OBJS_INCLUDES_FOLDER;
        this.fMacroIcon = CPluginImages.DESC_OBJS_MACRO;
        this.fContainerImage = CPluginImages.DESC_OBJS_LIBRARY;
    }

    public Image getImage(Object object) {
        DiscoveredElement discoveredElement;
        Image image;
        if (object instanceof DiscoveredElement && (image = this.composeImage(discoveredElement = (DiscoveredElement)object)) != null) {
            return image;
        }
        return super.getImage(object);
    }

    private Image composeImage(DiscoveredElement discoveredElement) {
        Image image = null;
        switch (discoveredElement.getEntryKind()) {
            case 4: {
                image = CPluginImages.get((String)"org.eclipse.cdt.ui.includes_container.gif");
                break;
            }
            case 1: {
                image = this.fRegistry.get(this.fContainerImage);
                break;
            }
            case 2: {
                image = this.fRegistry.get(this.fIncludeIcon);
                break;
            }
            case 3: 
            case 5: {
                image = this.fRegistry.get(this.fMacroIcon);
            }
        }
        if (image != null && discoveredElement.isRemoved()) {
            image = new DiscoveredElementImageDescriptor(image, true).createImage();
        }
        return image;
    }

    public String getText(Object object) {
        if (object instanceof DiscoveredElement) {
            DiscoveredElement discoveredElement = (DiscoveredElement)object;
            switch (discoveredElement.getEntryKind()) {
                case 4: {
                    return CPathEntryMessages.getString((String)"CPElementLabelProvider.Includes");
                }
                case 5: {
                    return CPathEntryMessages.getString((String)"CPElementLabelProvider.PreprocessorSymbols");
                }
                case 1: 
                case 2: 
                case 3: {
                    return String.valueOf(discoveredElement.getEntry()) + (discoveredElement.isRemoved() ? this.addAnnotation(this.DISABLED_LABEL) : "");
                }
            }
        }
        return super.getText(object);
    }

    private String addAnnotation(String string) {
        return " (" + string + ")";
    }

    public Color getForeground(Object object) {
        if (object instanceof DiscoveredElement) {
            DiscoveredElement discoveredElement = (DiscoveredElement)object;
            switch (discoveredElement.getEntryKind()) {
                case 2: 
                case 3: {
                    if (!discoveredElement.isRemoved()) break;
                    return this.inDirect;
                }
            }
        }
        return null;
    }

    public Color getBackground(Object object) {
        return null;
    }

    private class DiscoveredElementImageDescriptor
    extends CompositeImageDescriptor {
        private Image fBaseImage;
        private boolean showRemoved;
        private Point fSize;

        public DiscoveredElementImageDescriptor(Image image, boolean bl) {
            this.fBaseImage = image;
            this.showRemoved = bl;
        }

        protected void drawCompositeImage(int n, int n2) {
            ImageData imageData = this.fBaseImage.getImageData();
            if (imageData == null) {
                imageData = ImageDescriptor.DEFAULT_IMAGE_DATA;
            }
            this.drawImage(imageData, 0, 0);
            this.drawOverlays();
        }

        protected void drawOverlays() {
            ImageData imageData = null;
            if (this.showRemoved) {
                imageData = CPluginImages.DESC_OVR_ERROR.getImageData();
                this.drawImage(imageData, 0, 0);
            }
        }

        protected Point getSize() {
            if (this.fSize == null) {
                ImageData imageData = this.fBaseImage.getImageData();
                this.fSize = new Point(imageData.width, imageData.height);
            }
            return this.fSize;
        }
    }
}

