/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.text.makefile;

import java.util.ArrayList;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefileSimpleMacroRule;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class MakefileMacroScanner
extends RuleBasedScanner {
    private String buffer;
    private static final String[] DELIMITERS = new String[]{"\r", "\n", "\r\n"};
    public static final String tokenText = "text";
    public static final String tokenMacro = "macro";
    public static final String tokenOther = "other";

    public MakefileMacroScanner(String string) {
        this.buffer = string;
        this.fOffset = 0;
        Token token = new Token((Object)tokenText);
        Token token2 = new Token((Object)tokenMacro);
        Token token3 = new Token((Object)tokenOther);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new PatternRule("\"", "\"", (IToken)token, '\\', true));
        arrayList.add(new PatternRule("'", "'", (IToken)token, '\\', true));
        arrayList.add((Object)new MakefileSimpleMacroRule((IToken)token2));
        arrayList.add(new WhitespaceRule(new IWhitespaceDetector(){

            public boolean isWhitespace(char c) {
                return Character.isWhitespace(c);
            }
        }));
        WordRule wordRule = new WordRule(new IWordDetector(){

            public boolean isWordPart(char c) {
                return this.isWordStart(c);
            }

            public boolean isWordStart(char c) {
                return (short)c != -1 && !Character.isSpaceChar(c);
            }
        }, (IToken)token3);
        arrayList.add(wordRule);
        IRule[] iRuleArray = new IRule[arrayList.size()];
        arrayList.toArray(iRuleArray);
        this.setRules(iRuleArray);
        this.setRange(null, 0, string.length());
    }

    public int getColumn() {
        return this.fOffset;
    }

    public int read() {
        int n = this.fOffset == this.buffer.length() ? -1 : (int)this.buffer.charAt(this.fOffset);
        ++this.fOffset;
        return n;
    }

    public void setRange(IDocument iDocument, int n, int n2) {
        this.fDocument = iDocument;
        this.fOffset = n;
        this.fRangeEnd = n + n2;
        this.fDelimiters = new char[DELIMITERS.length][];
        int n3 = 0;
        while (n3 < DELIMITERS.length) {
            this.fDelimiters[n3] = DELIMITERS[n3].toCharArray();
            ++n3;
        }
    }
}

