/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.text.makefile;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;

public class MakefilePartitionScanner
extends RuleBasedPartitionScanner {
    public static final String MAKEFILE_COMMENT = "makefile_comment";
    public static final String MAKEFILE_MACRO_ASSIGNEMENT = "makefile_macro_assignement";
    public static final String MAKEFILE_INCLUDE_BLOCK = "makefile_include_block";
    public static final String MAKEFILE_IF_BLOCK = "makefile_if_block";
    public static final String MAKEFILE_DEF_BLOCK = "makefile_def_block";
    public static final String MAKEFILE_OTHER = "makefile_other";
    public static final String[] TYPES = new String[]{"makefile_comment", "makefile_macro_assignement", "makefile_include_block", "makefile_if_block", "makefile_def_block", "makefile_other"};
    private char[][] fModDelimiters = new char[][]{{'\r', '\n'}, {'\r'}, {'\n'}};

    public MakefilePartitionScanner() {
        Token token = new Token((Object)MAKEFILE_COMMENT);
        Token token2 = new Token((Object)MAKEFILE_MACRO_ASSIGNEMENT);
        Token token3 = new Token((Object)MAKEFILE_INCLUDE_BLOCK);
        Token token4 = new Token((Object)MAKEFILE_IF_BLOCK);
        Token token5 = new Token((Object)MAKEFILE_DEF_BLOCK);
        Token token6 = new Token((Object)MAKEFILE_OTHER);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new EndOfLineRule("#", (IToken)token, '\\'));
        arrayList.add(new EndOfLineRule("include", (IToken)token3));
        arrayList.add(new EndOfLineRule("export", (IToken)token5));
        arrayList.add(new EndOfLineRule("unexport", (IToken)token5));
        arrayList.add(new EndOfLineRule("vpath", (IToken)token5));
        arrayList.add(new EndOfLineRule("override", (IToken)token5));
        arrayList.add(new MultiLineRule("define", "endef", (IToken)token5));
        arrayList.add(new MultiLineRule("override define", "endef", (IToken)token5));
        arrayList.add(new MultiLineRule("ifdef", "endif", (IToken)token4));
        arrayList.add(new MultiLineRule("ifndef", "endif", (IToken)token4));
        arrayList.add(new MultiLineRule("ifeq", "endif", (IToken)token4));
        arrayList.add(new MultiLineRule("ifnneq", "endif", (IToken)token4));
        arrayList.add(new MacroRule((IToken)token2, (IToken)token6));
        IPredicateRule[] iPredicateRuleArray = new IPredicateRule[arrayList.size()];
        arrayList.toArray(iPredicateRuleArray);
        this.setPredicateRules(iPredicateRuleArray);
    }

    public char[][] getLegalLineDelimiters() {
        return this.fModDelimiters;
    }

    private class MacroRule
    implements IPredicateRule {
        private static final int INIT_STATE = 0;
        private static final int VAR_STATE = 1;
        private static final int END_VAR_STATE = 2;
        private static final int EQUAL_STATE = 3;
        private static final int FINISH_STATE = 4;
        private static final int ERROR_STATE = 5;
        private IToken token;
        private StringBuffer buffer = new StringBuffer();
        protected IToken defaultToken;

        public MacroRule(IToken iToken, IToken iToken2) {
            this.token = iToken;
            this.defaultToken = iToken2;
        }

        public IToken getSuccessToken() {
            return this.token;
        }

        public IToken evaluate(ICharacterScanner iCharacterScanner, boolean bl) {
            this.buffer.setLength(0);
            int n = 0;
            if (bl) {
                this.scanToBeginOfLine(iCharacterScanner);
            }
            int n2 = iCharacterScanner.read();
            while (n2 != -1) {
                switch (n) {
                    case 0: {
                        if (n2 != 10 && Character.isWhitespace((char)n2)) break;
                        if (this.isValidCharacter(n2)) {
                            n = 1;
                            break;
                        }
                        n = 5;
                        break;
                    }
                    case 1: {
                        if (this.isValidCharacter(n2)) break;
                    }
                    case 2: {
                        if (n2 != 10 && Character.isWhitespace((char)n2)) {
                            n = 2;
                            break;
                        }
                        if (n2 == 58 || n2 == 43) {
                            n = 3;
                            break;
                        }
                        if (n2 == 61) {
                            n = 4;
                            break;
                        }
                        if (n == 2) {
                            iCharacterScanner.unread();
                        }
                        n = 5;
                        break;
                    }
                    case 3: {
                        if (n2 == 61) {
                            n = 4;
                            break;
                        }
                        n = 5;
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                if (n >= 4) break;
                this.buffer.append((char)n2);
                n2 = iCharacterScanner.read();
            }
            iCharacterScanner.unread();
            if (n == 4) {
                this.scanToEndOfLine(iCharacterScanner);
                return this.token;
            }
            if (this.defaultToken.isUndefined()) {
                this.unreadBuffer(iCharacterScanner);
            }
            return Token.UNDEFINED;
        }

        public IToken evaluate(ICharacterScanner iCharacterScanner) {
            return this.evaluate(iCharacterScanner, false);
        }

        protected void unreadBuffer(ICharacterScanner iCharacterScanner) {
            int n = this.buffer.length() - 1;
            while (n >= 0) {
                iCharacterScanner.unread();
                --n;
            }
        }

        private void scanToEndOfLine(ICharacterScanner iCharacterScanner) {
            int n;
            char[][] cArray = iCharacterScanner.getLegalLineDelimiters();
            while ((n = iCharacterScanner.read()) != -1) {
                int n2 = 0;
                while (n2 < cArray.length) {
                    if (n == cArray[n2][0] && this.sequenceDetected(iCharacterScanner, cArray[n2])) {
                        return;
                    }
                    ++n2;
                }
            }
        }

        private void scanToBeginOfLine(ICharacterScanner iCharacterScanner) {
            while (iCharacterScanner.getColumn() != 0) {
                iCharacterScanner.unread();
            }
        }

        private boolean sequenceDetected(ICharacterScanner iCharacterScanner, char[] cArray) {
            int n = 1;
            while (n < cArray.length) {
                int n2 = iCharacterScanner.read();
                if (n2 == -1) {
                    return true;
                }
                if (n2 != cArray[n]) {
                    while (n > 0) {
                        iCharacterScanner.unread();
                        --n;
                    }
                    return false;
                }
                ++n;
            }
            return true;
        }

        protected boolean isValidCharacter(int n) {
            char c = (char)n;
            return Character.isLetterOrDigit(c) || c == '_';
        }
    }
}

