/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.text.makefile;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.PatternRule;

public class MakefileSimpleMacroRule
extends PatternRule {
    private int nOfBrackets;

    public MakefileSimpleMacroRule(IToken iToken) {
        super("$(", ")", iToken, '\u0000', true);
    }

    protected IToken doEvaluate(ICharacterScanner iCharacterScanner, boolean bl) {
        this.nOfBrackets = 1;
        return super.doEvaluate(iCharacterScanner, bl);
    }

    protected boolean endSequenceDetected(ICharacterScanner iCharacterScanner) {
        int n;
        char[][] cArray = iCharacterScanner.getLegalLineDelimiters();
        while ((n = iCharacterScanner.read()) != -1) {
            if ('(' == (char)n) {
                ++this.nOfBrackets;
            }
            if (this.fEndSequence.length > 0 && n == this.fEndSequence[0]) {
                if (!this.sequenceDetected(iCharacterScanner, this.fEndSequence, true) || --this.nOfBrackets != 0) continue;
                return true;
            }
            if (!this.fBreaksOnEOL) continue;
            int n2 = 0;
            while (n2 < cArray.length) {
                if (n == cArray[n2][0] && this.sequenceDetected(iCharacterScanner, cArray[n2], false)) {
                    return true;
                }
                ++n2;
            }
        }
        iCharacterScanner.unread();
        return true;
    }
}

