/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.text.makefile;

import org.eclipse.cdt.make.core.makefile.IMacroDefinition;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.text.WordPartDetector;
import org.eclipse.cdt.make.ui.IWorkingCopyManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;

public class MakefileTextHover
implements ITextHover {
    private IEditorPart fEditor;

    public MakefileTextHover(IEditorPart iEditorPart) {
        this.fEditor = iEditorPart;
    }

    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        if (iRegion != null) {
            try {
                int n = iRegion.getLength();
                int n2 = iRegion.getOffset();
                iTextViewer.getDocument().get(n2, n);
                if (this.fEditor != null && n > -1) {
                    IWorkingCopyManager iWorkingCopyManager = MakeUIPlugin.getDefault().getWorkingCopyManager();
                    IMakefile iMakefile = iWorkingCopyManager.getWorkingCopy(this.fEditor.getEditorInput());
                    WordPartDetector wordPartDetector = new WordPartDetector(iTextViewer, n2);
                    String string = wordPartDetector.toString();
                    IMacroDefinition[] iMacroDefinitionArray = null;
                    if (WordPartDetector.inMacro(iTextViewer, n2) && ((iMacroDefinitionArray = iMakefile.getMacroDefinitions(string)) == null || iMacroDefinitionArray.length == 0)) {
                        iMacroDefinitionArray = iMakefile.getBuiltinMacroDefinitions(string);
                    }
                    if (iMacroDefinitionArray == null) {
                        iMacroDefinitionArray = new IMacroDefinition[]{};
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    int n3 = 0;
                    while (n3 < iMacroDefinitionArray.length) {
                        if (n3 > 0) {
                            stringBuffer.append("\n");
                        }
                        String string2 = iMacroDefinitionArray[n3].getValue().toString();
                        stringBuffer.append(string);
                        stringBuffer.append(" - ");
                        stringBuffer.append(string2);
                        ++n3;
                    }
                    return stringBuffer.toString();
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return "";
    }

    public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
        Point point = iTextViewer.getSelectedRange();
        if (point.x <= n && n < point.x + point.y) {
            return new Region(point.x, point.y);
        }
        return new Region(n, 0);
    }
}

