/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeBuilder;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.wizards.UpdateMakeProjectWizard;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class UpdateMakeProjectAction
implements IWorkbenchWindowActionDelegate {
    private ISelection fSelection;
    static /* synthetic */ Class class$0;

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
    }

    public void run(IAction iAction) {
        if (this.fSelection instanceof IStructuredSelection) {
            IProject iProject;
            Object object;
            Object[] objectArray = ((IStructuredSelection)this.fSelection).toArray();
            ArrayList<IProject> arrayList = new ArrayList<IProject>(objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                object = objectArray[n];
                iProject = null;
                if (object instanceof IFile) {
                    IFile iFile = (IFile)object;
                    iProject = iFile.getProject();
                } else if (object instanceof IProject) {
                    iProject = (IProject)object;
                } else if (object instanceof ICProject) {
                    iProject = ((ICProject)object).getProject();
                }
                if (iProject != null) {
                    arrayList.add(iProject);
                }
                ++n;
            }
            IProject[] iProjectArray = arrayList.toArray(new IProject[arrayList.size()]);
            object = new UpdateMakeProjectWizard(iProjectArray);
            iProject = new WizardDialog(MakeUIPlugin.getActiveWorkbenchShell(), (IWizard)object);
            iProject.open();
        }
    }

    public static IProject[] getOldProjects() {
        IProject[] iProjectArray = MakeUIPlugin.getWorkspace().getRoot().getProjects();
        Vector<IProject> vector = new Vector<IProject>();
        try {
            int n = 0;
            while (n < iProjectArray.length) {
                if (UpdateMakeProjectAction.isOldProject(iProjectArray[n])) {
                    vector.add(iProjectArray[n]);
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            MakeUIPlugin.logException(coreException);
        }
        return vector.toArray(new IProject[vector.size()]);
    }

    protected static boolean isOldProject(IProject iProject) throws CoreException {
        if (iProject.isAccessible()) {
            IProjectDescription iProjectDescription = iProject.getDescription();
            ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
            int n = 0;
            while (n < iCommandArray.length) {
                if (iCommandArray[n].getBuilderName().equals("org.eclipse.cdt.core.cbuilder")) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static void run(boolean bl, IRunnableContext iRunnableContext, final IProject[] iProjectArray) {
        try {
            iRunnableContext.run(bl, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(this, iProjectArray){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ IProject[] val$projects;
                            {
                                this.this$1 = var1_1;
                                this.val$projects = iProjectArray;
                            }

                            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                                UpdateMakeProjectAction.doProjectUpdate(iProgressMonitor, this.val$projects);
                            }
                        };
                        MakeUIPlugin.getWorkspace().run(iWorkspaceRunnable, iProgressMonitor);
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException(operationCanceledException.getMessage());
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            MakeUIPlugin.logException(invocationTargetException, MakeUIPlugin.getResourceString("UpdateMakeProjectAction.exception.error"), MakeUIPlugin.getResourceString("UpdateMakeProjectAction.eception.message"));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void doProjectUpdate(IProgressMonitor iProgressMonitor, IProject[] iProjectArray) throws CoreException {
        iProgressMonitor.beginTask(MakeUIPlugin.getResourceString("UpdateMakeProjectAction.monitor.update"), iProjectArray.length * 4);
        try {
            int n = 0;
            block3: while (n < iProjectArray.length) {
                iProjectArray[n].refreshLocal(1, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                MakeProjectNature.removeFromBuildSpec((IProject)iProjectArray[n], (String)"org.eclipse.cdt.core.cbuilder", (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                CCorePlugin.getDefault().mapCProjectOwner(iProjectArray[n], MakeCorePlugin.MAKE_PROJECT_ID, true);
                MakeProjectNature.addNature((IProject)iProjectArray[n], (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                IMakeBuilderInfo iMakeBuilderInfo = MakeCorePlugin.createBuildInfo((IProject)iProjectArray[n], (String)MakeBuilder.BUILDER_ID);
                QualifiedName[] qualifiedNameArray = new QualifiedName[]{new QualifiedName("org.eclipse.cdt.core", "buildLocation"), new QualifiedName("org.eclipse.cdt.core", "buildFullArguments"), new QualifiedName("org.eclipse.cdt.core", "buildIncrementalArguments"), new QualifiedName("org.eclipse.cdt.core", "stopOnError"), new QualifiedName("org.eclipse.cdt.core", "useDefaultBuildCmd")};
                String string = iProjectArray[n].getPersistentProperty(qualifiedNameArray[0]);
                if (string != null) {
                    iMakeBuilderInfo.setBuildCommand((IPath)new Path(string));
                }
                if ((string = iProjectArray[n].getPersistentProperty(qualifiedNameArray[1])) != null) {
                    iMakeBuilderInfo.setBuildArguments(string);
                }
                if ((string = iProjectArray[n].getPersistentProperty(qualifiedNameArray[3])) != null) {
                    iMakeBuilderInfo.setStopOnError(Boolean.valueOf(string).booleanValue());
                }
                if ((string = iProjectArray[n].getPersistentProperty(qualifiedNameArray[4])) != null) {
                    iMakeBuilderInfo.setUseDefaultBuildCmd(Boolean.valueOf(string).booleanValue());
                }
                int n2 = 0;
                while (true) {
                    if (n2 >= qualifiedNameArray.length) {
                        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1, 4);
                        iProjectArray[n].accept((IResourceProxyVisitor)new TargetConvertVisitor((IProgressMonitor)subProgressMonitor), 0);
                        iProgressMonitor.worked(1);
                        ++n;
                        continue block3;
                    }
                    iProjectArray[n].setPersistentProperty(qualifiedNameArray[n2], null);
                    ++n2;
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        iProgressMonitor.done();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        Object object;
        boolean bl = false;
        this.fSelection = iSelection;
        if (this.fSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)this.fSelection).getFirstElement()) instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IResource iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
            try {
                if (iResource instanceof IProject && UpdateMakeProjectAction.isOldProject((IProject)iResource)) {
                    bl = true;
                }
            }
            catch (CoreException coreException) {}
        }
        iAction.setEnabled(bl);
    }

    public static class TargetConvertVisitor
    implements IResourceProxyVisitor {
        private final int TOTAL_WORK = 100;
        private int halfWay = 50;
        private int currentIncrement;
        private int nextProgress = this.currentIncrement = 4;
        private int worked = 0;
        IProgressMonitor monitor;

        public TargetConvertVisitor(IProgressMonitor iProgressMonitor) {
            this.monitor = iProgressMonitor;
            iProgressMonitor.beginTask(MakeUIPlugin.getResourceString("UpdateMakeProjectAction.monitor.convert"), 100);
        }

        public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
            block9: {
                block7: {
                    block8: {
                        try {
                            if (iResourceProxy.getType() == 2 || iResourceProxy.getType() == 4) break block7;
                            Object var8_2 = null;
                            if (--this.nextProgress > 0) break block8;
                        }
                        catch (Throwable throwable) {
                            block10: {
                                Object var8_4 = null;
                                if (--this.nextProgress > 0) break block10;
                                this.monitor.worked(1);
                                ++this.worked;
                                if (this.worked >= this.halfWay) {
                                    this.currentIncrement *= 2;
                                    this.halfWay += (100 - this.halfWay) / 2;
                                }
                                this.nextProgress = this.currentIncrement;
                            }
                            throw throwable;
                        }
                        this.monitor.worked(1);
                        ++this.worked;
                        if (this.worked >= this.halfWay) {
                            this.currentIncrement *= 2;
                            this.halfWay += (100 - this.halfWay) / 2;
                        }
                        this.nextProgress = this.currentIncrement;
                    }
                    return false;
                }
                IContainer iContainer = (IContainer)iResourceProxy.requestResource();
                this.monitor.subTask(iContainer.getProjectRelativePath().toString());
                QualifiedName qualifiedName = new QualifiedName("org.eclipse.cdt.make", "goals");
                String string = iContainer.getPersistentProperty(qualifiedName);
                if (string != null) {
                    string = string.trim();
                    IMakeTargetManager iMakeTargetManager = MakeCorePlugin.getDefault().getTargetManager();
                    String[] stringArray = iMakeTargetManager.getTargetBuilders(iContainer.getProject());
                    IMakeTarget iMakeTarget = iMakeTargetManager.createTarget(iContainer.getProject(), string, stringArray[0]);
                    iMakeTarget.setBuildTarget(string);
                    iMakeTargetManager.addTarget(iContainer, iMakeTarget);
                    iContainer.setPersistentProperty(qualifiedName, null);
                }
                Object var8_3 = null;
                if (--this.nextProgress > 0) break block9;
                this.monitor.worked(1);
                ++this.worked;
                if (this.worked >= this.halfWay) {
                    this.currentIncrement *= 2;
                    this.halfWay += (100 - this.halfWay) / 2;
                }
                this.nextProgress = this.currentIncrement;
            }
            return true;
        }
    }
}

