/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigNature;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.IMakeHelpContextIds;
import org.eclipse.cdt.make.ui.dialogs.ManageDefinedSymbolsDialog;
import org.eclipse.cdt.make.ui.dialogs.ManageIncludePathsDialog;
import org.eclipse.cdt.make.ui.dialogs.ScannerConfigOptionsDialog;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class BuildPathInfoBlock
extends AbstractCOptionPage {
    private static final int PROJECT_LIST_MULTIPLIER = 15;
    private static final int INITIAL_LIST_WIDTH = 60;
    private static final String PREF_SYMBOLS = "ScannerSymbols";
    private static final String PREF_INCLUDES = "ScannerIncludes";
    private static final String PREFIX = "BuildPathInfoBlock";
    private static final String LABEL = "BuildPathInfoBlock.label";
    private static final String PATHS = "BuildPathInfoBlock.paths";
    private static final String SYMBOLS = "BuildPathInfoBlock.symbols";
    private static final String MANAGE = "BuildPropertyCommon.label.manage";
    private static final String SC_GROUP_LABEL = "BuildPathInfoBlock.scGroup.label";
    private static final String SC_ENABLED_LABEL = "BuildPathInfoBlock.scGroup.enabled.label";
    private static final String SC_OPTIONS_LABEL = "BuildPathInfoBlock.scGroup.options.label";
    private static final String MISSING_BUILDER_MSG = "ScannerConfigOptionsDialog.label.missingBuilderInformation";
    private Button scEnabledButton;
    private Button scOptionsButton;
    private List pathList;
    private List symbolList;
    private Composite pathButtonComp;
    private Button managePathsButton;
    private Composite symbolButtonComp;
    private Button manageSymbolsButton;
    private ScannerConfigOptionsDialog scOptionsDialog;
    private ManageIncludePathsDialog manageIncludesDialog;
    private ManageDefinedSymbolsDialog manageSymbolsDialog;
    private boolean needsSCNature = false;

    public BuildPathInfoBlock() {
        super(MakeUIPlugin.getResourceString(LABEL));
        this.setDescription(MakeUIPlugin.getResourceString("BuildPathInfoBlock.description"));
    }

    private void createPathListButtons(Composite composite) {
        if (this.manageIncludesDialog == null) {
            this.manageIncludesDialog = new ManageIncludePathsDialog(this.getShell(), this.getContainer());
        }
        this.pathButtonComp = ControlFactory.createComposite((Composite)composite, (int)1);
        ((GridData)this.pathButtonComp.getLayoutData()).verticalAlignment = 1;
        ((GridData)this.pathButtonComp.getLayoutData()).grabExcessHorizontalSpace = false;
        this.pathButtonComp.setFont(composite.getFont());
        this.managePathsButton = ControlFactory.createPushButton((Composite)this.pathButtonComp, (String)MakeUIPlugin.getResourceString(MANAGE));
        this.managePathsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildPathInfoBlock.this.handleManagePaths();
            }
        });
        this.managePathsButton.setFont(composite.getFont());
        this.managePathsButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.managePathsButton);
    }

    protected void handleManagePaths() {
        if (this.manageIncludesDialog.open() == 0) {
            this.pathList.setItems(this.manageIncludesDialog.getManagedIncludes());
        }
    }

    private void createPathListControl(Composite composite, int n) {
        this.pathList = new List(composite, 2820);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = n - 1;
        gridData.heightHint = BuildPathInfoBlock.getDefaultFontHeight((Control)this.pathList, 15);
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        this.pathList.setLayoutData((Object)gridData);
        this.pathList.setFont(composite.getFont());
    }

    private static int getDefaultFontHeight(Control control, int n) {
        FontData[] fontDataArray = control.getFont().getFontData();
        int n2 = 10;
        if (fontDataArray.length > 0) {
            n2 = fontDataArray[0].getHeight();
        }
        return n * n2;
    }

    private void createSymbolListButtons(Composite composite) {
        if (this.manageSymbolsDialog == null) {
            this.manageSymbolsDialog = new ManageDefinedSymbolsDialog(this.getShell(), this.getContainer());
        }
        this.symbolButtonComp = ControlFactory.createComposite((Composite)composite, (int)1);
        ((GridData)this.symbolButtonComp.getLayoutData()).verticalAlignment = 1;
        ((GridData)this.symbolButtonComp.getLayoutData()).grabExcessHorizontalSpace = false;
        this.symbolButtonComp.setFont(composite.getFont());
        this.manageSymbolsButton = ControlFactory.createPushButton((Composite)this.symbolButtonComp, (String)MakeUIPlugin.getResourceString(MANAGE));
        this.manageSymbolsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildPathInfoBlock.this.handleManageSymbols();
            }
        });
        this.manageSymbolsButton.setFont(composite.getFont());
        this.manageSymbolsButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.manageSymbolsButton);
    }

    protected void handleManageSymbols() {
        if (this.manageSymbolsDialog.open() == 0) {
            this.symbolList.setItems(this.manageSymbolsDialog.getManagedSymbols());
        }
    }

    private void createSymbolListControl(Composite composite, int n) {
        this.symbolList = new List(composite, 2820);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = n - 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = BuildPathInfoBlock.getDefaultFontHeight((Control)this.pathList, 15);
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        this.symbolList.setLayoutData((Object)gridData);
        this.symbolList.setFont(composite.getFont());
    }

    public void performApply(IProgressMonitor iProgressMonitor) throws CoreException {
        IProject iProject;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        if (this.scOptionsDialog.isInitialized()) {
            try {
                this.scOptionsDialog.performApply(iProgressMonitor);
            }
            catch (CoreException coreException) {}
        }
        if ((iProject = this.getContainer().getProject()) != null) {
            iProgressMonitor.beginTask(MakeUIPlugin.getResourceString("BuildPathInfoBlock.monitor.settingScannerInfo"), 3);
            IDiscoveredPathManager.IDiscoveredPathInfo iDiscoveredPathInfo = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(iProject);
            boolean bl = this.manageIncludesDialog.saveTo(iDiscoveredPathInfo);
            iProgressMonitor.worked(1);
            iProgressMonitor.worked(1);
            if (bl |= this.manageSymbolsDialog.saveTo(iDiscoveredPathInfo)) {
                MakeCorePlugin.getDefault().getDiscoveryManager().updateDiscoveredInfo(iDiscoveredPathInfo);
            }
            iProgressMonitor.done();
        } else {
            this.setIncludes(MakeCorePlugin.getDefault().getPluginPreferences());
            this.setSymbols(MakeCorePlugin.getDefault().getPluginPreferences());
        }
    }

    public void performDefaults() {
        this.scOptionsDialog.performDefaults();
        this.scEnabledButton.setSelection(this.scOptionsDialog.isScannerConfigDiscoveryEnabled());
        this.handleScannerConfigEnable();
        this.pathList.removeAll();
        this.symbolList.removeAll();
        this.manageIncludesDialog.restore();
        this.manageSymbolsDialog.restore();
        this.getContainer().updateContainer();
    }

    private void setSymbols(Preferences preferences) {
        preferences.setValue(PREF_SYMBOLS, this.stringArrayToString(this.getSymbolListContents()));
    }

    private void setIncludes(Preferences preferences) {
        preferences.setValue(PREF_INCLUDES, this.stringArrayToString(this.getPathListContents()));
    }

    private String stringArrayToString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]).append(';');
            ++n;
        }
        return stringBuffer.toString();
    }

    static String[] getSymbols(Preferences preferences) {
        String string = preferences.getString(PREF_SYMBOLS);
        return BuildPathInfoBlock.parseStringToList(string);
    }

    static String[] getIncludes(Preferences preferences) {
        String string = preferences.getString(PREF_INCLUDES);
        return BuildPathInfoBlock.parseStringToList(string);
    }

    private static String[] parseStringToList(String string) {
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreElements()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return new String[0];
    }

    public void createControl(Composite composite) {
        int n = 3;
        Font font = composite.getFont();
        Composite composite2 = ControlFactory.createComposite((Composite)composite, (int)n);
        ((GridLayout)composite2.getLayout()).makeColumnsEqualWidth = false;
        composite2.setFont(font);
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IMakeHelpContextIds.MAKE_PATH_SYMBOL_SETTINGS);
        this.createScannerConfigControls(composite2, n);
        Label label = ControlFactory.createLabel((Composite)composite2, (String)MakeUIPlugin.getResourceString(PATHS));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        gridData.grabExcessHorizontalSpace = false;
        label.setLayoutData((Object)gridData);
        label.setFont(font);
        this.createPathListControl(composite2, n);
        this.createPathListButtons(composite2);
        Label label2 = ControlFactory.createLabel((Composite)composite2, (String)MakeUIPlugin.getResourceString(SYMBOLS));
        gridData = new GridData(768);
        gridData.horizontalSpan = n;
        gridData.grabExcessHorizontalSpace = false;
        label2.setLayoutData((Object)gridData);
        label2.setFont(font);
        this.createSymbolListControl(composite2, n);
        this.createSymbolListButtons(composite2);
        this.setListContents();
    }

    private void createScannerConfigControls(Composite composite, int n) {
        IProject iProject = this.getContainer().getProject();
        try {
            if (iProject != null && iProject.hasNature(MakeProjectNature.NATURE_ID) && !iProject.hasNature(ScannerConfigNature.NATURE_ID)) {
                this.needsSCNature = true;
            }
        }
        catch (CoreException coreException) {}
        if (this.scOptionsDialog == null) {
            this.scOptionsDialog = this.needsSCNature ? new ScannerConfigOptionsDialog(this.getContainer()) : new ScannerConfigOptionsDialog(this.getShell(), this.getContainer());
        }
        Group group = ControlFactory.createGroup((Composite)composite, (String)MakeUIPlugin.getResourceString(SC_GROUP_LABEL), (int)n);
        group.setFont(composite.getFont());
        ((GridData)group.getLayoutData()).grabExcessHorizontalSpace = false;
        ((GridData)group.getLayoutData()).horizontalSpan = n;
        ((GridData)group.getLayoutData()).horizontalAlignment = 4;
        ((GridLayout)group.getLayout()).marginWidth = 7;
        if (!this.needsSCNature && !this.scOptionsDialog.isInitialized()) {
            ControlFactory.createLabel((Composite)group, (String)MakeUIPlugin.getResourceString(MISSING_BUILDER_MSG));
            return;
        }
        this.scEnabledButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(SC_ENABLED_LABEL));
        this.scEnabledButton.setFont(composite.getFont());
        ((GridData)this.scEnabledButton.getLayoutData()).horizontalSpan = 2;
        ((GridData)this.scEnabledButton.getLayoutData()).grabExcessHorizontalSpace = true;
        this.scEnabledButton.setSelection(this.needsSCNature ? false : this.scOptionsDialog.isScannerConfigDiscoveryEnabled());
        this.scEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildPathInfoBlock.this.handleScannerConfigEnable();
            }
        });
        this.scOptionsButton = ControlFactory.createPushButton((Composite)group, (String)MakeUIPlugin.getResourceString(SC_OPTIONS_LABEL));
        this.scOptionsButton.setFont(composite.getFont());
        ((GridData)this.scOptionsButton.getLayoutData()).grabExcessHorizontalSpace = false;
        SWTUtil.setButtonDimensionHint((Button)this.scOptionsButton);
        this.scOptionsButton.setEnabled(this.scEnabledButton.getSelection());
        this.scOptionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildPathInfoBlock.this.scOptionsDialog.open();
            }
        });
    }

    protected void handleScannerConfigEnable() {
        boolean bl = this.scEnabledButton.getSelection();
        this.scOptionsButton.setEnabled(bl);
        if (bl && this.needsSCNature) {
            try {
                ScannerConfigNature.addScannerConfigNature((IProject)this.getContainer().getProject());
                this.scOptionsDialog = new ScannerConfigOptionsDialog(this.getShell(), this.getContainer());
                this.needsSCNature = false;
            }
            catch (CoreException coreException) {
                MakeCorePlugin.log((IStatus)coreException.getStatus());
            }
        }
        this.scOptionsDialog.setScannerConfigDiscoveryEnabled(bl);
    }

    private String[] getPathListContents() {
        return this.pathList.getItems();
    }

    private String[] getSymbolListContents() {
        return this.symbolList.getItems();
    }

    public boolean isValid() {
        return true;
    }

    private void setListContents() {
        IProject iProject = this.getContainer().getProject();
        if (iProject != null) {
            try {
                IDiscoveredPathManager.IDiscoveredPathInfo iDiscoveredPathInfo = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(iProject);
                this.pathList.setItems(ScannerConfigUtil.iPathArray2StringArray((IPath[])iDiscoveredPathInfo.getIncludePaths()));
                LinkedHashMap linkedHashMap = iDiscoveredPathInfo.getSymbolMap();
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(ScannerConfigUtil.scSymbolsSymbolEntryMap2List((Map)linkedHashMap, (boolean)true));
                this.symbolList.setItems(arrayList.toArray(new String[arrayList.size()]));
            }
            catch (CoreException coreException) {
                MakeCorePlugin.log((Throwable)coreException);
            }
        }
    }

    static class SelectPathInputDialog
    extends InputDialog {
        public SelectPathInputDialog(Shell shell, String string, String string2, String string3, IInputValidator iInputValidator) {
            super(shell, string, string2, string3, iInputValidator);
        }

        protected void createButtonsForButtonBar(Composite composite) {
            super.createButtonsForButtonBar(composite);
            Button button = this.createButton(composite, 3, MakeUIPlugin.getResourceString("BuildPathInfoBlock.button.browse"), true);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ SelectPathInputDialog this$1;
                {
                    this.this$1 = selectPathInputDialog;
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    String string;
                    DirectoryDialog directoryDialog = new DirectoryDialog(this.this$1.getShell(), 4096);
                    String string2 = SelectPathInputDialog.access$0(this.this$1).getText();
                    if (string2 != null && string2.trim().length() != 0) {
                        directoryDialog.setFilterPath(string2);
                    }
                    if ((string = directoryDialog.open()) != null) {
                        SelectPathInputDialog.access$0(this.this$1).setText(string);
                    }
                }
            });
        }

        static /* synthetic */ Text access$0(SelectPathInputDialog selectPathInputDialog) {
            return selectPathInputDialog.getText();
        }
    }
}

