/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.TargetBuild;
import org.eclipse.cdt.make.ui.TargetListViewerPart;
import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class BuildTargetDialog
extends Dialog {
    TargetListViewerPart targetPart;
    IContainer fContainer;

    public BuildTargetDialog(Shell shell, IContainer iContainer) {
        super(shell);
        this.fContainer = iContainer;
        this.targetPart = new TargetListViewerPart(this.fContainer);
    }

    public void setTarget(IMakeTarget iMakeTarget) {
        this.targetPart.setSelectedTarget(iMakeTarget);
    }

    public IMakeTarget getTarget() {
        return this.targetPart.getSelectedTarget();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(MakeUIPlugin.getResourceString("BuildTargetDialog.title.buildTarget"));
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, MakeUIPlugin.getResourceString("BuildTargetDialog.button.build"), true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getButton(0).setEnabled(this.targetPart.getSelectedTarget() != null);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        ((GridLayout)composite2.getLayout()).numColumns = 2;
        Label label = new Label(composite2, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(MakeUIPlugin.getResourceString("BuildTargetDialog.title.makeTargetsFor")) + this.fContainer.getFullPath().toString().substring(1));
        this.targetPart.createControl(composite2, 0, 2);
        gridData = (GridData)this.targetPart.getControl().getLayoutData();
        gridData.heightHint = this.convertHeightInCharsToPixels(15);
        gridData.widthHint = this.convertWidthInCharsToPixels(50);
        this.targetPart.getControl().setLayoutData((Object)gridData);
        this.targetPart.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                BuildTargetDialog.this.okPressed();
            }
        });
        this.targetPart.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                BuildTargetDialog.this.getButton(0).setEnabled(BuildTargetDialog.this.targetPart.getSelectedTarget() != null);
            }
        });
        return composite2;
    }

    protected void okPressed() {
        IMakeTarget iMakeTarget = this.targetPart.getSelectedTarget();
        super.okPressed();
        if (iMakeTarget != null) {
            TargetBuild.buildTargets(this.getParentShell(), new IMakeTarget[]{iMakeTarget});
        }
    }
}

