/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathContainer;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerInfoCollector;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.SymbolEntry;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.scannerconfig.DiscoveredElement;
import org.eclipse.cdt.make.internal.ui.scannerconfig.DiscoveredElementLabelProvider;
import org.eclipse.cdt.make.internal.ui.scannerconfig.DiscoveredElementSorter;
import org.eclipse.cdt.ui.wizards.ICPathContainerPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ActionHandler;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.commands.Priority;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;

public class DiscoveredPathContainerPage
extends WizardPage
implements ICPathContainerPage {
    private static final String PREFIX = "DiscoveredScannerConfigurationContainerPage";
    private static final String DISC_COMMON_PREFIX = "ManageScannerConfigDialogCommon";
    private static final String UP = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.up.label";
    private static final String DOWN = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.down.label";
    private static final String DISABLE = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.disable.label";
    private static final String ENABLE = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.enable.label";
    private static final String DELETE = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.delete.label";
    private static final String CONTAINER_LABEL = "DiscoveredScannerConfigurationContainerPage.title";
    private static final String CONTAINER_DESCRIPTION = "DiscoveredScannerConfigurationContainerPage.description";
    private static final String CONTAINER_LIST_LABEL = "DiscoveredScannerConfigurationContainerPage.list.title";
    private final int IDX_UP = 0;
    private final int IDX_DOWN = 1;
    private final int IDX_ENABLE = 2;
    private final int IDX_DISABLE = 3;
    private final int IDX_DELETE = 5;
    private static final int DISC_UP = 0;
    private static final int DISC_DOWN = 1;
    private static final int DO_DISABLE = 0;
    private static final int DO_ENABLE = 1;
    private ICProject fCProject;
    private IContainerEntry fPathEntry;
    private TreeListDialogField fDiscoveredContainerList;
    private boolean dirty;
    private CopyTextAction copyTextAction;
    private HandlerSubmission submission;

    public DiscoveredPathContainerPage() {
        super(PREFIX);
        this.setTitle(MakeUIPlugin.getResourceString(CONTAINER_LABEL));
        this.setDescription(MakeUIPlugin.getResourceString(CONTAINER_DESCRIPTION));
        this.setImageDescriptor(CPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        String[] stringArray = new String[6];
        stringArray[0] = MakeUIPlugin.getResourceString(UP);
        stringArray[1] = MakeUIPlugin.getResourceString(DOWN);
        stringArray[2] = MakeUIPlugin.getResourceString(ENABLE);
        stringArray[3] = MakeUIPlugin.getResourceString(DISABLE);
        stringArray[5] = MakeUIPlugin.getResourceString(DELETE);
        String[] stringArray2 = stringArray;
        DiscoveredContainerAdapter discoveredContainerAdapter = new DiscoveredContainerAdapter();
        this.fDiscoveredContainerList = new TreeListDialogField((ITreeListAdapter)discoveredContainerAdapter, stringArray2, (ILabelProvider)new DiscoveredElementLabelProvider());
        this.fDiscoveredContainerList.setDialogFieldListener((IDialogFieldListener)discoveredContainerAdapter);
        this.fDiscoveredContainerList.setLabelText(MakeUIPlugin.getResourceString(CONTAINER_LIST_LABEL));
        this.fDiscoveredContainerList.setViewerSorter((ViewerSorter)new DiscoveredElementSorter());
        this.dirty = false;
    }

    public void dispose() {
        this.deregisterActionHandlers();
        super.dispose();
    }

    public void initialize(ICProject iCProject, IPathEntry[] iPathEntryArray) {
        this.fCProject = iCProject;
    }

    public boolean finish() {
        if (!this.dirty) {
            return true;
        }
        try {
            Object[] objectArray;
            IDiscoveredPathManager.IDiscoveredPathInfo iDiscoveredPathInfo = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(this.fCProject.getProject());
            LinkedHashMap<String, Boolean> linkedHashMap = new LinkedHashMap<String, Boolean>();
            LinkedHashMap linkedHashMap2 = new LinkedHashMap();
            DiscoveredElement discoveredElement = (DiscoveredElement)this.fDiscoveredContainerList.getElement(0);
            if (discoveredElement != null && discoveredElement.getEntryKind() == 1 && (objectArray = discoveredElement.getChildren()) != null) {
                int n = 0;
                while (n < objectArray.length) {
                    DiscoveredElement discoveredElement2 = (DiscoveredElement)objectArray[n];
                    switch (discoveredElement2.getEntryKind()) {
                        case 4: {
                            DiscoveredElement discoveredElement3;
                            Object[] objectArray2 = discoveredElement2.getChildren();
                            if (objectArray2 == null) break;
                            int n2 = 0;
                            while (n2 < objectArray2.length) {
                                discoveredElement3 = (DiscoveredElement)objectArray2[n2];
                                linkedHashMap.put(discoveredElement3.getEntry(), discoveredElement3.isRemoved());
                                ++n2;
                            }
                            break;
                        }
                        case 5: {
                            DiscoveredElement discoveredElement3;
                            Object[] objectArray2 = discoveredElement2.getChildren();
                            if (objectArray2 == null) break;
                            int n2 = 0;
                            while (n2 < objectArray2.length) {
                                discoveredElement3 = (DiscoveredElement)objectArray2[n2];
                                ScannerConfigUtil.scAddSymbolString2SymbolEntryMap(linkedHashMap2, (String)discoveredElement3.getEntry(), (!discoveredElement3.isRemoved() ? 1 : 0) != 0);
                                ++n2;
                            }
                            break;
                        }
                    }
                    ++n;
                }
            }
            iDiscoveredPathInfo.setIncludeMap(linkedHashMap);
            iDiscoveredPathInfo.setSymbolMap(linkedHashMap2);
            try {
                MakeCorePlugin.getDefault().getDiscoveryManager().updateDiscoveredInfo(iDiscoveredPathInfo);
                return true;
            }
            catch (CoreException coreException) {
                MakeCorePlugin.log((Throwable)coreException);
            }
        }
        catch (CoreException coreException) {
            MakeCorePlugin.log((Throwable)coreException);
        }
        return false;
    }

    public IPathEntry[] getContainerEntries() {
        return new IPathEntry[]{this.fPathEntry};
    }

    public void setSelection(IPathEntry iPathEntry) {
        if (iPathEntry != null) {
            if (iPathEntry.getEntryKind() == 5) {
                this.fPathEntry = (IContainerEntry)iPathEntry;
            }
        } else {
            this.fPathEntry = CoreModel.newContainerEntry((IPath)DiscoveredPathContainer.CONTAINER_ID);
        }
        if (this.fPathEntry != null) {
            DiscoveredElement discoveredElement = this.populateDiscoveredElements(this.fPathEntry);
            ArrayList<DiscoveredElement> arrayList = new ArrayList<DiscoveredElement>();
            arrayList.add(discoveredElement);
            this.fDiscoveredContainerList.addElements(arrayList);
        }
    }

    private DiscoveredElement populateDiscoveredElements(IContainerEntry iContainerEntry) {
        DiscoveredElement discoveredElement = null;
        try {
            IDiscoveredPathManager.IDiscoveredPathInfo iDiscoveredPathInfo = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(this.fCProject.getProject());
            discoveredElement = DiscoveredElement.createNew(null, this.fCProject.getProject(), null, 1, false, false);
            try {
                Object object;
                Object object2;
                IPathEntryContainer iPathEntryContainer = CoreModel.getPathEntryContainer((IPath)iContainerEntry.getPath(), (ICProject)this.fCProject);
                if (iPathEntryContainer != null) {
                    discoveredElement.setEntry(iPathEntryContainer.getDescription());
                }
                LinkedHashMap linkedHashMap = iDiscoveredPathInfo.getIncludeMap();
                Object object3 = linkedHashMap.keySet().iterator();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    object = (Boolean)linkedHashMap.get(object2);
                    object = object == null ? Boolean.FALSE : object;
                    DiscoveredElement.createNew(discoveredElement, this.fCProject.getProject(), (String)object2, 2, (Boolean)object, false);
                }
                object3 = iDiscoveredPathInfo.getSymbolMap();
                object2 = ((LinkedHashMap)object3).keySet().iterator();
                while (object2.hasNext()) {
                    String string;
                    object = (String)object2.next();
                    SymbolEntry symbolEntry = (SymbolEntry)((LinkedHashMap)object3).get(object);
                    Iterator iterator = symbolEntry.getActiveRaw().iterator();
                    while (iterator.hasNext()) {
                        string = (String)iterator.next();
                        DiscoveredElement.createNew(discoveredElement, this.fCProject.getProject(), string, 3, false, false);
                    }
                    iterator = symbolEntry.getRemovedRaw().iterator();
                    while (iterator.hasNext()) {
                        string = (String)iterator.next();
                        DiscoveredElement.createNew(discoveredElement, this.fCProject.getProject(), string, 3, true, false);
                    }
                }
            }
            catch (CModelException cModelException) {
                MakeUIPlugin.log(cModelException.getStatus());
            }
        }
        catch (CoreException coreException) {
            MakeUIPlugin.log(coreException);
        }
        return discoveredElement;
    }

    public void createControl(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        LayoutUtil.doDefaultLayout((Composite)composite2, (DialogField[])new DialogField[]{this.fDiscoveredContainerList}, (boolean)true);
        LayoutUtil.setHorizontalGrabbing((Control)this.fDiscoveredContainerList.getTreeControl(null));
        int n = pixelConverter.convertWidthInCharsToPixels(24);
        this.fDiscoveredContainerList.setButtonsMinWidth(n);
        this.fDiscoveredContainerList.getTreeViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                if (object2 instanceof DiscoveredElement) {
                    DiscoveredElement discoveredElement = (DiscoveredElement)object2;
                    switch (discoveredElement.getEntryKind()) {
                        case 4: 
                        case 5: {
                            return discoveredElement.getChildren().length != 0;
                        }
                    }
                }
                return true;
            }
        });
        this.setControl((Control)composite2);
        this.fDiscoveredContainerList.selectFirstElement();
        Shell shell = this.fDiscoveredContainerList.getTreeViewer().getControl().getShell();
        this.copyTextAction = new CopyTextAction(shell);
        this.hookContextMenu();
        this.registerActionHandler(shell, (IAction)this.copyTextAction);
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                iMenuManager.add((IAction)DiscoveredPathContainerPage.this.copyTextAction);
            }
        });
        Menu menu = menuManager.createContextMenu(this.fDiscoveredContainerList.getTreeViewer().getControl());
        this.fDiscoveredContainerList.getTreeViewer().getControl().setMenu(menu);
    }

    private void registerActionHandler(Shell shell, IAction iAction) {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchContextSupport iWorkbenchContextSupport = iWorkbench.getContextSupport();
        IWorkbenchCommandSupport iWorkbenchCommandSupport = iWorkbench.getCommandSupport();
        this.submission = new HandlerSubmission(null, shell, null, "org.eclipse.ui.edit.copy", (IHandler)new ActionHandler(iAction), Priority.MEDIUM);
        iWorkbenchCommandSupport.addHandlerSubmission(this.submission);
        iWorkbenchContextSupport.registerShell(shell, 0);
    }

    private void deregisterActionHandlers() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchContextSupport iWorkbenchContextSupport = iWorkbench.getContextSupport();
        IWorkbenchCommandSupport iWorkbenchCommandSupport = iWorkbench.getCommandSupport();
        iWorkbenchCommandSupport.removeHandlerSubmission(this.submission);
        iWorkbenchContextSupport.unregisterShell(this.fDiscoveredContainerList.getTreeViewer().getControl().getShell());
    }

    private void containerPageCustomButtonPressed(TreeListDialogField treeListDialogField, int n) {
        switch (n) {
            case 0: {
                this.dirty |= this.moveUp();
                break;
            }
            case 1: {
                this.dirty |= this.moveDown();
                break;
            }
            case 3: {
                this.dirty |= this.enableDisableEntry(0);
                break;
            }
            case 2: {
                this.dirty |= this.enableDisableEntry(1);
                break;
            }
            case 5: {
                this.dirty |= this.deleteEntry();
            }
        }
        if (this.dirty) {
            this.fDiscoveredContainerList.refresh();
            this.fDiscoveredContainerList.setFocus();
        }
    }

    private boolean moveUp() {
        boolean bl = false;
        List list = this.fDiscoveredContainerList.getSelectedElements();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DiscoveredElement discoveredElement = (DiscoveredElement)iterator.next();
            DiscoveredElement discoveredElement2 = discoveredElement.getParent();
            Object[] objectArray = discoveredElement2.getChildren();
            int n = 0;
            while (n < objectArray.length) {
                int n2;
                DiscoveredElement discoveredElement3 = (DiscoveredElement)objectArray[n];
                if (discoveredElement.equals(discoveredElement3) && (n2 = n - 1) >= 0) {
                    objectArray[n] = objectArray[n2];
                    objectArray[n2] = discoveredElement;
                    bl = true;
                    break;
                }
                ++n;
            }
            discoveredElement2.setChildren(objectArray);
        }
        this.fDiscoveredContainerList.postSetSelection((ISelection)new StructuredSelection(list));
        return bl;
    }

    private boolean moveDown() {
        boolean bl = false;
        List list = this.fDiscoveredContainerList.getSelectedElements();
        ArrayList arrayList = new ArrayList(list);
        Collections.reverse(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            DiscoveredElement discoveredElement = (DiscoveredElement)iterator.next();
            DiscoveredElement discoveredElement2 = discoveredElement.getParent();
            Object[] objectArray = discoveredElement2.getChildren();
            int n = objectArray.length - 1;
            while (n >= 0) {
                int n2;
                DiscoveredElement discoveredElement3 = (DiscoveredElement)objectArray[n];
                if (discoveredElement.equals(discoveredElement3) && (n2 = n + 1) < objectArray.length) {
                    objectArray[n] = objectArray[n2];
                    objectArray[n2] = discoveredElement;
                    bl = true;
                    break;
                }
                --n;
            }
            discoveredElement2.setChildren(objectArray);
        }
        this.fDiscoveredContainerList.postSetSelection((ISelection)new StructuredSelection(list));
        return bl;
    }

    private boolean enableDisableEntry(int n) {
        boolean bl = false;
        boolean bl2 = n == 0;
        List list = this.fDiscoveredContainerList.getSelectedElements();
        int n2 = list.size() - 1;
        while (n2 >= 0) {
            DiscoveredElement discoveredElement = (DiscoveredElement)list.get(n2);
            switch (discoveredElement.getEntryKind()) {
                case 2: 
                case 3: {
                    discoveredElement.setRemoved(bl2);
                    bl = true;
                }
            }
            --n2;
        }
        return bl;
    }

    private boolean deleteEntry() {
        boolean bl = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = this.fDiscoveredContainerList.getSelectedElements();
        int n = 0;
        while (n < list.size()) {
            DiscoveredElement discoveredElement;
            DiscoveredElement discoveredElement2 = (DiscoveredElement)list.get(n);
            if (discoveredElement2.getEntryKind() != 1 && (discoveredElement = discoveredElement2.getParent()) != null) {
                Object[] objectArray = discoveredElement.getChildren();
                if (discoveredElement2.delete()) {
                    switch (discoveredElement2.getEntryKind()) {
                        case 4: {
                            ScannerInfoCollector.getInstance().deleteAllPaths(this.fCProject.getProject());
                            break;
                        }
                        case 5: {
                            ScannerInfoCollector.getInstance().deleteAllSymbols(this.fCProject.getProject());
                            break;
                        }
                        case 2: {
                            ScannerInfoCollector.getInstance().deletePath(this.fCProject.getProject(), discoveredElement2.getEntry());
                            break;
                        }
                        case 3: {
                            ScannerInfoCollector.getInstance().deleteSymbol(this.fCProject.getProject(), discoveredElement2.getEntry());
                        }
                    }
                    bl = true;
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        DiscoveredElement discoveredElement3 = (DiscoveredElement)objectArray[n2];
                        if (discoveredElement2.equals(discoveredElement3)) {
                            arrayList.clear();
                            if (n2 + 1 < objectArray.length) {
                                arrayList.add(objectArray[n2 + 1]);
                                break;
                            }
                            if (n2 - 1 >= 0) {
                                arrayList.add(objectArray[n2 - 1]);
                                break;
                            }
                            arrayList.add(discoveredElement);
                            break;
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        this.fDiscoveredContainerList.postSetSelection((ISelection)new StructuredSelection(arrayList));
        return bl;
    }

    private void containerPageSelectionChanged(TreeListDialogField treeListDialogField) {
        List list = treeListDialogField.getSelectedElements();
        this.fDiscoveredContainerList.enableButton(0, this.canMoveUpDown(list, 0));
        this.fDiscoveredContainerList.enableButton(1, this.canMoveUpDown(list, 1));
        this.fDiscoveredContainerList.enableButton(3, this.canRemoveRestore(list));
        this.fDiscoveredContainerList.enableButton(2, this.canRemoveRestore(list));
        this.fDiscoveredContainerList.enableButton(5, this.canDelete(list));
    }

    private boolean canMoveUpDown(List list, int n) {
        if (list.size() == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            int n3;
            DiscoveredElement discoveredElement = (DiscoveredElement)list.get(n2);
            switch (discoveredElement.getEntryKind()) {
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    return false;
                }
            }
            DiscoveredElement discoveredElement2 = discoveredElement.getParent();
            Object object = null;
            int n4 = n3 = n == 0 ? 0 : discoveredElement2.getChildren().length - 1;
            if (discoveredElement2.getEntryKind() == 4) {
                object = (DiscoveredElement)discoveredElement2.getChildren()[n3];
            }
            if (object != null && object.equals(discoveredElement)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean canRemoveRestore(List list) {
        if (list.size() == 0) {
            return false;
        }
        int n = 0;
        while (n < list.size()) {
            DiscoveredElement discoveredElement = (DiscoveredElement)list.get(n);
            switch (discoveredElement.getEntryKind()) {
                case 1: 
                case 4: 
                case 5: {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    private boolean canDelete(List list) {
        if (list.size() == 0) {
            return false;
        }
        int n = 0;
        while (n < list.size()) {
            DiscoveredElement discoveredElement = (DiscoveredElement)list.get(n);
            if (discoveredElement.getEntryKind() == 1) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private class DiscoveredContainerAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        DiscoveredContainerAdapter() {
        }

        public void dialogFieldChanged(DialogField dialogField) {
        }

        public void customButtonPressed(TreeListDialogField treeListDialogField, int n) {
            DiscoveredPathContainerPage.this.containerPageCustomButtonPressed(treeListDialogField, n);
        }

        public void selectionChanged(TreeListDialogField treeListDialogField) {
            if (DiscoveredPathContainerPage.this.copyTextAction != null) {
                DiscoveredPathContainerPage.this.copyTextAction.canBeApplied(treeListDialogField.getSelectedElements());
            }
            DiscoveredPathContainerPage.this.containerPageSelectionChanged(treeListDialogField);
        }

        public void doubleClicked(TreeListDialogField treeListDialogField) {
        }

        public void keyPressed(TreeListDialogField treeListDialogField, KeyEvent keyEvent) {
        }

        public Object[] getChildren(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof DiscoveredElement) {
                DiscoveredElement discoveredElement = (DiscoveredElement)object;
                return discoveredElement.getChildren();
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof DiscoveredElement) {
                DiscoveredElement discoveredElement = (DiscoveredElement)object;
                return discoveredElement.getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField treeListDialogField, Object object) {
            if (object instanceof DiscoveredElement) {
                DiscoveredElement discoveredElement = (DiscoveredElement)object;
                return discoveredElement.hasChildren();
            }
            return false;
        }
    }

    public class CopyTextAction
    extends Action {
        static final String ACTION_ID = "org.eclipse.ui.edit.copy";
        private Shell shell;
        private Clipboard clipboard;
        private String discoveredEntry = null;

        public CopyTextAction(Shell shell) {
            super(MakeUIPlugin.getResourceString("CopyDiscoveredPathAction.title"));
            this.setDescription(MakeUIPlugin.getResourceString("CopyDiscoveredPathAction.description"));
            this.setToolTipText(MakeUIPlugin.getResourceString("CopyDiscoveredPathAction.tooltip"));
            this.setActionDefinitionId(ACTION_ID);
            this.clipboard = new Clipboard(shell.getDisplay());
            this.shell = shell;
        }

        boolean canBeApplied(List list) {
            boolean bl = false;
            if (list != null && list.size() == 1) {
                DiscoveredElement discoveredElement = (DiscoveredElement)list.get(0);
                switch (discoveredElement.getEntryKind()) {
                    case 2: 
                    case 3: {
                        this.discoveredEntry = discoveredElement.getEntry();
                        bl = true;
                    }
                }
            }
            this.setEnabled(bl);
            return bl;
        }

        public void run() {
            if (this.discoveredEntry != null) {
                this.clipboard.setContents(new Object[]{this.discoveredEntry}, new Transfer[]{TextTransfer.getInstance()});
                this.discoveredEntry = null;
            }
        }
    }
}

