/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigBuilder;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigNature;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathContainer;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.IMakeHelpContextIds;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class DiscoveryOptionsBlock
extends AbstractCOptionPage {
    private static final String PREFIX_BP = "BuildPathInfoBlock";
    private static final String SC_GROUP_LABEL = "BuildPathInfoBlock.scGroup.label";
    private static final String SC_ENABLED_LABEL = "BuildPathInfoBlock.scGroup.enabled.label";
    private static final String MISSING_BUILDER_MSG = "ScannerConfigOptionsDialog.label.missingBuilderInformation";
    private static final String PREFIX = "ScannerConfigOptionsDialog";
    private static final String DIALOG_TITLE = "ScannerConfigOptionsDialog.title";
    private static final String DIALOG_DESCRIPTION = "ScannerConfigOptionsDialog.description";
    private static final String SI_BUILD_PARSER_GROUP = "ScannerConfigOptionsDialog.siBuilder.parser.group_label";
    private static final String ENABLE_SI_BUILD_PARSER = "ScannerConfigOptionsDialog.siBuilder.parser.enable.label";
    private static final String SI_BUILD_PARSER_LABEL = "ScannerConfigOptionsDialog.siBuilder.parser.label";
    private static final String SI_PROVIDER_CMD_GROUP = "ScannerConfigOptionsDialog.siProvider.cmd.group_label";
    private static final String ENABLE_SI_PROVIDER_COMMAND = "ScannerConfigOptionsDialog.siProvider.cmd.enable.label";
    private static final String SI_PROVIDER_CMD_USE_DEFAULT = "ScannerConfigOptionsDialog.siProvider.cmd.use_default";
    private static final String SI_PROVIDER_CMD_LABEL = "ScannerConfigOptionsDialog.siProvider.cmd.label";
    private static final String SI_PROVIDER_PARSER_LABEL = "ScannerConfigOptionsDialog.siProvider.parser.label";
    private static final String SI_PROVIDER_CMD_ERROR_MESSAGE = "ScannerConfigOptionsDialog.siProvider.cmd.error_message";
    private static final String SI_PROBLEM_GROUP = "ScannerConfigOptionsDialog.siProblem.group.label";
    private static final String ENABLE_SI_PROBLEM_GENERATION = "ScannerConfigOptionsDialog.siProblem.generation.enable.label";
    private Button scEnabledButton;
    private boolean needsSCNature = false;
    private Button defESIProviderCommandButton;
    private Text esiProviderCommand;
    private Button enableBuilderParserButton;
    private Combo makeBuilderSIParserComboBox;
    private Button enableProviderCommandButton;
    private Combo esiProviderParserComboBox;
    private Button enableProblemGenerationButton;
    private Preferences fPrefs;
    private IScannerConfigBuilderInfo fBuildInfo;
    private boolean fInitialized = false;
    private Map builderParsers = new HashMap();
    private String initialBuilderParserId = null;
    private Map providerParsers = new HashMap();
    private String initialProviderParserId = null;
    private boolean fCreatePathContainer = false;

    public DiscoveryOptionsBlock() {
        super(MakeUIPlugin.getResourceString(DIALOG_TITLE));
        this.setDescription(MakeUIPlugin.getResourceString(DIALOG_DESCRIPTION));
    }

    public void setContainer(ICOptionContainer iCOptionContainer) {
        super.setContainer(iCOptionContainer);
        this.fPrefs = this.getContainer().getPreferences();
        IProject iProject = this.getContainer().getProject();
        this.fInitialized = true;
        if (iProject != null) {
            try {
                this.fBuildInfo = MakeCorePlugin.createScannerConfigBuildInfo((IProject)iProject, (String)ScannerConfigBuilder.BUILDER_ID);
            }
            catch (CoreException coreException) {
                this.fInitialized = false;
                this.fBuildInfo = MakeCorePlugin.createScannerConfigBuildInfo((Preferences)this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)true);
            }
        } else {
            this.fCreatePathContainer = true;
            this.fBuildInfo = MakeCorePlugin.createScannerConfigBuildInfo((Preferences)this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)false);
        }
        this.retrieveSIConsoleParsers();
        this.initialBuilderParserId = this.fBuildInfo.getMakeBuilderConsoleParserId();
        this.initialProviderParserId = this.fBuildInfo.getESIProviderConsoleParserId();
    }

    public void performApply(IProgressMonitor iProgressMonitor) throws CoreException {
        if (!this.fInitialized) {
            return;
        }
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        IWorkspace iWorkspace = MakeUIPlugin.getWorkspace();
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                IScannerConfigBuilderInfo iScannerConfigBuilderInfo;
                IProject iProject = DiscoveryOptionsBlock.this.getContainer().getProject();
                if (iProject != null) {
                    if (DiscoveryOptionsBlock.this.needsSCNature) {
                        ScannerConfigNature.addScannerConfigNature((IProject)DiscoveryOptionsBlock.this.getContainer().getProject());
                        DiscoveryOptionsBlock.this.needsSCNature = false;
                        DiscoveryOptionsBlock.this.fCreatePathContainer = true;
                    }
                    try {
                        iScannerConfigBuilderInfo = MakeCorePlugin.createScannerConfigBuildInfo((IProject)iProject, (String)ScannerConfigBuilder.BUILDER_ID);
                    }
                    catch (CoreException coreException) {
                        MakeCorePlugin.log((Throwable)coreException);
                        return;
                    }
                    if (DiscoveryOptionsBlock.this.fCreatePathContainer) {
                        DiscoveryOptionsBlock.this.createDiscoveredPathContainer(iProject, iProgressMonitor);
                        MakeCorePlugin.getDefault().getDiscoveryManager().removeDiscoveredInfo(iProject);
                        DiscoveryOptionsBlock.this.fCreatePathContainer = false;
                    }
                } else {
                    iScannerConfigBuilderInfo = MakeCorePlugin.createScannerConfigBuildInfo((Preferences)DiscoveryOptionsBlock.this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)false);
                }
                iScannerConfigBuilderInfo.setAutoDiscoveryEnabled(DiscoveryOptionsBlock.this.isScannerConfigDiscoveryEnabled());
                if (DiscoveryOptionsBlock.this.isScannerConfigDiscoveryEnabled()) {
                    iScannerConfigBuilderInfo.setMakeBuilderConsoleParserEnabled(DiscoveryOptionsBlock.this.isBuilderParserEnabled());
                    if (DiscoveryOptionsBlock.this.isBuilderParserEnabled()) {
                        iScannerConfigBuilderInfo.setMakeBuilderConsoleParserId((String)DiscoveryOptionsBlock.this.builderParsers.get(DiscoveryOptionsBlock.this.makeBuilderSIParserComboBox.getText()));
                    }
                    iScannerConfigBuilderInfo.setESIProviderCommandEnabled(DiscoveryOptionsBlock.this.isProviderCommandEnabled());
                    if (DiscoveryOptionsBlock.this.isProviderCommandEnabled()) {
                        iScannerConfigBuilderInfo.setUseDefaultESIProviderCmd(DiscoveryOptionsBlock.this.useDefaultESIProviderCmd());
                        if (!DiscoveryOptionsBlock.this.useDefaultESIProviderCmd()) {
                            DiscoveryOptionsBlock.this.storeSIProviderCommandLine(iScannerConfigBuilderInfo);
                        }
                        iScannerConfigBuilderInfo.setESIProviderConsoleParserId((String)DiscoveryOptionsBlock.this.providerParsers.get(DiscoveryOptionsBlock.this.esiProviderParserComboBox.getText()));
                    }
                    iScannerConfigBuilderInfo.setSIProblemGenerationEnabled(DiscoveryOptionsBlock.this.isProblemGenerationEnabled());
                }
            }
        };
        if (this.getContainer().getProject() != null) {
            iWorkspace.run(iWorkspaceRunnable, iProgressMonitor);
        } else {
            iWorkspaceRunnable.run(iProgressMonitor);
        }
    }

    private void createDiscoveredPathContainer(IProject iProject, IProgressMonitor iProgressMonitor) throws CModelException {
        IPathEntry[] iPathEntryArray;
        ArrayList<IPathEntry> arrayList;
        IContainerEntry iContainerEntry = CoreModel.newContainerEntry((IPath)DiscoveredPathContainer.CONTAINER_ID);
        ICProject iCProject = CoreModel.getDefault().create(iProject);
        if (iCProject != null && !(arrayList = new ArrayList<IPathEntry>(Arrays.asList(iPathEntryArray = iCProject.getRawPathEntries()))).contains(iContainerEntry)) {
            arrayList.add((IPathEntry)iContainerEntry);
            iCProject.setRawPathEntries(arrayList.toArray(new IPathEntry[arrayList.size()]), iProgressMonitor);
        }
    }

    public void performDefaults() {
        if (!this.fInitialized) {
            return;
        }
        IScannerConfigBuilderInfo iScannerConfigBuilderInfo = this.getContainer().getProject() != null ? MakeCorePlugin.createScannerConfigBuildInfo((Preferences)this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)false) : MakeCorePlugin.createScannerConfigBuildInfo((Preferences)this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)true);
        this.setScannerConfigDiscoveryEnabled(iScannerConfigBuilderInfo.isAutoDiscoveryEnabled());
        this.enableBuilderParserButton.setSelection(iScannerConfigBuilderInfo.isMakeBuilderConsoleParserEnabled());
        this.makeBuilderSIParserComboBox.setText(this.getParserName(this.builderParsers, iScannerConfigBuilderInfo.getMakeBuilderConsoleParserId()));
        this.enableProviderCommandButton.setSelection(iScannerConfigBuilderInfo.isESIProviderCommandEnabled());
        this.defESIProviderCommandButton.setSelection(iScannerConfigBuilderInfo.isDefaultESIProviderCmd());
        this.setESIProviderCommandFrom(iScannerConfigBuilderInfo);
        this.esiProviderParserComboBox.setText(this.getParserName(this.providerParsers, iScannerConfigBuilderInfo.getESIProviderConsoleParserId()));
        this.enableAllControls();
    }

    private String getParserName(Map map, String string) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)map.get(string2);
            if (!string3.equals(string)) continue;
            return string2;
        }
        return string;
    }

    public void createControl(Composite composite) {
        int n = 1;
        Font font = composite.getFont();
        Composite composite2 = ControlFactory.createComposite((Composite)composite, (int)n);
        ((GridLayout)composite2.getLayout()).makeColumnsEqualWidth = false;
        composite2.setFont(font);
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IMakeHelpContextIds.SCANNER_CONFIG_DISCOVERY_OPTIONS);
        if (this.createScannerConfigControls(composite2, n)) {
            this.createBuildOutputParserControls(composite2);
            this.createAfterBuildCmdControls(composite2);
            this.createProblemGenerationControls(composite2);
            this.enableAllControls();
        }
    }

    private boolean createScannerConfigControls(Composite composite, int n) {
        IProject iProject = this.getContainer().getProject();
        boolean bl = false;
        try {
            if (iProject != null && iProject.hasNature(MakeProjectNature.NATURE_ID) && !iProject.hasNature(ScannerConfigNature.NATURE_ID)) {
                this.needsSCNature = true;
            }
        }
        catch (CoreException coreException) {
            bl = true;
        }
        if (bl || !this.needsSCNature && !this.fInitialized) {
            ControlFactory.createEmptySpace((Composite)composite);
            ControlFactory.createLabel((Composite)composite, (String)MakeUIPlugin.getResourceString(MISSING_BUILDER_MSG));
            return false;
        }
        Group group = ControlFactory.createGroup((Composite)composite, (String)MakeUIPlugin.getResourceString(SC_GROUP_LABEL), (int)n);
        group.setFont(composite.getFont());
        ((GridData)group.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)group.getLayoutData()).horizontalSpan = n;
        ((GridData)group.getLayoutData()).horizontalAlignment = 4;
        this.scEnabledButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(SC_ENABLED_LABEL));
        this.scEnabledButton.setFont(composite.getFont());
        ((GridData)this.scEnabledButton.getLayoutData()).horizontalSpan = n;
        ((GridData)this.scEnabledButton.getLayoutData()).grabExcessHorizontalSpace = true;
        this.scEnabledButton.setSelection(this.needsSCNature ? false : this.fBuildInfo.isAutoDiscoveryEnabled());
        this.scEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiscoveryOptionsBlock.this.enableAllControls();
            }
        });
        return true;
    }

    private void retrieveSIConsoleParsers() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(MakeCorePlugin.getUniqueIdentifier(), "ScannerInfoConsoleParser");
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                String string = iExtensionArray[n].getUniqueIdentifier();
                String string2 = iExtensionArray[n].getLabel();
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                String string3 = iConfigurationElementArray[0].getAttribute("commandId");
                if (string3.equals("makeBuilder") || string3.equals("all")) {
                    this.builderParsers.put(string2, string);
                }
                if (string3.equals("externalScannerInfoProvider") || string3.equals("all")) {
                    this.providerParsers.put(string2, string);
                }
                ++n;
            }
        }
    }

    private void createBuildOutputParserControls(Composite composite) {
        Group group = ControlFactory.createGroup((Composite)composite, (String)MakeUIPlugin.getResourceString(SI_BUILD_PARSER_GROUP), (int)2);
        ((GridLayout)group.getLayout()).marginHeight = 5;
        ((GridLayout)group.getLayout()).marginWidth = 5;
        ((GridData)group.getLayoutData()).verticalAlignment = 4;
        ((GridData)group.getLayoutData()).horizontalSpan = 2;
        this.enableBuilderParserButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(ENABLE_SI_BUILD_PARSER));
        ((GridData)this.enableBuilderParserButton.getLayoutData()).horizontalSpan = 2;
        boolean bl = this.fBuildInfo.isMakeBuilderConsoleParserEnabled();
        this.enableBuilderParserButton.setSelection(bl);
        this.enableBuilderParserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiscoveryOptionsBlock.this.makeBuilderSIParserComboBox.setEnabled(DiscoveryOptionsBlock.this.isBuilderParserEnabled());
            }
        });
        Label label = ControlFactory.createLabel((Composite)group, (String)MakeUIPlugin.getResourceString(SI_BUILD_PARSER_LABEL));
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.makeBuilderSIParserComboBox = new Combo((Composite)group, 12);
        Iterator iterator = this.builderParsers.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.makeBuilderSIParserComboBox.add(string);
            if (!this.initialBuilderParserId.equals(this.builderParsers.get(string))) continue;
            this.makeBuilderSIParserComboBox.setText(string);
        }
        this.makeBuilderSIParserComboBox.setEnabled(bl);
    }

    private void createAfterBuildCmdControls(Composite composite) {
        Group group = ControlFactory.createGroup((Composite)composite, (String)MakeUIPlugin.getResourceString(SI_PROVIDER_CMD_GROUP), (int)2);
        ((GridData)group.getLayoutData()).horizontalSpan = 2;
        this.enableProviderCommandButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(ENABLE_SI_PROVIDER_COMMAND));
        ((GridData)this.enableProviderCommandButton.getLayoutData()).horizontalSpan = 2;
        ((GridData)this.enableProviderCommandButton.getLayoutData()).horizontalAlignment = 768;
        boolean bl = this.fBuildInfo.isESIProviderCommandEnabled();
        this.enableProviderCommandButton.setSelection(bl);
        this.enableProviderCommandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiscoveryOptionsBlock.this.defESIProviderCommandButton.setEnabled(DiscoveryOptionsBlock.this.isProviderCommandEnabled());
                DiscoveryOptionsBlock.this.esiProviderCommand.setEnabled(DiscoveryOptionsBlock.this.isProviderCommandEnabled() && !DiscoveryOptionsBlock.this.useDefaultESIProviderCmd());
                DiscoveryOptionsBlock.this.esiProviderParserComboBox.setEnabled(DiscoveryOptionsBlock.this.isProviderCommandEnabled());
                DiscoveryOptionsBlock.this.getContainer().updateContainer();
            }
        });
        this.createESIProviderCmdControls((Composite)group);
        Label label = ControlFactory.createLabel((Composite)group, (String)MakeUIPlugin.getResourceString(SI_PROVIDER_PARSER_LABEL));
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.esiProviderParserComboBox = new Combo((Composite)group, 12);
        Iterator iterator = this.providerParsers.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.esiProviderParserComboBox.add(string);
            if (!this.initialProviderParserId.equals(this.providerParsers.get(string))) continue;
            this.esiProviderParserComboBox.setText(string);
        }
        this.defESIProviderCommandButton.setEnabled(bl);
        this.esiProviderCommand.setEnabled(bl && !this.useDefaultESIProviderCmd());
        this.esiProviderParserComboBox.setEnabled(bl);
    }

    private void createESIProviderCmdControls(Composite composite) {
        this.defESIProviderCommandButton = ControlFactory.createCheckBox((Composite)composite, (String)MakeUIPlugin.getResourceString(SI_PROVIDER_CMD_USE_DEFAULT));
        this.defESIProviderCommandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiscoveryOptionsBlock.this.esiProviderCommand.setEnabled(!DiscoveryOptionsBlock.this.useDefaultESIProviderCmd());
                DiscoveryOptionsBlock.this.getContainer().updateContainer();
            }
        });
        ((GridData)this.defESIProviderCommandButton.getLayoutData()).horizontalAlignment = 768;
        ((GridData)this.defESIProviderCommandButton.getLayoutData()).horizontalSpan = 2;
        Label label = ControlFactory.createLabel((Composite)composite, (String)MakeUIPlugin.getResourceString(SI_PROVIDER_CMD_LABEL));
        ((GridData)label.getLayoutData()).horizontalAlignment = 1;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.esiProviderCommand = ControlFactory.createTextField((Composite)composite, (int)2052);
        ((GridData)this.esiProviderCommand.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.esiProviderCommand.getLayoutData()).grabExcessHorizontalSpace = true;
        this.setESIProviderCommandFrom(this.fBuildInfo);
        if (this.fBuildInfo.isDefaultESIProviderCmd()) {
            this.esiProviderCommand.setEnabled(false);
        }
        this.esiProviderCommand.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                DiscoveryOptionsBlock.this.getContainer().updateContainer();
            }
        });
        this.defESIProviderCommandButton.setSelection(this.fBuildInfo.isDefaultESIProviderCmd());
    }

    private void createProblemGenerationControls(Composite composite) {
        Group group = ControlFactory.createGroup((Composite)composite, (String)MakeUIPlugin.getResourceString(SI_PROBLEM_GROUP), (int)2);
        ((GridData)group.getLayoutData()).horizontalSpan = 2;
        this.enableProblemGenerationButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(ENABLE_SI_PROBLEM_GENERATION));
        ((GridData)this.enableProblemGenerationButton.getLayoutData()).horizontalSpan = 2;
        ((GridData)this.enableProblemGenerationButton.getLayoutData()).horizontalAlignment = 768;
        boolean bl = this.fBuildInfo.isSIProblemGenerationEnabled();
        this.enableProblemGenerationButton.setSelection(bl);
        this.enableProblemGenerationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiscoveryOptionsBlock.this.getContainer().updateContainer();
            }
        });
    }

    private void setESIProviderCommandFrom(IScannerConfigBuilderInfo iScannerConfigBuilderInfo) {
        IPath iPath = iScannerConfigBuilderInfo.getESIProviderCommand();
        if (iPath != null) {
            StringBuffer stringBuffer = new StringBuffer(iPath.toOSString());
            String string = iScannerConfigBuilderInfo.getESIProviderArguments();
            if (string != null && string.length() > 0) {
                stringBuffer.append(' ');
                stringBuffer.append(string);
            }
            this.esiProviderCommand.setText(stringBuffer.toString());
        }
    }

    private void enableAllControls() {
        this.enableBuilderParserButton.setEnabled(this.isScannerConfigDiscoveryEnabled());
        this.makeBuilderSIParserComboBox.setEnabled(this.isScannerConfigDiscoveryEnabled() && this.isBuilderParserEnabled());
        this.enableProviderCommandButton.setEnabled(this.isScannerConfigDiscoveryEnabled());
        this.defESIProviderCommandButton.setEnabled(this.isScannerConfigDiscoveryEnabled() && this.isProviderCommandEnabled());
        this.esiProviderCommand.setEnabled(this.isScannerConfigDiscoveryEnabled() && this.isProviderCommandEnabled() && !this.useDefaultESIProviderCmd());
        this.esiProviderParserComboBox.setEnabled(this.isScannerConfigDiscoveryEnabled() && this.isProviderCommandEnabled());
        this.enableProblemGenerationButton.setEnabled(this.isScannerConfigDiscoveryEnabled());
    }

    private boolean useDefaultESIProviderCmd() {
        return this.defESIProviderCommandButton.getSelection();
    }

    private String getSIProviderCommandLine() {
        return this.esiProviderCommand.getText().trim();
    }

    private boolean isBuilderParserEnabled() {
        return this.enableBuilderParserButton.getSelection();
    }

    private boolean isProviderCommandEnabled() {
        return this.enableProviderCommandButton.getSelection();
    }

    private boolean isProblemGenerationEnabled() {
        return this.enableProblemGenerationButton.getSelection();
    }

    private boolean isScannerConfigDiscoveryEnabled() {
        return this.scEnabledButton.getSelection();
    }

    private void setScannerConfigDiscoveryEnabled(boolean bl) {
        this.scEnabledButton.setSelection(bl);
    }

    private void storeSIProviderCommandLine(IScannerConfigBuilderInfo iScannerConfigBuilderInfo) throws CoreException {
        String string = this.getSIProviderCommandLine();
        int n = 0;
        int n2 = -1;
        if (string.startsWith("\"")) {
            n = 1;
            n2 = string.indexOf(34, 1);
        } else {
            n2 = string.indexOf(32);
        }
        Path path = n2 == -1 ? new Path(string) : new Path(string.substring(n, n2));
        iScannerConfigBuilderInfo.setESIProviderCommand((IPath)path);
        String string2 = "";
        if (n2 != -1) {
            string2 = string.substring(n2 + 1);
        }
        iScannerConfigBuilderInfo.setESIProviderArguments(string2);
    }

    public boolean isValid() {
        String string;
        return !this.fInitialized || !this.isProviderCommandEnabled() || this.useDefaultESIProviderCmd() || (string = this.getSIProviderCommandLine()) != null && string.length() != 0;
    }

    public String getErrorMessage() {
        if (!this.isValid()) {
            return MakeUIPlugin.getResourceString(SI_PROVIDER_CMD_ERROR_MESSAGE);
        }
        return null;
    }
}

