/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathInfo;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerInfoCollector;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.SymbolEntry;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.MessageLine;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ManageDefinedSymbolsDialog
extends Dialog {
    private static final String PREF_SYMBOLS = "ScannerSymbols";
    private static final String PREFIX = "ManageDefinedSymbolsDialog";
    private static final String DIALOG_TITLE = "ManageDefinedSymbolsDialog.title";
    private static final String USER_GROUP = "ManageDefinedSymbolsDialog.userGroup.title";
    private static final String NEW = "BuildPropertyCommon.label.new";
    private static final String EDIT = "BuildPropertyCommon.label.edit";
    private static final String REMOVE = "BuildPropertyCommon.label.remove";
    private static final String UP = "BuildPropertyCommon.label.up";
    private static final String DOWN = "BuildPropertyCommon.label.down";
    private static final String BROWSE = "BuildPathInfoBlock.browse";
    private static final String SYMBOL_TITLE = "BuildPathInfoBlock.browse.symbol";
    private static final String EDIT_SYMBOL_TITLE = "BuildPathInfoBlock.browse.symbol.edit";
    private static final String SYMBOL_LABEL = "BuildPathInfoBlock.browse.symbol.label";
    private static final String DISCOVERED_GROUP = "ManageDefinedSymbolsDialog.discoveredGroup.title";
    private static final String DISC_COMMON_PREFIX = "ManageScannerConfigDialogCommon";
    private static final String SELECTED_LABEL = "ManageScannerConfigDialogCommon.discoveredGroup.selected.label";
    private static final String REMOVED_LABEL = "ManageScannerConfigDialogCommon.discoveredGroup.removed.label";
    private static final String REMOVE_DISCOVERED = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.remove.label";
    private static final String RESTORE_DISCOVERED = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.restore.label";
    private static final String DELETE_DISCOVERED = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.delete.label";
    private static final String DELETE_ALL_DISCOVERED = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.deleteAll.label";
    private static final int PROJECT_LIST_MULTIPLIER = 15;
    private static final int INITIAL_LIST_WIDTH = 40;
    private static final int ACTIVE = 0;
    private static final int REMOVED = 1;
    private static final int DO_REMOVE = 0;
    private static final int DO_RESTORE = 1;
    boolean alreadyCreated;
    private ArrayList returnSymbols;
    private ArrayList deletedDiscoveredSymbols;
    private LinkedHashMap discoveredSymbols;
    private LinkedHashMap workingDiscoveredSymbols;
    private boolean fDirty;
    private boolean fWorkingDirty;
    private ICOptionContainer fContainer;
    private IProject fProject;
    private Shell fShell;
    private MessageLine fStatusLine;
    private Group discoveredGroup;
    private Label selectedLabel;
    private Label removedLabel;
    private org.eclipse.swt.widgets.List discActiveList;
    private org.eclipse.swt.widgets.List discRemovedList;
    private Button removeDiscSymbol;
    private Button restoreDiscSymbol;
    private Button deleteDiscSymbol;
    private Button deleteAllDiscSymbols;

    protected ManageDefinedSymbolsDialog(Shell shell, ICOptionContainer iCOptionContainer) {
        super(shell);
        DiscoveredPathInfo discoveredPathInfo;
        this.fShell = shell;
        this.fContainer = iCOptionContainer;
        this.fProject = this.fContainer.getProject();
        if (this.fProject != null) {
            try {
                discoveredPathInfo = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(this.fProject);
            }
            catch (CoreException coreException) {
                discoveredPathInfo = new DiscoveredPathInfo(this.fProject);
            }
        } else {
            discoveredPathInfo = new DiscoveredPathInfo(this.fProject);
        }
        this.discoveredSymbols = discoveredPathInfo.getSymbolMap();
        this.setDirty(false);
        this.fDirty = false;
    }

    protected void configureShell(Shell shell) {
        shell.setText(this.getTitle(DIALOG_TITLE));
        super.configureShell(shell);
    }

    private String getTitle(String string) {
        return MakeUIPlugin.getResourceString(string);
    }

    protected Control createDialogArea(Composite composite) {
        this.setDirty(false);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        ((GridLayout)composite2.getLayout()).numColumns = 3;
        this.initializeDialogUnits((Control)composite2);
        this.fStatusLine = new MessageLine(composite2);
        this.fStatusLine.setAlignment(16384);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.fStatusLine.setLayoutData(gridData);
        this.fStatusLine.setMessage(this.getTitle(DIALOG_TITLE));
        this.createOptionsControls(composite2);
        this.createDiscoveredControls(composite2);
        this.setListContents();
        this.discActiveList.select(0);
        this.enableDiscoveredButtons();
        return composite2;
    }

    private void setListContents() {
        this.workingDiscoveredSymbols = new LinkedHashMap(this.discoveredSymbols);
        this.discActiveList.setItems(this.getDiscDefinedSymbols(this.workingDiscoveredSymbols, 0));
        this.discRemovedList.setItems(this.getDiscDefinedSymbols(this.workingDiscoveredSymbols, 1));
    }

    private String[] getDiscDefinedSymbols(Map map, int n) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            SymbolEntry symbolEntry = (SymbolEntry)map.get(string);
            List list = n == 0 ? symbolEntry.getActiveRaw() : symbolEntry.getRemovedRaw();
            arrayList.addAll(list);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] getIncludes(Preferences preferences) {
        String string = preferences.getString(PREF_SYMBOLS);
        return this.parseStringToList(string);
    }

    private String[] parseStringToList(String string) {
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreElements()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return new String[0];
    }

    private void createOptionsControls(Composite composite) {
    }

    private void createDiscoveredControls(Composite composite) {
        this.discoveredGroup = ControlFactory.createGroup((Composite)composite, (String)this.getTitle(DISCOVERED_GROUP), (int)3);
        ((GridData)this.discoveredGroup.getLayoutData()).horizontalSpan = 3;
        ((GridData)this.discoveredGroup.getLayoutData()).grabExcessHorizontalSpace = true;
        Group group = this.discoveredGroup;
        this.selectedLabel = ControlFactory.createLabel((Composite)group, (String)this.getTitle(SELECTED_LABEL));
        ((GridData)this.selectedLabel.getLayoutData()).horizontalSpan = 1;
        ControlFactory.createLabel((Composite)this.discoveredGroup, (String)"");
        this.removedLabel = ControlFactory.createLabel((Composite)group, (String)this.getTitle(REMOVED_LABEL));
        ((GridData)this.removedLabel.getLayoutData()).horizontalSpan = 1;
        this.discActiveList = new org.eclipse.swt.widgets.List((Composite)group, 2820);
        this.discActiveList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManageDefinedSymbolsDialog.this.discRemovedList.deselectAll();
                ManageDefinedSymbolsDialog.this.enableDiscoveredButtons();
            }
        });
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        gridData.heightHint = ManageDefinedSymbolsDialog.getDefaultFontHeight((Control)this.discActiveList, 15);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        this.discActiveList.setLayoutData((Object)gridData);
        Composite composite2 = ControlFactory.createComposite((Composite)this.discoveredGroup, (int)1);
        this.removeDiscSymbol = ControlFactory.createPushButton((Composite)composite2, (String)this.getTitle(REMOVE_DISCOVERED));
        this.removeDiscSymbol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManageDefinedSymbolsDialog.this.handleRemoveRestoreDiscSymbol(0);
            }
        });
        this.removeDiscSymbol.setEnabled(true);
        SWTUtil.setButtonDimensionHint((Button)this.removeDiscSymbol);
        this.restoreDiscSymbol = ControlFactory.createPushButton((Composite)composite2, (String)this.getTitle(RESTORE_DISCOVERED));
        this.restoreDiscSymbol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManageDefinedSymbolsDialog.this.handleRemoveRestoreDiscSymbol(1);
            }
        });
        this.restoreDiscSymbol.setEnabled(true);
        SWTUtil.setButtonDimensionHint((Button)this.restoreDiscSymbol);
        ControlFactory.createSeparator((Composite)composite2, (int)1);
        this.deleteDiscSymbol = ControlFactory.createPushButton((Composite)composite2, (String)this.getTitle(DELETE_DISCOVERED));
        this.deleteDiscSymbol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManageDefinedSymbolsDialog.this.handleDeleteDiscSymbol();
            }
        });
        this.deleteDiscSymbol.setEnabled(true);
        SWTUtil.setButtonDimensionHint((Button)this.deleteDiscSymbol);
        this.deleteAllDiscSymbols = ControlFactory.createPushButton((Composite)composite2, (String)this.getTitle(DELETE_ALL_DISCOVERED));
        this.deleteAllDiscSymbols.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManageDefinedSymbolsDialog.this.handleDeleteAllDiscSymbols();
            }
        });
        this.deleteAllDiscSymbols.setEnabled(true);
        SWTUtil.setButtonDimensionHint((Button)this.deleteAllDiscSymbols);
        Group group2 = this.discoveredGroup;
        this.discRemovedList = new org.eclipse.swt.widgets.List((Composite)group2, 2820);
        this.discRemovedList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManageDefinedSymbolsDialog.this.discActiveList.deselectAll();
                ManageDefinedSymbolsDialog.this.enableDiscoveredButtons();
            }
        });
        GridData gridData2 = new GridData(1808);
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.horizontalSpan = 1;
        gridData2.heightHint = ManageDefinedSymbolsDialog.getDefaultFontHeight((Control)this.discRemovedList, 15);
        gridData2.widthHint = this.convertWidthInCharsToPixels(40);
        this.discRemovedList.setLayoutData((Object)gridData2);
    }

    protected void handleRemoveRestoreDiscSymbol(int n) {
        if (this.workingDiscoveredSymbols != null) {
            int n2;
            org.eclipse.swt.widgets.List list = this.discRemovedList;
            org.eclipse.swt.widgets.List list2 = this.discActiveList;
            boolean bl = true;
            if (n == 0) {
                list = this.discActiveList;
                list2 = this.discRemovedList;
                bl = false;
            }
            if ((n2 = list.getSelectionIndex()) != -1) {
                String string = list.getItem(n2);
                String string2 = ScannerConfigUtil.getSymbolKey((String)string);
                String string3 = ScannerConfigUtil.getSymbolValue((String)string);
                SymbolEntry symbolEntry = (SymbolEntry)this.workingDiscoveredSymbols.get(string2);
                if (symbolEntry != null) {
                    symbolEntry = new SymbolEntry(symbolEntry);
                    symbolEntry.replace(string3, bl);
                    this.workingDiscoveredSymbols.put(string2, symbolEntry);
                    this.discActiveList.setItems(this.getDiscDefinedSymbols(this.workingDiscoveredSymbols, 0));
                    this.discRemovedList.setItems(this.getDiscDefinedSymbols(this.workingDiscoveredSymbols, 1));
                    list2.setSelection(list2.indexOf(string));
                    this.enableDiscoveredButtons();
                    this.setDirty(true);
                }
            }
        }
    }

    protected void handleDeleteDiscSymbol() {
        this.deleteDiscSymbol(1);
        this.deleteDiscSymbol(0);
    }

    private void deleteDiscSymbol(int n) {
        int n2;
        org.eclipse.swt.widgets.List list = this.discRemovedList;
        if (n == 0) {
            list = this.discActiveList;
        }
        if ((n2 = list.getSelectionIndex()) >= 0) {
            String string = list.getItem(n2);
            if (this.deletedDiscoveredSymbols == null) {
                this.deletedDiscoveredSymbols = new ArrayList();
            }
            this.deletedDiscoveredSymbols.add(string);
            ScannerConfigUtil.removeSymbolEntryValue((String)string, (Map)this.workingDiscoveredSymbols);
            int n3 = list.getItemCount();
            list.setItems(this.getDiscDefinedSymbols(this.workingDiscoveredSymbols, n));
            if (n3 > 0) {
                if (n2 >= n3) {
                    n2 = n3 - 1;
                }
                list.setSelection(n2);
                this.enableDiscoveredButtons();
                this.setDirty(true);
            }
        }
    }

    protected void handleDeleteAllDiscSymbols() {
        ScannerInfoCollector.getInstance().deleteAllSymbols(this.fProject);
        this.workingDiscoveredSymbols.clear();
        this.discActiveList.setItems(this.getDiscDefinedSymbols(this.workingDiscoveredSymbols, 0));
        this.discRemovedList.setItems(this.getDiscDefinedSymbols(this.workingDiscoveredSymbols, 1));
        this.enableDiscoveredButtons();
        this.setDirty(true);
    }

    protected void enableDiscoveredButtons() {
        this.discoveredGroup.setEnabled(this.fProject != null);
        this.selectedLabel.setEnabled(this.fProject != null);
        this.discActiveList.setEnabled(this.fProject != null);
        this.removedLabel.setEnabled(this.fProject != null);
        this.discRemovedList.setEnabled(this.fProject != null);
        int n = this.discActiveList.getItemCount();
        int n2 = this.discActiveList.getSelectionIndex();
        int n3 = this.discRemovedList.getItemCount();
        int n4 = this.discRemovedList.getSelectionIndex();
        if (n > 0 && n2 >= 0) {
            this.removeDiscSymbol.setEnabled(n > 0 && n2 >= 0);
            this.restoreDiscSymbol.setEnabled(n3 > 0 && n4 >= 0);
        } else {
            this.restoreDiscSymbol.setEnabled(n3 > 0 && n4 >= 0);
            this.removeDiscSymbol.setEnabled(n > 0 && n2 >= 0);
        }
        this.deleteDiscSymbol.setEnabled(n > 0 && n2 >= 0 || n3 > 0 && n4 >= 0);
        this.deleteAllDiscSymbols.setEnabled(n > 0 || n3 > 0);
    }

    private static int getDefaultFontHeight(Control control, int n) {
        FontData[] fontDataArray = control.getFont().getFontData();
        int n2 = 10;
        if (fontDataArray.length > 0) {
            n2 = fontDataArray[0].getHeight();
        }
        return n * n2;
    }

    public String[] getManagedSymbols() {
        if (this.returnSymbols == null) {
            return new String[0];
        }
        return this.returnSymbols.toArray(new String[this.returnSymbols.size()]);
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.discoveredSymbols = this.workingDiscoveredSymbols;
            this.returnSymbols = new ArrayList(this.discActiveList.getItemCount());
            this.returnSymbols.addAll(new ArrayList<String>(Arrays.asList(this.discActiveList.getItems())));
            this.fDirty = this.fWorkingDirty;
        } else if (1 == n) {
            this.deletedDiscoveredSymbols = null;
            this.workingDiscoveredSymbols = null;
            this.setDirty(false);
        }
        super.buttonPressed(n);
    }

    private void setDirty(boolean bl) {
        this.fWorkingDirty = bl;
    }

    public boolean saveTo(IDiscoveredPathManager.IDiscoveredPathInfo iDiscoveredPathInfo) {
        if (this.fDirty || this.fProject == null && this.fContainer.getProject() != null) {
            iDiscoveredPathInfo.setSymbolMap(this.discoveredSymbols);
            if (this.deletedDiscoveredSymbols != null) {
                Iterator iterator = this.deletedDiscoveredSymbols.iterator();
                while (iterator.hasNext()) {
                    ScannerInfoCollector.getInstance().deleteSymbol(this.fProject, (String)iterator.next());
                }
                this.deletedDiscoveredSymbols = null;
            }
        }
        this.setDirty(false);
        boolean bl = this.fDirty;
        this.fDirty = false;
        return bl;
    }

    public void restore() {
        if (this.fProject != null) {
            ScannerInfoCollector.getInstance().deleteAllSymbols(this.fProject);
        }
        this.discoveredSymbols = new LinkedHashMap();
        this.deletedDiscoveredSymbols = null;
        this.fDirty = true;
    }
}

