/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathInfo;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerInfoCollector;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.MessageLine;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class ManageIncludePathsDialog
extends Dialog {
    private static final String PREF_INCLUDES = "ScannerIncludes";
    private static final String PREFIX = "ManageIncludePathsDialog";
    private static final String DIALOG_TITLE = "ManageIncludePathsDialog.title";
    private static final String USER_GROUP = "ManageIncludePathsDialog.userGroup.title";
    private static final String NEW = "BuildPropertyCommon.label.new";
    private static final String EDIT = "BuildPropertyCommon.label.edit";
    private static final String REMOVE = "BuildPropertyCommon.label.remove";
    private static final String UP = "BuildPropertyCommon.label.up";
    private static final String DOWN = "BuildPropertyCommon.label.down";
    private static final String BROWSE = "BuildPathInfoBlock.browse";
    private static final String PATH_TITLE = "BuildPathInfoBlock.browse.path";
    private static final String EDIT_PATH_TITLE = "BuildPathInfoBlock.browse.path.edit";
    private static final String PATH_LABEL = "BuildPathInfoBlock.browse.path.label";
    private static final String DISCOVERED_GROUP = "ManageIncludePathsDialog.discoveredGroup.title";
    private static final String DISC_COMMON_PREFIX = "ManageScannerConfigDialogCommon";
    private static final String SELECTED_LABEL = "ManageScannerConfigDialogCommon.discoveredGroup.selected.label";
    private static final String REMOVED_LABEL = "ManageScannerConfigDialogCommon.discoveredGroup.removed.label";
    private static final String UP_DISCOVERED = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.up.label";
    private static final String DOWN_DISCOVERED = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.down.label";
    private static final String REMOVE_DISCOVERED = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.remove.label";
    private static final String RESTORE_DISCOVERED = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.restore.label";
    private static final String DELETE_DISCOVERED = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.delete.label";
    private static final String DELETE_ALL_DISCOVERED = "ManageScannerConfigDialogCommon.discoveredGroup.buttons.deleteAll.label";
    private static final int PROJECT_LIST_MULTIPLIER = 15;
    private static final int INITIAL_LIST_WIDTH = 50;
    private static final int ACTIVE = 0;
    private static final int REMOVED = 1;
    private static final int DO_REMOVE = 0;
    private static final int DO_RESTORE = 1;
    private static final int DISC_UP = 0;
    private static final int DISC_DOWN = 1;
    private ArrayList returnPaths;
    private ArrayList deletedDiscoveredPaths;
    private LinkedHashMap discoveredPaths;
    private LinkedHashMap workingDiscoveredPaths;
    private boolean fDirty;
    private boolean fWorkingDirty;
    private ICOptionContainer fContainer;
    private IProject fProject;
    private Shell fShell;
    private MessageLine fStatusLine;
    private Group discoveredGroup;
    private Label selectedLabel;
    private Label removedLabel;
    private List discActiveList;
    private List discRemovedList;
    private Button upDiscPath;
    private Button downDiscPath;
    private Button removeDiscPath;
    private Button restoreDiscPath;
    private Button deleteDiscPath;
    private Button deleteAllDiscPaths;

    protected ManageIncludePathsDialog(Shell shell, ICOptionContainer iCOptionContainer) {
        super(shell);
        DiscoveredPathInfo discoveredPathInfo;
        this.fShell = shell;
        this.fContainer = iCOptionContainer;
        this.fProject = this.fContainer.getProject();
        if (this.fProject != null) {
            try {
                discoveredPathInfo = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(this.fProject);
            }
            catch (CoreException coreException) {
                discoveredPathInfo = new DiscoveredPathInfo(this.fProject);
            }
        } else {
            discoveredPathInfo = new DiscoveredPathInfo(this.fProject);
        }
        this.discoveredPaths = discoveredPathInfo.getIncludeMap();
        this.setDirty(false);
        this.fDirty = false;
    }

    protected void configureShell(Shell shell) {
        shell.setText(this.getTitle(DIALOG_TITLE));
        super.configureShell(shell);
    }

    private String getTitle(String string) {
        return MakeUIPlugin.getResourceString(string);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        ((GridLayout)composite2.getLayout()).numColumns = 3;
        this.initializeDialogUnits((Control)composite2);
        this.fStatusLine = new MessageLine(composite2);
        this.fStatusLine.setAlignment(16384);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.fStatusLine.setLayoutData(gridData);
        this.fStatusLine.setMessage(this.getTitle(DIALOG_TITLE));
        this.createOptionsControls(composite2);
        this.createDiscoveredControls(composite2);
        this.setListContents();
        this.discActiveList.select(0);
        this.discActiveList.setFocus();
        this.enableDiscoveredButtons();
        return composite2;
    }

    private void setListContents() {
        this.workingDiscoveredPaths = new LinkedHashMap(this.discoveredPaths);
        this.discActiveList.setItems(this.getDiscIncludePaths(this.workingDiscoveredPaths, 0));
        this.discRemovedList.setItems(this.getDiscIncludePaths(this.workingDiscoveredPaths, 1));
    }

    private String[] getDiscIncludePaths(LinkedHashMap linkedHashMap, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = n != 0;
        Iterator iterator = linkedHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if ((Boolean)linkedHashMap.get(string) != bl) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] getIncludes(Preferences preferences) {
        String string = preferences.getString(PREF_INCLUDES);
        return this.parseStringToList(string);
    }

    private String[] parseStringToList(String string) {
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreElements()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return new String[0];
    }

    private void createOptionsControls(Composite composite) {
    }

    private void createDiscoveredControls(Composite composite) {
        this.discoveredGroup = ControlFactory.createGroup((Composite)composite, (String)this.getTitle(DISCOVERED_GROUP), (int)3);
        ((GridData)this.discoveredGroup.getLayoutData()).horizontalSpan = 3;
        ((GridData)this.discoveredGroup.getLayoutData()).grabExcessHorizontalSpace = true;
        this.selectedLabel = ControlFactory.createLabel((Composite)this.discoveredGroup, (String)this.getTitle(SELECTED_LABEL));
        ((GridData)this.selectedLabel.getLayoutData()).horizontalSpan = 1;
        ControlFactory.createLabel((Composite)this.discoveredGroup, (String)"");
        this.removedLabel = ControlFactory.createLabel((Composite)this.discoveredGroup, (String)this.getTitle(REMOVED_LABEL));
        ((GridData)this.removedLabel.getLayoutData()).horizontalSpan = 1;
        this.discActiveList = new List((Composite)this.discoveredGroup, 2820);
        this.discActiveList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManageIncludePathsDialog.this.discRemovedList.deselectAll();
                ManageIncludePathsDialog.this.enableDiscoveredButtons();
            }
        });
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        gridData.heightHint = ManageIncludePathsDialog.getDefaultFontHeight((Control)this.discActiveList, 15);
        gridData.widthHint = this.convertWidthInCharsToPixels(50);
        this.discActiveList.setLayoutData((Object)gridData);
        Composite composite2 = ControlFactory.createComposite((Composite)this.discoveredGroup, (int)1);
        this.upDiscPath = ControlFactory.createPushButton((Composite)composite2, (String)this.getTitle(UP_DISCOVERED));
        this.upDiscPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManageIncludePathsDialog.this.handleUpDownDiscPath(0);
            }
        });
        this.upDiscPath.setEnabled(true);
        SWTUtil.setButtonDimensionHint((Button)this.upDiscPath);
        this.downDiscPath = ControlFactory.createPushButton((Composite)composite2, (String)this.getTitle(DOWN_DISCOVERED));
        this.downDiscPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManageIncludePathsDialog.this.handleUpDownDiscPath(1);
            }
        });
        this.downDiscPath.setEnabled(true);
        SWTUtil.setButtonDimensionHint((Button)this.downDiscPath);
        this.removeDiscPath = ControlFactory.createPushButton((Composite)composite2, (String)this.getTitle(REMOVE_DISCOVERED));
        this.removeDiscPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManageIncludePathsDialog.this.handleRemoveRestoreDiscPath(0);
            }
        });
        this.removeDiscPath.setEnabled(true);
        SWTUtil.setButtonDimensionHint((Button)this.removeDiscPath);
        this.restoreDiscPath = ControlFactory.createPushButton((Composite)composite2, (String)this.getTitle(RESTORE_DISCOVERED));
        this.restoreDiscPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManageIncludePathsDialog.this.handleRemoveRestoreDiscPath(1);
            }
        });
        this.restoreDiscPath.setEnabled(true);
        SWTUtil.setButtonDimensionHint((Button)this.restoreDiscPath);
        ControlFactory.createSeparator((Composite)composite2, (int)1);
        this.deleteDiscPath = ControlFactory.createPushButton((Composite)composite2, (String)this.getTitle(DELETE_DISCOVERED));
        this.deleteDiscPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManageIncludePathsDialog.this.handleDeleteDiscPath();
            }
        });
        this.deleteDiscPath.setEnabled(true);
        SWTUtil.setButtonDimensionHint((Button)this.deleteDiscPath);
        this.deleteAllDiscPaths = ControlFactory.createPushButton((Composite)composite2, (String)this.getTitle(DELETE_ALL_DISCOVERED));
        this.deleteAllDiscPaths.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManageIncludePathsDialog.this.handleDeleteAllDiscPath();
            }
        });
        this.deleteAllDiscPaths.setEnabled(true);
        SWTUtil.setButtonDimensionHint((Button)this.deleteAllDiscPaths);
        this.discRemovedList = new List((Composite)this.discoveredGroup, 2820);
        this.discRemovedList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManageIncludePathsDialog.this.discActiveList.deselectAll();
                ManageIncludePathsDialog.this.enableDiscoveredButtons();
            }
        });
        GridData gridData2 = new GridData(1808);
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.horizontalSpan = 1;
        gridData2.heightHint = ManageIncludePathsDialog.getDefaultFontHeight((Control)this.discRemovedList, 15);
        gridData2.widthHint = this.convertWidthInCharsToPixels(50);
        this.discRemovedList.setLayoutData((Object)gridData2);
    }

    protected void handleUpDownDiscPath(int n) {
        Object object;
        int n2;
        boolean bl;
        List list;
        int n3;
        int n4 = n3 = n == 0 ? -1 : 1;
        if (this.discActiveList.getSelectionIndex() == -1) {
            list = this.discRemovedList;
            bl = true;
            n2 = 1;
        } else {
            list = this.discActiveList;
            bl = false;
            n2 = 0;
        }
        int n5 = list.getFocusIndex();
        String string = list.getItem(n5);
        ArrayList arrayList = new ArrayList(this.workingDiscoveredPaths.keySet());
        int n6 = arrayList.indexOf(string);
        int n7 = n6 + n3;
        boolean bl2 = false;
        while (n7 >= 0 && n7 < arrayList.size()) {
            object = (Boolean)this.workingDiscoveredPaths.get(arrayList.get(n7));
            if (object != null && (Boolean)object == bl) {
                bl2 = true;
                break;
            }
            n7 += n3;
        }
        if (bl2) {
            object = (String)arrayList.get(n6);
            arrayList.add(n6, arrayList.get(n7));
            arrayList.add(n7, object);
            LinkedHashMap linkedHashMap = new LinkedHashMap(this.workingDiscoveredPaths.size());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                linkedHashMap.put(string2, this.workingDiscoveredPaths.get(string2));
            }
            this.workingDiscoveredPaths = linkedHashMap;
            list.setItems(this.getDiscIncludePaths(this.workingDiscoveredPaths, n2));
            list.setSelection(n5 + n3);
            list.setFocus();
            this.enableDiscoveredButtons();
            this.setDirty(true);
        }
    }

    protected void handleRemoveRestoreDiscPath(int n) {
        if (this.workingDiscoveredPaths != null) {
            String string;
            Boolean bl;
            int n2;
            List list = this.discRemovedList;
            List list2 = this.discActiveList;
            boolean bl2 = true;
            if (n == 0) {
                list = this.discActiveList;
                list2 = this.discRemovedList;
                bl2 = false;
            }
            if ((n2 = list.getSelectionIndex()) != -1 && (bl = (Boolean)this.workingDiscoveredPaths.get(string = list.getItem(n2))) != null && bl == bl2) {
                this.workingDiscoveredPaths.put(string, !bl2);
                this.discActiveList.setItems(this.getDiscIncludePaths(this.workingDiscoveredPaths, 0));
                this.discRemovedList.setItems(this.getDiscIncludePaths(this.workingDiscoveredPaths, 1));
                list2.setSelection(list2.indexOf(string));
                this.enableDiscoveredButtons();
                this.setDirty(true);
            }
        }
    }

    protected void handleDeleteDiscPath() {
        this.deleteDiscPath(1);
        this.deleteDiscPath(0);
    }

    private void deleteDiscPath(int n) {
        int n2;
        List list = this.discRemovedList;
        if (n == 0) {
            list = this.discActiveList;
        }
        if ((n2 = list.getSelectionIndex()) >= 0) {
            String string = list.getItem(n2);
            if (this.deletedDiscoveredPaths == null) {
                this.deletedDiscoveredPaths = new ArrayList();
            }
            this.deletedDiscoveredPaths.add(string);
            this.workingDiscoveredPaths.remove(string);
            list.setItems(this.getDiscIncludePaths(this.workingDiscoveredPaths, n));
            int n3 = list.getItemCount();
            if (n3 > 0) {
                if (n2 >= n3) {
                    n2 = n3 - 1;
                }
                list.setSelection(n2);
                this.enableDiscoveredButtons();
                this.setDirty(true);
            }
        }
    }

    protected void handleDeleteAllDiscPath() {
        ScannerInfoCollector.getInstance().deleteAllPaths(this.fProject);
        this.workingDiscoveredPaths.clear();
        this.discActiveList.setItems(this.getDiscIncludePaths(this.workingDiscoveredPaths, 0));
        this.discRemovedList.setItems(this.getDiscIncludePaths(this.workingDiscoveredPaths, 1));
        this.enableDiscoveredButtons();
        this.setDirty(true);
    }

    protected void enableDiscoveredButtons() {
        this.discoveredGroup.setEnabled(this.fProject != null);
        this.selectedLabel.setEnabled(this.fProject != null);
        this.discActiveList.setEnabled(this.fProject != null);
        this.removedLabel.setEnabled(this.fProject != null);
        this.discRemovedList.setEnabled(this.fProject != null);
        int n = this.discActiveList.getItemCount();
        int n2 = this.discActiveList.getSelectionIndex();
        int n3 = this.discRemovedList.getItemCount();
        int n4 = this.discRemovedList.getSelectionIndex();
        this.upDiscPath.setEnabled(n > 0 && n2 > 0 || n3 > 0 && n4 > 0);
        this.downDiscPath.setEnabled(n > 0 && n2 >= 0 && n2 < n - 1 || n3 > 0 && n4 >= 0 && n4 < n3 - 1);
        this.removeDiscPath.setEnabled(n > 0 && n2 >= 0);
        this.restoreDiscPath.setEnabled(n3 > 0 && n4 >= 0);
        this.deleteDiscPath.setEnabled(n > 0 && n2 >= 0 || n3 > 0 && n4 >= 0);
        this.deleteAllDiscPaths.setEnabled(n > 0 || n3 > 0);
    }

    private static int getDefaultFontHeight(Control control, int n) {
        FontData[] fontDataArray = control.getFont().getFontData();
        int n2 = 10;
        if (fontDataArray.length > 0) {
            n2 = fontDataArray[0].getHeight();
        }
        return n * n2;
    }

    public String[] getManagedIncludes() {
        if (this.returnPaths == null) {
            return new String[0];
        }
        return this.returnPaths.toArray(new String[this.returnPaths.size()]);
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.discoveredPaths = this.workingDiscoveredPaths;
            this.returnPaths = new ArrayList(this.discActiveList.getItemCount());
            this.returnPaths.addAll(new ArrayList<String>(Arrays.asList(this.discActiveList.getItems())));
            this.fDirty = this.fWorkingDirty;
        } else if (1 == n) {
            this.deletedDiscoveredPaths = null;
            this.workingDiscoveredPaths = null;
            this.setDirty(false);
        }
        super.buttonPressed(n);
    }

    private void setDirty(boolean bl) {
        this.fWorkingDirty = bl;
    }

    public boolean saveTo(IDiscoveredPathManager.IDiscoveredPathInfo iDiscoveredPathInfo) {
        if (this.fDirty || this.fProject == null && this.fContainer.getProject() != null) {
            iDiscoveredPathInfo.setIncludeMap(this.discoveredPaths);
            if (this.deletedDiscoveredPaths != null) {
                Iterator iterator = this.deletedDiscoveredPaths.iterator();
                while (iterator.hasNext()) {
                    ScannerInfoCollector.getInstance().deletePath(this.fProject, (String)iterator.next());
                }
                this.deletedDiscoveredPaths = null;
            }
        }
        this.setDirty(false);
        boolean bl = this.fDirty;
        this.fDirty = false;
        return bl;
    }

    public void restore() {
        if (this.fProject != null) {
            ScannerInfoCollector.getInstance().deleteAllPaths(this.fProject);
        }
        this.discoveredPaths = new LinkedHashMap();
        this.deletedDiscoveredPaths = null;
        this.fDirty = true;
    }
}

