/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigBuilder;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.MessageLine;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ScannerConfigOptionsDialog
extends Dialog {
    private static final String PREFIX = "ScannerConfigOptionsDialog";
    private static final String DIALOG_TITLE = "ScannerConfigOptionsDialog.title";
    private static final String SI_BUILD_PARSER_GROUP = "ScannerConfigOptionsDialog.siBuilder.parser.group_label";
    private static final String ENABLE_SI_BUILD_PARSER = "ScannerConfigOptionsDialog.siBuilder.parser.enable.label";
    private static final String SI_BUILD_PARSER_LABEL = "ScannerConfigOptionsDialog.siBuilder.parser.label";
    private static final String SI_PROVIDER_CMD_GROUP = "ScannerConfigOptionsDialog.siProvider.cmd.group_label";
    private static final String ENABLE_SI_PROVIDER_COMMAND = "ScannerConfigOptionsDialog.siProvider.cmd.enable.label";
    private static final String SI_PROVIDER_CMD_USE_DEFAULT = "ScannerConfigOptionsDialog.siProvider.cmd.use_default";
    private static final String SI_PROVIDER_CMD_LABEL = "ScannerConfigOptionsDialog.siProvider.cmd.label";
    private static final String SI_PROVIDER_PARSER_LABEL = "ScannerConfigOptionsDialog.siProvider.parser.label";
    private static final String SI_PROVIDER_CMD_ERROR_MESSAGE = "ScannerConfigOptionsDialog.siProvider.cmd.error_message";
    private MessageLine fStatusLine;
    private Button defESIProviderCommandButton;
    private Text esiProviderCommand;
    private Button enableBuilderParserButton;
    private Combo makeBuilderSIParserComboBox;
    private Button enableProviderCommandButton;
    private Combo esiProviderParserComboBox;
    private ICOptionContainer fContainer;
    private Preferences fPrefs;
    private IScannerConfigBuilderInfo fBuildInfo;
    private boolean fInitialized;
    private Map builderParsers = new HashMap();
    private String initialBuilderParserId = null;
    private Map providerParsers = new HashMap();
    private String initialProviderParserId = null;

    ScannerConfigOptionsDialog(ICOptionContainer iCOptionContainer) {
        super(null);
        this.fInitialized = false;
        this.fContainer = iCOptionContainer;
        this.fPrefs = this.fContainer.getPreferences();
        IScannerConfigBuilderInfo iScannerConfigBuilderInfo = MakeCorePlugin.createScannerConfigBuildInfo((Preferences)this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)false);
        this.fBuildInfo = new LocalStore(iScannerConfigBuilderInfo);
    }

    ScannerConfigOptionsDialog(Shell shell, ICOptionContainer iCOptionContainer) {
        super(shell);
        IScannerConfigBuilderInfo iScannerConfigBuilderInfo;
        this.fInitialized = true;
        this.fContainer = iCOptionContainer;
        IProject iProject = this.fContainer.getProject();
        this.fPrefs = this.fContainer.getPreferences();
        if (iProject != null) {
            try {
                iScannerConfigBuilderInfo = MakeCorePlugin.createScannerConfigBuildInfo((IProject)iProject, (String)ScannerConfigBuilder.BUILDER_ID);
            }
            catch (CoreException coreException) {
                this.fInitialized = false;
                iScannerConfigBuilderInfo = MakeCorePlugin.createScannerConfigBuildInfo((Preferences)this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)true);
            }
        } else {
            iScannerConfigBuilderInfo = MakeCorePlugin.createScannerConfigBuildInfo((Preferences)this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)false);
        }
        this.retrieveSIConsoleParsers();
        this.initialBuilderParserId = iScannerConfigBuilderInfo.getMakeBuilderConsoleParserId();
        this.initialProviderParserId = iScannerConfigBuilderInfo.getESIProviderConsoleParserId();
        this.fBuildInfo = new LocalStore(iScannerConfigBuilderInfo);
    }

    private void retrieveSIConsoleParsers() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("ScannerInfoConsoleParser");
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                String string = iExtensionArray[n].getUniqueIdentifier();
                String string2 = iExtensionArray[n].getLabel();
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                String string3 = iConfigurationElementArray[0].getAttribute("commandId");
                if (string3.equals("makeBuilder") || string3.equals("all")) {
                    this.builderParsers.put(string2, string);
                }
                if (string3.equals("externalScannerInfoProvider") || string3.equals("all")) {
                    this.providerParsers.put(string2, string);
                }
                ++n;
            }
        }
    }

    protected void configureShell(Shell shell) {
        shell.setText(this.getTitle(DIALOG_TITLE));
        super.configureShell(shell);
    }

    private String getTitle(String string) {
        return MakeUIPlugin.getResourceString(string);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.initializeDialogUnits((Control)composite2);
        this.fStatusLine = new MessageLine(composite2);
        this.fStatusLine.setAlignment(16384);
        GridData gridData = new GridData(768);
        this.fStatusLine.setLayoutData(gridData);
        this.fStatusLine.setMessage(this.getTitle(DIALOG_TITLE));
        this.createBuildOutputParserControls(composite2);
        this.createAfterBuildCmdControls(composite2);
        this.enableAllControls();
        return composite2;
    }

    private void createBuildOutputParserControls(Composite composite) {
        Group group = ControlFactory.createGroup((Composite)composite, (String)MakeUIPlugin.getResourceString(SI_BUILD_PARSER_GROUP), (int)2);
        ((GridLayout)group.getLayout()).marginHeight = 5;
        ((GridLayout)group.getLayout()).marginWidth = 5;
        ((GridData)group.getLayoutData()).verticalAlignment = 4;
        this.enableBuilderParserButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(ENABLE_SI_BUILD_PARSER));
        ((GridData)this.enableBuilderParserButton.getLayoutData()).horizontalSpan = 2;
        boolean bl = this.fBuildInfo.isMakeBuilderConsoleParserEnabled();
        this.enableBuilderParserButton.setSelection(bl);
        this.enableBuilderParserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ScannerConfigOptionsDialog.this.makeBuilderSIParserComboBox.setEnabled(ScannerConfigOptionsDialog.this.isBuilderParserEnabled());
            }
        });
        Label label = ControlFactory.createLabel((Composite)group, (String)MakeUIPlugin.getResourceString(SI_BUILD_PARSER_LABEL));
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.makeBuilderSIParserComboBox = new Combo((Composite)group, 12);
        Iterator iterator = this.builderParsers.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.makeBuilderSIParserComboBox.add(string);
            if (!this.initialBuilderParserId.equals(this.builderParsers.get(string))) continue;
            this.makeBuilderSIParserComboBox.setText(string);
        }
        this.makeBuilderSIParserComboBox.setEnabled(bl);
    }

    private void createAfterBuildCmdControls(Composite composite) {
        Group group = ControlFactory.createGroup((Composite)composite, (String)MakeUIPlugin.getResourceString(SI_PROVIDER_CMD_GROUP), (int)2);
        ((GridData)group.getLayoutData()).horizontalSpan = 2;
        this.enableProviderCommandButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(ENABLE_SI_PROVIDER_COMMAND));
        ((GridData)this.enableProviderCommandButton.getLayoutData()).horizontalSpan = 2;
        ((GridData)this.enableProviderCommandButton.getLayoutData()).horizontalAlignment = 768;
        boolean bl = this.fBuildInfo.isESIProviderCommandEnabled();
        this.enableProviderCommandButton.setSelection(bl);
        this.enableProviderCommandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ScannerConfigOptionsDialog.this.defESIProviderCommandButton.setEnabled(ScannerConfigOptionsDialog.this.isProviderCommandEnabled());
                ScannerConfigOptionsDialog.this.esiProviderCommand.setEnabled(ScannerConfigOptionsDialog.this.isProviderCommandEnabled() && !ScannerConfigOptionsDialog.this.useDefaultESIProviderCmd());
                ScannerConfigOptionsDialog.this.esiProviderParserComboBox.setEnabled(ScannerConfigOptionsDialog.this.isProviderCommandEnabled());
            }
        });
        this.createESIProviderCmdControls((Composite)group);
        Label label = ControlFactory.createLabel((Composite)group, (String)MakeUIPlugin.getResourceString(SI_PROVIDER_PARSER_LABEL));
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.esiProviderParserComboBox = new Combo((Composite)group, 12);
        Iterator iterator = this.providerParsers.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.esiProviderParserComboBox.add(string);
            if (!this.initialProviderParserId.equals(this.providerParsers.get(string))) continue;
            this.esiProviderParserComboBox.setText(string);
        }
        this.defESIProviderCommandButton.setEnabled(bl);
        this.esiProviderCommand.setEnabled(bl && !this.useDefaultESIProviderCmd());
        this.esiProviderParserComboBox.setEnabled(bl);
    }

    private void createESIProviderCmdControls(Composite composite) {
        this.defESIProviderCommandButton = ControlFactory.createCheckBox((Composite)composite, (String)MakeUIPlugin.getResourceString(SI_PROVIDER_CMD_USE_DEFAULT));
        this.defESIProviderCommandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ScannerConfigOptionsDialog.this.esiProviderCommand.setEnabled(!ScannerConfigOptionsDialog.this.useDefaultESIProviderCmd());
            }
        });
        ((GridData)this.defESIProviderCommandButton.getLayoutData()).horizontalAlignment = 768;
        ((GridData)this.defESIProviderCommandButton.getLayoutData()).horizontalSpan = 2;
        Label label = ControlFactory.createLabel((Composite)composite, (String)MakeUIPlugin.getResourceString(SI_PROVIDER_CMD_LABEL));
        ((GridData)label.getLayoutData()).horizontalAlignment = 1;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.esiProviderCommand = ControlFactory.createTextField((Composite)composite, (int)2052);
        ((GridData)this.esiProviderCommand.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.esiProviderCommand.getLayoutData()).grabExcessHorizontalSpace = true;
        IPath iPath = this.fBuildInfo.getESIProviderCommand();
        if (iPath != null) {
            StringBuffer stringBuffer = new StringBuffer(iPath.toOSString());
            String string = this.fBuildInfo.getESIProviderArguments();
            if (string != null && string.length() > 0) {
                stringBuffer.append(' ');
                stringBuffer.append(string);
            }
            this.esiProviderCommand.setText(stringBuffer.toString());
        }
        if (this.fBuildInfo.isDefaultESIProviderCmd()) {
            this.esiProviderCommand.setEnabled(false);
        }
        this.esiProviderCommand.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ScannerConfigOptionsDialog.this.handleProviderCommandModify();
            }
        });
        this.defESIProviderCommandButton.setSelection(this.fBuildInfo.isDefaultESIProviderCmd());
    }

    protected void handleProviderCommandModify() {
        String string = this.esiProviderCommand.getText().trim();
        if (string.length() == 0) {
            this.fStatusLine.setErrorMessage(this.getTitle(SI_PROVIDER_CMD_ERROR_MESSAGE));
            this.getButton(0).setEnabled(false);
        } else {
            this.fStatusLine.setErrorMessage(null);
            this.getButton(0).setEnabled(true);
        }
    }

    private void enableAllControls() {
        this.enableBuilderParserButton.setEnabled(true);
        this.makeBuilderSIParserComboBox.setEnabled(this.isBuilderParserEnabled());
        this.enableProviderCommandButton.setEnabled(true);
        this.defESIProviderCommandButton.setEnabled(this.isProviderCommandEnabled());
        this.esiProviderCommand.setEnabled(this.isProviderCommandEnabled() && !this.useDefaultESIProviderCmd());
        this.esiProviderParserComboBox.setEnabled(this.isProviderCommandEnabled());
    }

    private boolean useDefaultESIProviderCmd() {
        return this.defESIProviderCommandButton.getSelection();
    }

    private String getSIProviderCommandLine() {
        return this.esiProviderCommand.getText().trim();
    }

    private boolean isBuilderParserEnabled() {
        return this.enableBuilderParserButton.getSelection();
    }

    private boolean isProviderCommandEnabled() {
        return this.enableProviderCommandButton.getSelection();
    }

    public boolean isScannerConfigDiscoveryEnabled() {
        return this.fBuildInfo.isAutoDiscoveryEnabled();
    }

    public void setScannerConfigDiscoveryEnabled(boolean bl) {
        try {
            this.fBuildInfo.setAutoDiscoveryEnabled(bl);
        }
        catch (CoreException coreException) {}
    }

    public void performApply(IProgressMonitor iProgressMonitor) throws CoreException {
        IProject iProject = this.fContainer.getProject();
        IScannerConfigBuilderInfo iScannerConfigBuilderInfo = iProject != null ? MakeCorePlugin.createScannerConfigBuildInfo((IProject)iProject, (String)ScannerConfigBuilder.BUILDER_ID) : MakeCorePlugin.createScannerConfigBuildInfo((Preferences)this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)false);
        iScannerConfigBuilderInfo.setAutoDiscoveryEnabled(this.fBuildInfo.isAutoDiscoveryEnabled());
        if (this.fBuildInfo.isAutoDiscoveryEnabled()) {
            iScannerConfigBuilderInfo.setMakeBuilderConsoleParserEnabled(this.fBuildInfo.isMakeBuilderConsoleParserEnabled());
            if (this.fBuildInfo.isMakeBuilderConsoleParserEnabled()) {
                iScannerConfigBuilderInfo.setMakeBuilderConsoleParserId(this.fBuildInfo.getMakeBuilderConsoleParserId());
            }
            iScannerConfigBuilderInfo.setESIProviderCommandEnabled(this.fBuildInfo.isESIProviderCommandEnabled());
            if (this.fBuildInfo.isESIProviderCommandEnabled()) {
                iScannerConfigBuilderInfo.setUseDefaultESIProviderCmd(this.fBuildInfo.isDefaultESIProviderCmd());
                if (!this.fBuildInfo.isDefaultESIProviderCmd()) {
                    iScannerConfigBuilderInfo.setESIProviderCommand(this.fBuildInfo.getESIProviderCommand());
                    iScannerConfigBuilderInfo.setESIProviderArguments(this.fBuildInfo.getESIProviderArguments());
                }
                iScannerConfigBuilderInfo.setESIProviderConsoleParserId(this.fBuildInfo.getESIProviderConsoleParserId());
            }
        }
    }

    private void storeSIProviderCommandLine(IScannerConfigBuilderInfo iScannerConfigBuilderInfo) throws CoreException {
        String string = this.getSIProviderCommandLine();
        int n = 0;
        int n2 = -1;
        if (string.startsWith("\"")) {
            n = 1;
            n2 = string.indexOf(34, 1);
        } else {
            n2 = string.indexOf(32);
        }
        Path path = n2 == -1 ? new Path(string) : new Path(string.substring(n, n2));
        iScannerConfigBuilderInfo.setESIProviderCommand((IPath)path);
        String string2 = "";
        if (n2 != -1) {
            string2 = string.substring(n2 + 1);
        }
        iScannerConfigBuilderInfo.setESIProviderArguments(string2);
    }

    public void performDefaults() {
        IScannerConfigBuilderInfo iScannerConfigBuilderInfo = this.fContainer.getProject() != null ? MakeCorePlugin.createScannerConfigBuildInfo((Preferences)this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)false) : MakeCorePlugin.createScannerConfigBuildInfo((Preferences)this.fPrefs, (String)ScannerConfigBuilder.BUILDER_ID, (boolean)true);
        this.fBuildInfo = new LocalStore(iScannerConfigBuilderInfo);
    }

    protected void okPressed() {
        try {
            this.fBuildInfo.setAutoDiscoveryEnabled(this.isScannerConfigDiscoveryEnabled());
            this.fBuildInfo.setMakeBuilderConsoleParserEnabled(this.isBuilderParserEnabled());
            this.fBuildInfo.setMakeBuilderConsoleParserId((String)this.builderParsers.get(this.makeBuilderSIParserComboBox.getText()));
            this.fBuildInfo.setESIProviderCommandEnabled(this.isProviderCommandEnabled());
            this.fBuildInfo.setUseDefaultESIProviderCmd(this.useDefaultESIProviderCmd());
            this.storeSIProviderCommandLine(this.fBuildInfo);
            this.fBuildInfo.setESIProviderConsoleParserId((String)this.providerParsers.get(this.esiProviderParserComboBox.getText()));
        }
        catch (CoreException coreException) {}
        super.okPressed();
    }

    public boolean isInitialized() {
        return this.fInitialized;
    }

    protected class LocalStore
    implements IScannerConfigBuilderInfo {
        private boolean fAutoDiscoveryEnabled;
        private boolean fMakeBuilderConsoleParserEnabled;
        private String fMakeBuilderConsoleParserId;
        private boolean fESIProviderCommandEnabled;
        private boolean fDefaultESIProviderCmd;
        private IPath fESIProviderCommand;
        private String fESIProviderArguments;
        private String fESIProviderConsoleParserId;
        private boolean fSIParserGenerationEnabled;

        public LocalStore(IScannerConfigBuilderInfo iScannerConfigBuilderInfo) {
            try {
                this.setAutoDiscoveryEnabled(iScannerConfigBuilderInfo.isAutoDiscoveryEnabled());
                this.setMakeBuilderConsoleParserEnabled(iScannerConfigBuilderInfo.isMakeBuilderConsoleParserEnabled());
                this.setMakeBuilderConsoleParserId(iScannerConfigBuilderInfo.getMakeBuilderConsoleParserId());
                this.setESIProviderCommandEnabled(iScannerConfigBuilderInfo.isESIProviderCommandEnabled());
                this.setUseDefaultESIProviderCmd(iScannerConfigBuilderInfo.isDefaultESIProviderCmd());
                this.setESIProviderCommand(iScannerConfigBuilderInfo.getESIProviderCommand());
                this.setESIProviderArguments(iScannerConfigBuilderInfo.getESIProviderArguments());
                this.setESIProviderConsoleParserId(iScannerConfigBuilderInfo.getESIProviderConsoleParserId());
                this.setSIProblemGenerationEnabled(iScannerConfigBuilderInfo.isSIProblemGenerationEnabled());
            }
            catch (CoreException coreException) {}
        }

        public boolean isAutoDiscoveryEnabled() {
            return this.fAutoDiscoveryEnabled;
        }

        public void setAutoDiscoveryEnabled(boolean bl) throws CoreException {
            this.fAutoDiscoveryEnabled = bl;
        }

        public boolean isMakeBuilderConsoleParserEnabled() {
            return this.fMakeBuilderConsoleParserEnabled;
        }

        public void setMakeBuilderConsoleParserEnabled(boolean bl) throws CoreException {
            this.fMakeBuilderConsoleParserEnabled = bl;
        }

        public String getMakeBuilderConsoleParserId() {
            return this.fMakeBuilderConsoleParserId;
        }

        public void setMakeBuilderConsoleParserId(String string) throws CoreException {
            this.fMakeBuilderConsoleParserId = new String(string);
        }

        public boolean isESIProviderCommandEnabled() {
            return this.fESIProviderCommandEnabled;
        }

        public void setESIProviderCommandEnabled(boolean bl) throws CoreException {
            this.fESIProviderCommandEnabled = bl;
        }

        public boolean isDefaultESIProviderCmd() {
            return this.fDefaultESIProviderCmd;
        }

        public void setUseDefaultESIProviderCmd(boolean bl) throws CoreException {
            this.fDefaultESIProviderCmd = bl;
        }

        public IPath getESIProviderCommand() {
            return this.fESIProviderCommand;
        }

        public void setESIProviderCommand(IPath iPath) throws CoreException {
            this.fESIProviderCommand = new Path(iPath.toString());
        }

        public String getESIProviderArguments() {
            return this.fESIProviderArguments;
        }

        public void setESIProviderArguments(String string) throws CoreException {
            this.fESIProviderArguments = new String(string);
        }

        public String getESIProviderConsoleParserId() {
            return this.fESIProviderConsoleParserId;
        }

        public void setESIProviderConsoleParserId(String string) throws CoreException {
            this.fESIProviderConsoleParserId = new String(string);
        }

        public boolean isSIProblemGenerationEnabled() {
            return this.fSIParserGenerationEnabled;
        }

        public void setSIProblemGenerationEnabled(boolean bl) throws CoreException {
            this.fSIParserGenerationEnabled = bl;
        }
    }
}

