/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.IMakeHelpContextIds;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class SettingsBlock
extends AbstractCOptionPage {
    private static final String PREFIX = "SettingsBlock";
    private static final String MAKE_LABEL = "SettingsBlock.label";
    private static final String MAKE_MESSAGE = "SettingsBlock.message";
    private static final String MAKE_SETTING_GROUP = "SettingsBlock.makeSetting.group_label";
    private static final String MAKE_SETTING_STOP_ERROR = "SettingsBlock.makeSetting.stopOnError";
    private static final String MAKE_CMD_GROUP = "SettingsBlock.makeCmd.group_label";
    private static final String MAKE_CMD_USE_DEFAULT = "SettingsBlock.makeCmd.use_default";
    private static final String MAKE_CMD_LABEL = "SettingsBlock.makeCmd.label";
    private static final String MAKE_WORKBENCH_BUILD_GROUP = "SettingsBlock.makeWorkbench.group_label";
    private static final String MAKE_WORKBENCH_BUILD_TYPE = "SettingsBlock.makeWorkbench.type";
    private static final String MAKE_WORKBENCH_BUILD_TARGET = "SettingsBlock.makeWorkbench.target";
    private static final String MAKE_WORKBENCH_BUILD_AUTO = "SettingsBlock.makeWorkbench.auto";
    private static final String MAKE_WORKBENCH_BUILD_INCR = "SettingsBlock.makeWorkbench.incremental";
    private static final String MAKE_WORKBENCH_BUILD_FULL = "SettingsBlock.makeWorkbench.full";
    private static final String MAKE_WORKBENCH_BUILD_CLEAN = "SettingsBlock.makeWorkbench.clean";
    private static final String MAKE_BUILD_DIR_GROUP = "SettingsBlock.makeDir.group_label";
    private static final String MAKE_BUILD_DIR_LABEL = "SettingsBlock.makeDir.label";
    private static final String MAKE_BUILD_DIR_BROWSE = "SettingsBlock.makeDir.browse";
    private static final String MAKE_BUILD_AUTO_TARGET = "SettingsBlock.makeWorkbench.autoBuildTarget";
    private static final String MAKE_BUILD_INCREMENTAL_TARGET = "SettingsBlock.makeWorkbench.incrementalBuildTarget";
    private static final String MAKE_BUILD_FULL_TARGET = "SettingsBlock.makeWorkbench.fullBuildTarget";
    private static final String MAKE_BUILD_CLEAN_TARGET = "SettingsBlock.makeWorkbench.cleanTarget";
    Button stopOnErrorButton;
    Button defButton;
    Text buildCommand;
    Text buildLocation;
    Text targetFull;
    Text targetIncr;
    Text targetAuto;
    Text targetClean;
    Button fullButton;
    Button incrButton;
    Button autoButton;
    Button cleanButton;
    IMakeBuilderInfo fBuildInfo;
    Preferences fPrefs;
    String fBuilderID;

    public SettingsBlock(Preferences preferences, String string) {
        super(MakeUIPlugin.getResourceString(MAKE_LABEL));
        this.setDescription(MakeUIPlugin.getResourceString(MAKE_MESSAGE));
        this.fPrefs = preferences;
        this.fBuilderID = string;
    }

    protected void createSettingControls(Composite composite) {
        Group group = ControlFactory.createGroup((Composite)composite, (String)MakeUIPlugin.getResourceString(MAKE_SETTING_GROUP), (int)1);
        this.stopOnErrorButton = new Button((Composite)group, 32);
        this.stopOnErrorButton.setText(MakeUIPlugin.getResourceString(MAKE_SETTING_STOP_ERROR));
        if (this.fBuildInfo.isStopOnError()) {
            this.stopOnErrorButton.setSelection(true);
        }
        this.stopOnErrorButton.setEnabled(this.fBuildInfo.isDefaultBuildCmd());
    }

    protected void createBuildCmdControls(Composite composite) {
        Group group = ControlFactory.createGroup((Composite)composite, (String)MakeUIPlugin.getResourceString(MAKE_CMD_GROUP), (int)1);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.horizontalSpacing = 0;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        this.defButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_CMD_USE_DEFAULT));
        this.defButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (SettingsBlock.this.defButton.getSelection()) {
                    SettingsBlock.this.buildCommand.setEnabled(false);
                    SettingsBlock.this.stopOnErrorButton.setEnabled(true);
                    SettingsBlock.this.getContainer().updateContainer();
                } else {
                    SettingsBlock.this.buildCommand.setEnabled(true);
                    SettingsBlock.this.stopOnErrorButton.setEnabled(false);
                    SettingsBlock.this.getContainer().updateContainer();
                }
            }
        });
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.defButton.setLayoutData((Object)gridData);
        Label label = ControlFactory.createLabel((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_CMD_LABEL));
        ((GridData)label.getLayoutData()).horizontalAlignment = 1;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.buildCommand = ControlFactory.createTextField((Composite)group, (int)2052);
        ((GridData)this.buildCommand.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.buildCommand.getLayoutData()).grabExcessHorizontalSpace = true;
        this.buildCommand.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                SettingsBlock.this.getContainer().updateContainer();
            }
        });
        if (this.fBuildInfo.getBuildCommand() != null) {
            String string;
            StringBuffer stringBuffer = new StringBuffer(this.fBuildInfo.getBuildCommand().toOSString());
            if (!this.fBuildInfo.isDefaultBuildCmd() && (string = this.fBuildInfo.getBuildArguments()) != null && !string.equals("")) {
                stringBuffer.append(" ");
                stringBuffer.append(string);
            }
            this.buildCommand.setText(stringBuffer.toString());
        }
        if (this.fBuildInfo.isDefaultBuildCmd()) {
            this.buildCommand.setEnabled(false);
        }
        this.defButton.setSelection(this.fBuildInfo.isDefaultBuildCmd());
    }

    protected void createWorkBenchBuildControls(Composite composite) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SettingsBlock.this.targetAuto.setEnabled(SettingsBlock.this.autoButton.getSelection());
                SettingsBlock.this.targetFull.setEnabled(SettingsBlock.this.fullButton.getSelection());
                SettingsBlock.this.targetIncr.setEnabled(SettingsBlock.this.incrButton.getSelection());
                SettingsBlock.this.targetClean.setEnabled(SettingsBlock.this.cleanButton.getSelection());
                SettingsBlock.this.getContainer().updateContainer();
            }
        };
        Group group = ControlFactory.createGroup((Composite)composite, (String)MakeUIPlugin.getResourceString(MAKE_WORKBENCH_BUILD_GROUP), (int)1);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 0);
        label.setText(MakeUIPlugin.getResourceString(MAKE_WORKBENCH_BUILD_TYPE));
        label = new Label((Composite)group, 0);
        label.setText(MakeUIPlugin.getResourceString(MAKE_WORKBENCH_BUILD_TARGET));
        this.autoButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_WORKBENCH_BUILD_AUTO));
        this.autoButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.autoButton.setSelection(this.fBuildInfo.isAutoBuildEnable());
        this.targetAuto = ControlFactory.createTextField((Composite)group, (int)2052);
        this.targetAuto.setText(this.fBuildInfo.getAutoBuildTarget());
        ((GridData)this.targetAuto.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.targetAuto.getLayoutData()).grabExcessHorizontalSpace = true;
        this.addControlAccessibleListener((Control)this.targetAuto, MakeUIPlugin.getResourceString(MAKE_BUILD_AUTO_TARGET));
        String string = MakeUIPlugin.getResourceString("SettingsBlock.makeWorkbench.note");
        String string2 = MakeUIPlugin.getResourceString("SettingsBlock.makeWorkbench.autobuildMessage");
        Composite composite2 = this.createNoteComposite(JFaceResources.getDialogFont(), (Composite)group, string, string2);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        this.incrButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_WORKBENCH_BUILD_INCR));
        this.incrButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.incrButton.setSelection(this.fBuildInfo.isIncrementalBuildEnabled());
        this.targetIncr = ControlFactory.createTextField((Composite)group, (int)2052);
        this.targetIncr.setText(this.fBuildInfo.getIncrementalBuildTarget());
        ((GridData)this.targetIncr.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.targetIncr.getLayoutData()).grabExcessHorizontalSpace = true;
        this.addControlAccessibleListener((Control)this.targetIncr, MakeUIPlugin.getResourceString(MAKE_BUILD_INCREMENTAL_TARGET));
        this.fullButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_WORKBENCH_BUILD_FULL));
        this.fullButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.fullButton.setSelection(this.fBuildInfo.isFullBuildEnabled());
        this.targetFull = ControlFactory.createTextField((Composite)group, (int)2052);
        this.targetFull.setText(this.fBuildInfo.getFullBuildTarget());
        ((GridData)this.targetFull.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.targetFull.getLayoutData()).grabExcessHorizontalSpace = true;
        this.addControlAccessibleListener((Control)this.targetFull, MakeUIPlugin.getResourceString(MAKE_BUILD_FULL_TARGET));
        this.cleanButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_WORKBENCH_BUILD_CLEAN));
        this.cleanButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.cleanButton.setSelection(this.fBuildInfo.isCleanBuildEnabled());
        this.targetClean = ControlFactory.createTextField((Composite)group, (int)2052);
        this.targetClean.setText(this.fBuildInfo.getCleanBuildTarget());
        ((GridData)this.targetClean.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.targetClean.getLayoutData()).grabExcessHorizontalSpace = true;
        this.addControlAccessibleListener((Control)this.targetClean, MakeUIPlugin.getResourceString(MAKE_BUILD_CLEAN_TARGET));
        selectionAdapter.widgetSelected(null);
    }

    protected Composite createNoteComposite(Font font, Composite composite, String string, String string2) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(256));
        composite2.setFont(font);
        final Label label = new Label(composite2, 1);
        label.setText(string);
        label.setFont(JFaceResources.getBannerFont());
        label.setLayoutData((Object)new GridData(2));
        final IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("org.eclipse.jface.bannerfont".equals(propertyChangeEvent.getProperty())) {
                    label.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
                }
            }
        };
        JFaceResources.getFontRegistry().addListener(iPropertyChangeListener);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                JFaceResources.getFontRegistry().removeListener(iPropertyChangeListener);
            }
        });
        Label label2 = new Label(composite2, 64);
        label2.setText(string2);
        label2.setFont(font);
        return composite2;
    }

    public void addControlAccessibleListener(Control control, String string) {
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(string));
    }

    protected void createBuilderWorkingDirControls(Composite composite) {
        Group group = ControlFactory.createGroup((Composite)composite, (String)MakeUIPlugin.getResourceString(MAKE_BUILD_DIR_GROUP), (int)1);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        Label label = ControlFactory.createLabel((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_BUILD_DIR_LABEL));
        ((GridData)label.getLayoutData()).horizontalAlignment = 1;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.buildLocation = ControlFactory.createTextField((Composite)group, (int)2052);
        ((GridData)this.buildLocation.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.buildLocation.getLayoutData()).grabExcessHorizontalSpace = true;
        this.buildLocation.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                SettingsBlock.this.getContainer().updateContainer();
            }
        });
        Button button = new Button((Composite)group, 0);
        button.setText(MakeUIPlugin.getResourceString(MAKE_BUILD_DIR_BROWSE));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object[] objectArray;
                ContainerSelectionDialog containerSelectionDialog = new ContainerSelectionDialog(SettingsBlock.this.getShell(), (IContainer)SettingsBlock.this.getContainer().getProject(), true, MakeUIPlugin.getResourceString("SettingsBlock.title.selectLocationToBuildFrom"));
                if (containerSelectionDialog.open() == 0 && (objectArray = containerSelectionDialog.getResult()).length > 0) {
                    SettingsBlock.this.buildLocation.setText(((IPath)objectArray[0]).toOSString());
                }
            }
        });
        this.buildLocation.setText(this.fBuildInfo.getBuildLocation().toOSString());
    }

    public void createControl(Composite composite) {
        Composite composite2 = ControlFactory.createComposite((Composite)composite, (int)1);
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IMakeHelpContextIds.MAKE_BUILDER_SETTINGS);
        if (this.fBuildInfo == null) {
            ControlFactory.createEmptySpace((Composite)composite2);
            ControlFactory.createLabel((Composite)composite2, (String)MakeUIPlugin.getResourceString("SettingsBlock.label.missingBuilderInformation"));
            return;
        }
        this.createBuildCmdControls(composite2);
        this.createSettingControls(composite2);
        this.createWorkBenchBuildControls(composite2);
        if (this.getContainer().getProject() != null) {
            this.createBuilderWorkingDirControls(composite2);
        }
    }

    public boolean isValid() {
        String string;
        return this.defButton == null || this.defButton.getSelection() || (string = this.getBuildLine()) != null && string.length() != 0;
    }

    public void performApply(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.fBuildInfo == null) {
            return;
        }
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        IWorkspace iWorkspace = MakeUIPlugin.getWorkspace();
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                iProgressMonitor.beginTask(MakeUIPlugin.getResourceString("SettingsBlock.monitor.applyingSettings"), 1);
                IMakeBuilderInfo iMakeBuilderInfo = null;
                if (SettingsBlock.this.getContainer().getProject() != null) {
                    try {
                        iMakeBuilderInfo = MakeCorePlugin.createBuildInfo((IProject)SettingsBlock.this.getContainer().getProject(), (String)SettingsBlock.this.fBuilderID);
                    }
                    catch (CoreException coreException) {
                        MakeCorePlugin.log((Throwable)coreException);
                        return;
                    }
                } else {
                    iMakeBuilderInfo = MakeCorePlugin.createBuildInfo((Preferences)SettingsBlock.this.fPrefs, (String)SettingsBlock.this.fBuilderID, (boolean)false);
                }
                iMakeBuilderInfo.setStopOnError(SettingsBlock.this.isStopOnError());
                iMakeBuilderInfo.setUseDefaultBuildCmd(SettingsBlock.this.useDefaultBuildCmd());
                if (!SettingsBlock.this.useDefaultBuildCmd()) {
                    String string = SettingsBlock.this.getBuildLine();
                    int n = 0;
                    int n2 = -1;
                    if (!string.startsWith("\"")) {
                        n2 = string.indexOf(32);
                    } else {
                        n = 1;
                        n2 = string.indexOf(34, 1);
                    }
                    Path path = n2 == -1 ? new Path(string) : new Path(string.substring(n, n2));
                    iMakeBuilderInfo.setBuildCommand((IPath)path);
                    String string2 = "";
                    if (n2 != -1) {
                        string2 = string.substring(n2 + 1);
                    }
                    iMakeBuilderInfo.setBuildArguments(string2);
                }
                iMakeBuilderInfo.setAutoBuildEnable(SettingsBlock.this.autoButton.getSelection());
                iMakeBuilderInfo.setAutoBuildTarget(SettingsBlock.this.targetAuto.getText().trim());
                iMakeBuilderInfo.setIncrementalBuildEnable(SettingsBlock.this.incrButton.getSelection());
                iMakeBuilderInfo.setIncrementalBuildTarget(SettingsBlock.this.targetIncr.getText().trim());
                iMakeBuilderInfo.setFullBuildEnable(SettingsBlock.this.fullButton.getSelection());
                iMakeBuilderInfo.setFullBuildTarget(SettingsBlock.this.targetFull.getText().trim());
                iMakeBuilderInfo.setCleanBuildEnable(SettingsBlock.this.cleanButton.getSelection());
                iMakeBuilderInfo.setCleanBuildTarget(SettingsBlock.this.targetClean.getText().trim());
                if (SettingsBlock.this.buildLocation != null) {
                    iMakeBuilderInfo.setBuildLocation((IPath)new Path(SettingsBlock.this.buildLocation.getText().trim()));
                }
            }
        };
        if (this.getContainer().getProject() != null) {
            iWorkspace.run(iWorkspaceRunnable, iProgressMonitor);
        } else {
            iWorkspaceRunnable.run(iProgressMonitor);
        }
    }

    public void performDefaults() {
        if (this.fBuildInfo == null) {
            return;
        }
        IMakeBuilderInfo iMakeBuilderInfo = this.getContainer().getProject() != null ? MakeCorePlugin.createBuildInfo((Preferences)this.fPrefs, (String)this.fBuilderID, (boolean)false) : MakeCorePlugin.createBuildInfo((Preferences)this.fPrefs, (String)this.fBuilderID, (boolean)true);
        if (iMakeBuilderInfo.isStopOnError()) {
            this.stopOnErrorButton.setSelection(true);
        } else {
            this.stopOnErrorButton.setSelection(false);
        }
        if (iMakeBuilderInfo.getBuildCommand() != null) {
            String string;
            StringBuffer stringBuffer = new StringBuffer(iMakeBuilderInfo.getBuildCommand().toOSString());
            if (!iMakeBuilderInfo.isDefaultBuildCmd() && (string = iMakeBuilderInfo.getBuildArguments()) != null && !string.equals("")) {
                stringBuffer.append(" ");
                stringBuffer.append(string);
            }
            this.buildCommand.setText(stringBuffer.toString());
        }
        if (iMakeBuilderInfo.isDefaultBuildCmd()) {
            this.buildCommand.setEnabled(false);
            this.stopOnErrorButton.setEnabled(true);
        } else {
            this.buildCommand.setEnabled(true);
            this.stopOnErrorButton.setEnabled(false);
        }
        this.defButton.setSelection(iMakeBuilderInfo.isDefaultBuildCmd());
        this.autoButton.setSelection(iMakeBuilderInfo.isAutoBuildEnable());
        this.targetAuto.setText(iMakeBuilderInfo.getAutoBuildTarget());
        this.incrButton.setSelection(iMakeBuilderInfo.isIncrementalBuildEnabled());
        this.targetIncr.setText(iMakeBuilderInfo.getIncrementalBuildTarget());
        this.fullButton.setSelection(iMakeBuilderInfo.isFullBuildEnabled());
        this.targetFull.setText(iMakeBuilderInfo.getFullBuildTarget());
        this.cleanButton.setSelection(iMakeBuilderInfo.isCleanBuildEnabled());
        this.targetClean.setText(iMakeBuilderInfo.getCleanBuildTarget());
    }

    boolean isStopOnError() {
        return this.stopOnErrorButton.getSelection();
    }

    boolean useDefaultBuildCmd() {
        return this.defButton.getSelection();
    }

    String getBuildLine() {
        String string;
        if (this.buildCommand != null && (string = this.buildCommand.getText()) != null) {
            return string.trim();
        }
        return null;
    }

    public void setContainer(ICOptionContainer iCOptionContainer) {
        super.setContainer(iCOptionContainer);
        if (this.getContainer().getProject() != null) {
            try {
                this.fBuildInfo = MakeCorePlugin.createBuildInfo((IProject)this.getContainer().getProject(), (String)this.fBuilderID);
            }
            catch (CoreException coreException) {}
        } else {
            this.fBuildInfo = MakeCorePlugin.createBuildInfo((Preferences)this.fPrefs, (String)this.fBuilderID, (boolean)false);
        }
    }

    public String getErrorMessage() {
        String string;
        if (!(this.useDefaultBuildCmd() || (string = this.getBuildLine()) != null && string.length() != 0)) {
            return MakeUIPlugin.getResourceString("SettingsBlock.message.mustEnterBuildCommand");
        }
        return null;
    }

    private class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String string) {
            this.controlName = string;
        }

        public void getName(AccessibleEvent accessibleEvent) {
            accessibleEvent.result = this.controlName;
        }
    }
}

