/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.views;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.MakeUIImages;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;

public class DeleteTargetAction
extends SelectionListenerAction {
    Shell shell;
    IResource resource;

    public DeleteTargetAction(Shell shell) {
        super(MakeUIPlugin.getResourceString("DeleteTargetAction.label"));
        this.shell = shell;
        this.setToolTipText(MakeUIPlugin.getResourceString("DeleteTargetAction.tooltip"));
        MakeUIImages.setImageDescriptors((IAction)this, "tool16", MakeUIImages.IMG_TOOLS_MAKE_TARGET_DELETE);
    }

    boolean confirmDelete() {
        String string;
        String string2;
        List list = this.getTargetsToDelete();
        if (list.size() == 1) {
            string2 = MakeUIPlugin.getResourceString("DeleteTargetAction.title.confirmDeletion");
            IMakeTarget iMakeTarget = (IMakeTarget)list.get(0);
            string = MessageFormat.format(MakeUIPlugin.getResourceString("DeleteTargetAction.message.confirmDeleteion"), iMakeTarget.getName());
        } else {
            string2 = MakeUIPlugin.getResourceString("DeleteTargetAction.title.confirmMultipleDeletion");
            string = MessageFormat.format(MakeUIPlugin.getResourceString("DeleteTargetAction.message.confirmMultipleDeletion"), new Integer(list.size()));
        }
        return MessageDialog.openQuestion((Shell)this.shell, (String)string2, (String)string);
    }

    public void run() {
        if (!this.canDelete() || !this.confirmDelete()) {
            return;
        }
        List list = this.getTargetsToDelete();
        IMakeTargetManager iMakeTargetManager = MakeCorePlugin.getDefault().getTargetManager();
        Iterator iterator = list.iterator();
        try {
            while (iterator.hasNext()) {
                iMakeTargetManager.removeTarget((IMakeTarget)iterator.next());
            }
        }
        catch (CoreException coreException) {
            MakeUIPlugin.errorDialog(this.shell, MakeUIPlugin.getResourceString("DeleteTargetAction.exception.removeError"), MakeUIPlugin.getResourceString("DeleteTargetAction.exception.errorDeletingBuildTarget"), coreException);
        }
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        return super.updateSelection(iStructuredSelection) && this.canDelete();
    }

    private List getTargetsToDelete() {
        return this.getStructuredSelection().toList();
    }

    private boolean canDelete() {
        List list = this.getStructuredSelection().toList();
        if (list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof IMakeTarget) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

