/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.views;

import org.eclipse.cdt.make.ui.IMakeHelpContextIds;
import org.eclipse.cdt.make.ui.MakeContentProvider;
import org.eclipse.cdt.make.ui.MakeLabelProvider;
import org.eclipse.cdt.make.ui.views.AddTargetAction;
import org.eclipse.cdt.make.ui.views.BuildTargetAction;
import org.eclipse.cdt.make.ui.views.DeleteTargetAction;
import org.eclipse.cdt.make.ui.views.EditTargetAction;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class MakeView
extends ViewPart {
    private BuildTargetAction buildTargetAction;
    private EditTargetAction editTargetAction;
    private DeleteTargetAction deleteTargetAction;
    AddTargetAction addTargetAction;
    TreeViewer viewer;
    DrillDownAdapter drillDownAdapter;

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public void createPartControl(Composite composite) {
        WorkbenchHelp.setHelp((Control)composite, (String)IMakeHelpContextIds.MAKE_VIEW);
        this.viewer = new TreeViewer(composite, 770);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new MakeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MakeLabelProvider());
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                MakeView.this.handleDoubleClick(doubleClickEvent);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                MakeView.this.handleSelectionChanged(selectionChangedEvent);
            }
        });
        this.viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0) {
                    MakeView.this.handleDeleteKeyPressed();
                }
            }
        });
        this.viewer.setContentProvider((IContentProvider)new MakeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MakeLabelProvider());
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void makeActions() {
        this.buildTargetAction = new BuildTargetAction(this.viewer.getControl().getShell());
        this.addTargetAction = new AddTargetAction(this.viewer.getControl().getShell());
        this.deleteTargetAction = new DeleteTargetAction(this.viewer.getControl().getShell());
        this.editTargetAction = new EditTargetAction(this.viewer.getControl().getShell());
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        this.drillDownAdapter.addNavigationActions(iToolBarManager);
        iToolBarManager.add((IAction)this.buildTargetAction);
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                MakeView.this.fillContextMenu(iMenuManager);
                MakeView.this.updateActions((IStructuredSelection)MakeView.this.viewer.getSelection());
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.buildTargetAction);
        iMenuManager.add((IAction)this.addTargetAction);
        iMenuManager.add((IAction)this.deleteTargetAction);
        iMenuManager.add((IAction)this.editTargetAction);
        iMenuManager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(iMenuManager);
    }

    protected void handleDeleteKeyPressed() {
        this.deleteTargetAction.run();
    }

    protected void handleDoubleClick(DoubleClickEvent doubleClickEvent) {
        this.buildTargetAction.run();
    }

    void handleSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        this.updateActions(iStructuredSelection);
    }

    void updateActions(IStructuredSelection iStructuredSelection) {
        this.addTargetAction.selectionChanged(iStructuredSelection);
        this.buildTargetAction.selectionChanged(iStructuredSelection);
        this.deleteTargetAction.selectionChanged(iStructuredSelection);
        this.editTargetAction.selectionChanged(iStructuredSelection);
    }
}

