/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.internal.ui.dialogs.SelectionStatusDialog;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class BrowseEntryDialog
extends SelectionStatusDialog {
    private static final String PREFIX = "BuildPropertyCommon";
    private static final String LABEL = "BuildPropertyCommon.label";
    private static final String BROWSE = "BuildPropertyCommon.label.browse";
    private static final String HIDE = "hideAdvanced";
    private static final String SHOW = "showAdvanced";
    private static final String EMPTY = "NewFolderDialog.folderNameEmpty";
    private static final String ERROR_FOLDER_NAME_INVALID = "BuildPropertyCommon.error.Folder_name_invalid";
    private String title = "";
    private String message = "";
    private String folderName = "";
    private int basicShellHeight;
    private Button advancedButton = null;
    private Button browseButton = null;
    private Label errorMessageLabel;
    private Composite macroComposite;
    private Text text = null;

    public BrowseEntryDialog(Shell shell, String string, String string2, String string3) {
        super(shell);
        if (string != null) {
            this.title = string;
        }
        if (string2 != null) {
            this.message = string2;
        }
        if (string3 != null) {
            this.folderName = string3;
        }
        this.setStatusLineAboveButtons(true);
    }

    protected void computeResult() {
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    private void createAdvancedBrowseArea(Composite composite) {
        this.advancedButton = new Button(composite, 8);
        Dialog.applyDialogFont((Control)this.advancedButton);
        this.advancedButton.setText(IDEWorkbenchMessages.getString((String)SHOW));
        this.setButtonLayoutData(this.advancedButton);
        GridData gridData = (GridData)this.advancedButton.getLayoutData();
        gridData.horizontalAlignment = 1;
        this.advancedButton.setLayoutData((Object)gridData);
        this.advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BrowseEntryDialog.this.handleAdvancedPressed();
            }
        });
        this.advancedButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                BrowseEntryDialog.this.advancedButton = null;
            }
        });
    }

    private void createBasicBrowseArea(Composite composite) {
        GridData gridData;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(768));
        if (this.message != null) {
            Label label = new Label(composite2, 64);
            label.setText(this.message);
            gridData = new GridData(1794);
            gridData.widthHint = this.convertHorizontalDLUsToPixels(300);
            gridData.horizontalSpan = 2;
            label.setLayoutData((Object)gridData);
            Dialog.applyDialogFont((Control)label);
        }
        this.text = new Text(composite2, 2052);
        gridData = new GridData(1808);
        gridData.widthHint = 200;
        this.text.setLayoutData((Object)gridData);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                BrowseEntryDialog.this.validateLocation();
            }
        });
        Dialog.applyDialogFont((Control)this.text);
        this.browseButton = new Button(composite2, 8);
        Dialog.applyDialogFont((Control)this.browseButton);
        this.browseButton.setText(ManagedBuilderUIMessages.getResourceString(BROWSE));
        this.setButtonLayoutData(this.browseButton);
        gridData = (GridData)this.browseButton.getLayoutData();
        gridData.horizontalAlignment = 1;
        this.browseButton.setLayoutData((Object)gridData);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BrowseEntryDialog.this.handleBrowsePressed();
            }
        });
        this.browseButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                BrowseEntryDialog.this.browseButton = null;
            }
        });
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.createBasicBrowseArea(composite2);
        this.createAdvancedBrowseArea(composite2);
        return composite2;
    }

    public String getValue() {
        return this.folderName;
    }

    protected void handleAdvancedPressed() {
        Shell shell = this.getShell();
        Point point = shell.getSize();
        if (this.macroComposite == null) {
            this.basicShellHeight = shell.computeSize((int)-1, (int)-1, (boolean)true).y;
            Composite composite = (Composite)this.getDialogArea();
            this.macroComposite = ControlFactory.createComposite((Composite)composite, (int)1);
            point = shell.computeSize(-1, -1, true);
            shell.setSize(point);
            this.advancedButton.setText(IDEWorkbenchMessages.getString((String)HIDE));
        } else if (this.macroComposite.getVisible()) {
            this.macroComposite.setVisible(false);
            shell.setSize(point.x, this.basicShellHeight);
            this.advancedButton.setText(IDEWorkbenchMessages.getString((String)SHOW));
        } else {
            this.macroComposite.setVisible(true);
            point = shell.computeSize(-1, -1, true);
            shell.setSize(point);
            this.advancedButton.setText(IDEWorkbenchMessages.getString((String)HIDE));
        }
    }

    protected void handleBrowsePressed() {
    }

    private void updateStatus(int n, String string) {
        this.updateStatus((IStatus)new Status(n, ManagedBuilderCorePlugin.getUniqueIdentifier(), n, string, null));
    }

    protected void updateStatus(IStatus iStatus) {
        super.updateStatus(iStatus);
    }

    protected void validateLocation() {
        this.folderName = this.text.getText();
        if (this.folderName == null || this.folderName.equals("")) {
            this.updateStatus(4, IDEWorkbenchMessages.getString((String)EMPTY));
            return;
        }
        Path path = new Path(this.folderName);
        if (!path.isValidPath(this.folderName)) {
            this.updateStatus(4, ManagedBuilderUIMessages.getResourceString(ERROR_FOLDER_NAME_INVALID));
            return;
        }
        this.updateStatus(0, "");
        this.getButton(0).setEnabled(true);
    }
}

