/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ToolReference;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildSettingsPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolsSettingsStore;
import org.eclipse.cdt.managedbuilder.ui.properties.MultiLineTextFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.graphics.Point;

public class BuildToolSettingsPage
extends BuildSettingsPage {
    private static final String ALL_OPTIONS = ManagedBuilderUIMessages.getResourceString("BuildToolSettingsPage.alloptions");
    private static final String COMMAND = "FieldEditors.tool.command";
    private static final String DEFAULT_SEPERATOR = ";";
    private static final String WHITESPACE = " ";
    private MultiLineTextFieldEditor allOptionFieldEditor;
    private String allOptionsId = "";
    private Vector defaultOptionNames;
    private HashMap stringOptionsMap;
    private ITool tool;
    private HashMap userObjsMap;

    BuildToolSettingsPage(IConfiguration iConfiguration, ITool iTool) {
        super(iConfiguration);
        this.tool = iTool;
        this.allOptionsId = String.valueOf(iTool.getId()) + ".allOptions";
        this.stringOptionsMap = new HashMap();
        this.userObjsMap = new HashMap();
    }

    public Point computeSize() {
        return super.computeSize();
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        StringFieldEditor stringFieldEditor = new StringFieldEditor(this.tool.getId(), ManagedBuilderUIMessages.getResourceString(COMMAND), this.getFieldEditorParent());
        stringFieldEditor.setEmptyStringAllowed(false);
        this.addField((FieldEditor)stringFieldEditor);
        this.allOptionFieldEditor = new MultiLineTextFieldEditor(this.allOptionsId, ALL_OPTIONS, this.getFieldEditorParent());
        this.getPreferenceStore().setValue(this.allOptionsId, "");
        this.addField(this.allOptionFieldEditor);
        this.allOptionFieldEditor.getTextControl().setEditable(false);
    }

    private String createList(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n < stringArray.length - 1) {
                stringBuffer.append(DEFAULT_SEPERATOR);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private Vector getDefaultOptionNames() {
        if (this.defaultOptionNames == null) {
            this.defaultOptionNames = new Vector();
            this.defaultOptionNames.add("Other flags");
            this.defaultOptionNames.add("Linker flags");
            this.defaultOptionNames.add("Archiver flags");
            this.defaultOptionNames.add("Assembler flags");
        }
        return this.defaultOptionNames;
    }

    private Vector getOptionVector(String string) {
        Vector<String> vector = new Vector<String>(Arrays.asList(string.split("\\s")));
        Vector<String> vector2 = new Vector<String>(vector.size());
        Iterator<String> iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            int n = string2.indexOf("\"");
            int n2 = string2.lastIndexOf("\"");
            if (n != -1 && n == n2) {
                while (iterator.hasNext()) {
                    String string3 = iterator.next();
                    string2 = String.valueOf(string2) + WHITESPACE + string3;
                    if (string3.indexOf("\"") != -1) break;
                }
            }
            vector2.add(string2);
        }
        return vector2;
    }

    private String getToolFlags() throws BuildException {
        ITool[] iToolArray = this.configuration.getTools();
        int n = 0;
        while (n < iToolArray.length) {
            if (iToolArray[n] instanceof ToolReference) {
                if (((ToolReference)iToolArray[n]).references(this.tool)) {
                    this.tool = iToolArray[n];
                    break;
                }
            } else if (iToolArray[n].equals(this.tool)) break;
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        IOption[] iOptionArray = this.tool.getOptions();
        String string = "";
        String[] stringArray = null;
        int n2 = 0;
        while (n2 < iOptionArray.length) {
            IOption iOption = iOptionArray[n2];
            switch (iOption.getValueType()) {
                case 0: {
                    String string2 = this.getPreferenceStore().getBoolean(iOption.getId()) ? iOption.getCommand() : iOption.getCommandFalse();
                    if (string2 == null || string2.length() <= 0) break;
                    stringBuffer.append(String.valueOf(string2) + WHITESPACE);
                    break;
                }
                case 1: {
                    String string3;
                    String string4 = this.getPreferenceStore().getString(iOption.getId());
                    if (string4.indexOf(DEFAULT_SEPERATOR) != -1) {
                        string4 = iOption.getSelectedEnum();
                    }
                    if ((string3 = iOption.getEnumCommand(string4)).length() <= 0) break;
                    stringBuffer.append(String.valueOf(string3) + WHITESPACE);
                    break;
                }
                case 2: {
                    String string5 = iOption.getCommand();
                    String string6 = this.getPreferenceStore().getString(iOption.getId());
                    this.stringOptionsMap.put(iOption, string6);
                    if (string6.length() <= 0) break;
                    if (string5 != null) {
                        stringBuffer.append(string5);
                    }
                    stringBuffer.append(String.valueOf(string6) + WHITESPACE);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    String string7 = iOption.getCommand();
                    string = this.getPreferenceStore().getString(iOption.getId());
                    if (string7 == null) {
                        this.userObjsMap.put(iOption, string);
                    }
                    stringArray = BuildToolsSettingsStore.parseString(string);
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        String string8 = stringArray[n3];
                        if (string7 != null) {
                            stringBuffer.append(String.valueOf(string7) + string8 + WHITESPACE);
                        } else {
                            stringBuffer.append(String.valueOf(string8) + WHITESPACE);
                        }
                        ++n3;
                    }
                    break;
                }
            }
            ++n2;
        }
        return stringBuffer.toString().trim();
    }

    public boolean isForTool(ITool iTool) {
        if (iTool != null) {
            return iTool.equals(this.tool);
        }
        return false;
    }

    public void parseAllOptions() {
        Object object;
        Object object2;
        Object object3;
        ArrayList arrayList;
        Object object4;
        Object object5;
        int n;
        Object object6;
        if (!this.allOptionFieldEditor.getTextControl().getEditable()) {
            return;
        }
        ITool[] iToolArray = this.configuration.getTools();
        int n2 = 0;
        while (n2 < iToolArray.length) {
            if (iToolArray[n2] instanceof ToolReference) {
                if (((ToolReference)iToolArray[n2]).references(this.tool)) {
                    this.tool = iToolArray[n2];
                    break;
                }
            } else if (iToolArray[n2].equals(this.tool)) break;
            ++n2;
        }
        String string = this.getPreferenceStore().getString(this.allOptionsId);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = this.getOptionVector(string);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            object6 = (String)iterator.next();
            n = 0;
            object5 = this.tool.getOptions();
            int n3 = 0;
            while (n3 < ((IOption[])object5).length) {
                object4 = object5[n3];
                object4.getId();
                arrayList = this.stringOptionsMap.values().iterator();
                while (arrayList.hasNext()) {
                    if (((String)arrayList.next()).indexOf((String)object6) == -1) continue;
                    n = 1;
                }
                object3 = this.userObjsMap.values().iterator();
                while (object3.hasNext()) {
                    if (((String)object3.next()).indexOf((String)object6) == -1) continue;
                    n = 1;
                }
                if (n == 0) {
                    switch (object4.getValueType()) {
                        case 0: {
                            String string2 = object4.getCommand();
                            if (string2 != null && string2.equals(object6)) {
                                this.getPreferenceStore().setValue(object4.getId(), true);
                                n = 1;
                            }
                            if ((string2 = object4.getCommandFalse()) == null || !string2.equals(object6)) break;
                            this.getPreferenceStore().setValue(object4.getId(), false);
                            n = 1;
                            break;
                        }
                        case 1: {
                            object2 = "";
                            object = object4.getApplicableValues();
                            int n4 = 0;
                            while (n4 < ((String[])object).length) {
                                if (object4.getEnumCommand(object[n4]).equals(object6)) {
                                    object2 = object[n4];
                                    n = 1;
                                }
                                ++n4;
                            }
                            if (object2.equals("")) break;
                            this.getPreferenceStore().setValue(object4.getId(), (String)object2);
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            if (object4.getCommand() == null || !((String)object6).startsWith(object4.getCommand())) break;
                            arrayList2.add(object6);
                            n = 1;
                            break;
                        }
                    }
                }
                ++n3;
            }
            if (n != 0) continue;
            stringBuffer.append(String.valueOf(object6) + WHITESPACE);
        }
        object6 = this.stringOptionsMap.keySet();
        n = 0;
        while (n < object6.size()) {
            object5 = object6.iterator();
            while (object5.hasNext()) {
                Object e = object5.next();
                object4 = (String)this.stringOptionsMap.get(e);
                if (string.indexOf((String)object4) != -1) continue;
                arrayList = new StringBuffer();
                object3 = ((String)object4).split(WHITESPACE);
                int n5 = 0;
                while (n5 < ((Object)object3).length) {
                    if (string.indexOf((String)object3[n5]) != -1) {
                        ((StringBuffer)((Object)arrayList)).append(String.valueOf(object3[n5]) + WHITESPACE);
                    }
                    ++n5;
                }
                this.getPreferenceStore().setValue(((IOption)e).getId(), ((StringBuffer)((Object)arrayList)).toString().trim());
            }
            ++n;
        }
        Set set = this.userObjsMap.keySet();
        int n6 = 0;
        while (n6 < set.size()) {
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                object4 = iterator2.next();
                arrayList = (String)this.userObjsMap.get(object4);
                object3 = new ArrayList();
                String[] stringArray = BuildToolsSettingsStore.parseString((String)((Object)arrayList));
                int n7 = 0;
                while (n7 < stringArray.length) {
                    if (string.indexOf(stringArray[n7]) != -1) {
                        ((ArrayList)object3).add(stringArray[n7]);
                    }
                    ++n7;
                }
                object2 = new String[((ArrayList)object3).size()];
                ((ArrayList)object3).toArray((T[])object2);
                object = BuildToolsSettingsStore.createList(object2);
                this.getPreferenceStore().setValue(((IOption)object4).getId(), (String)object);
            }
            ++n6;
        }
        IOption[] iOptionArray = this.tool.getOptions();
        int n8 = 0;
        while (n8 < iOptionArray.length) {
            object4 = iOptionArray[n8];
            object4.getId();
            switch (object4.getValueType()) {
                case 0: {
                    arrayList = new ArrayList(vector);
                    if (object4.getCommand() != null && object4.getCommand().length() > 0 && !arrayList.contains(object4.getCommand())) {
                        this.getPreferenceStore().setValue(object4.getId(), false);
                    }
                    if (object4.getCommandFalse() == null || object4.getCommandFalse().length() <= 0 || arrayList.contains(object4.getCommandFalse())) break;
                    this.getPreferenceStore().setValue(object4.getId(), true);
                    break;
                }
                case 2: {
                    if (!this.getDefaultOptionNames().contains(object4.getName())) break;
                    object3 = this.getPreferenceStore().getString(object4.getId());
                    if (stringBuffer.length() > 0) {
                        object3 = String.valueOf(object3) + WHITESPACE + stringBuffer.toString().trim();
                    }
                    this.getPreferenceStore().setValue(object4.getId(), (String)object3);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    object3 = new ArrayList();
                    int n9 = 0;
                    while (n9 < arrayList2.size()) {
                        if (object4.getCommand() != null && ((String)arrayList2.get(n9)).startsWith(object4.getCommand())) {
                            ((ArrayList)object3).add(((String)arrayList2.get(n9)).substring(object4.getCommand().length()));
                        }
                        ++n9;
                    }
                    String[] stringArray = new String[((ArrayList)object3).size()];
                    ((ArrayList)object3).toArray(stringArray);
                    ((ArrayList)object3).clear();
                    this.getPreferenceStore().setValue(object4.getId(), BuildToolsSettingsStore.createList(stringArray));
                    break;
                }
            }
            ++n8;
        }
    }

    public boolean performOk() {
        boolean bl = super.performOk();
        this.parseAllOptions();
        ITool[] iToolArray = this.configuration.getTools();
        int n = 0;
        while (n < iToolArray.length) {
            if (iToolArray[n] instanceof ToolReference) {
                if (((ToolReference)iToolArray[n]).references(this.tool)) {
                    this.tool = iToolArray[n];
                    break;
                }
            } else if (iToolArray[n].equals(this.tool)) break;
            ++n;
        }
        IOption[] iOptionArray = this.tool.getOptions();
        int n2 = 0;
        while (n2 < iOptionArray.length) {
            IOption iOption = iOptionArray[n2];
            switch (iOption.getValueType()) {
                case 0: {
                    boolean bl2 = this.getPreferenceStore().getBoolean(iOption.getId());
                    ManagedBuildManager.setOption((IConfiguration)this.configuration, (IOption)iOption, (boolean)bl2);
                    break;
                }
                case 1: {
                    String string = this.getPreferenceStore().getString(iOption.getId());
                    String string2 = iOption.getEnumeratedId(string);
                    ManagedBuildManager.setOption((IConfiguration)this.configuration, (IOption)iOption, (String)(string2 != null && string2.length() > 0 ? string2 : string));
                    break;
                }
                case 2: {
                    String string = this.getPreferenceStore().getString(iOption.getId());
                    ManagedBuildManager.setOption((IConfiguration)this.configuration, (IOption)iOption, (String)string);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    String string = this.getPreferenceStore().getString(iOption.getId());
                    String[] stringArray = BuildToolsSettingsStore.parseString(string);
                    ManagedBuildManager.setOption((IConfiguration)this.configuration, (IOption)iOption, (String[])stringArray);
                    break;
                }
            }
            ++n2;
        }
        String string = this.getPreferenceStore().getString(this.tool.getId());
        if (string.length() == 0) {
            return bl;
        }
        ManagedBuildManager.setToolCommand((IConfiguration)this.configuration, (ITool)this.tool, (String)string);
        return bl;
    }

    public void storeSettings() {
        super.performOk();
    }

    public void updateAllOptionField() {
        try {
            if (this.getToolFlags() != null) {
                this.getPreferenceStore().setValue(this.allOptionsId, this.getToolFlags());
                this.allOptionFieldEditor.load();
            }
        }
        catch (BuildException buildException) {}
    }
}

