/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIImages;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class FileListControl {
    private ToolBar toolBar;
    private ToolItem titleItem;
    private ToolItem addItem;
    private ToolItem deleteItem;
    private ToolItem editItem;
    private ToolItem moveUpItem;
    private ToolItem moveDownItem;
    private Label title;
    private Image addImage;
    private Image deleteImage;
    private Image editImage;
    private Image moveUpImage;
    private Image moveDownImage;
    private Composite composite;
    private List list;
    private String compTitle;
    private SelectionListener selectionListener;
    private GridData tgdata;
    private GridData grid3;
    private GridData grid4;
    private GridData grid2;
    private int browseType;
    private IPath path;
    private static final String ADD_STR = ManagedBuilderUIMessages.getResourceString("FileListControl.add");
    private static final String DEL_STR = ManagedBuilderUIMessages.getResourceString("FileListControl.delete");
    private static final String EDIT_STR = ManagedBuilderUIMessages.getResourceString("FileListControl.edit");
    private static final String MOVEUP_STR = ManagedBuilderUIMessages.getResourceString("FileListControl.moveup");
    private static final String MOVEDOWN_STR = ManagedBuilderUIMessages.getResourceString("FileListControl.movedown");
    private static final String FILE_TITLE = ManagedBuilderUIMessages.getResourceString("BrowseEntryDialog.title.file");
    private static final String DIR_TITLE = ManagedBuilderUIMessages.getResourceString("BrowseEntryDialog.title.directory");
    private static final String FILE_MSG = ManagedBuilderUIMessages.getResourceString("BrowseEntryDialog.message.file");
    private static final String DIR_MSG = ManagedBuilderUIMessages.getResourceString("BrowseEntryDialog.message.directory");
    private static final String TITLE = ManagedBuilderUIMessages.getResourceString("BuildPropertyCommon.label.title");
    private final Image IMG_ADD = ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_FILELIST_ADD);
    private final Image IMG_DEL = ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_FILELIST_DEL);
    private final Image IMG_EDIT = ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_FILELIST_EDIT);
    private final Image IMG_MOVEUP = ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_FILELIST_MOVEUP);
    private final Image IMG_MOVEDOWN = ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_FILELIST_MOVEDOWN);

    public FileListControl(Composite composite, String string, int n) {
        this.browseType = n;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        Composite composite3 = new Composite(composite2, 2048);
        GridLayout gridLayout2 = new GridLayout(2, false);
        gridLayout2.horizontalSpacing = 0;
        gridLayout2.verticalSpacing = 0;
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout2);
        this.tgdata = new GridData(768);
        this.tgdata.heightHint = 25;
        composite3.setLayoutData((Object)this.tgdata);
        this.title = new Label(composite3, 1);
        this.compTitle = "  " + string;
        this.title.setText(this.compTitle);
        this.grid2 = new GridData(768);
        this.title.setLayoutData((Object)this.grid2);
        Composite composite4 = new Composite(composite3, 0);
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.numColumns = 5;
        gridLayout3.horizontalSpacing = 0;
        gridLayout3.verticalSpacing = 0;
        gridLayout3.marginWidth = 0;
        gridLayout3.marginHeight = 0;
        composite4.setLayout((Layout)gridLayout3);
        this.toolBar = new ToolBar(composite4, 8519936);
        this.addItem = new ToolItem(this.toolBar, 8);
        this.addItem.setImage(this.IMG_ADD);
        this.addItem.setToolTipText(ADD_STR);
        this.addItem.addSelectionListener(this.getSelectionListener());
        this.deleteItem = new ToolItem(this.toolBar, 8);
        this.deleteItem.setImage(this.IMG_DEL);
        this.deleteItem.setToolTipText(DEL_STR);
        this.deleteItem.addSelectionListener(this.getSelectionListener());
        this.editItem = new ToolItem(this.toolBar, 8);
        this.editItem.setImage(this.IMG_EDIT);
        this.editItem.setToolTipText(EDIT_STR);
        this.editItem.addSelectionListener(this.getSelectionListener());
        this.moveUpItem = new ToolItem(this.toolBar, 8);
        this.moveUpItem.setImage(this.IMG_MOVEUP);
        this.moveUpItem.setToolTipText(MOVEUP_STR);
        this.moveUpItem.addSelectionListener(this.getSelectionListener());
        this.moveDownItem = new ToolItem(this.toolBar, 8);
        this.moveDownItem.setImage(this.IMG_MOVEDOWN);
        this.moveDownItem.setToolTipText(MOVEDOWN_STR);
        this.moveDownItem.addSelectionListener(this.getSelectionListener());
        this.grid3 = new GridData(896);
        composite4.setLayoutData((Object)this.grid3);
        this.list = new List(composite2, 2816);
        this.grid4 = new GridData(1808);
        Point point = composite3.computeSize(-1, -1);
        this.grid4.widthHint = point.x;
        this.grid4.heightHint = point.y * 3;
        this.grid4.horizontalSpan = 2;
        this.list.setLayoutData((Object)this.grid4);
        this.list.addSelectionListener(this.getSelectionListener());
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                FileListControl.this.editSelection();
            }
        });
        this.list.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 127) {
                    FileListControl.this.removePressed();
                } else {
                    super.keyPressed(keyEvent);
                }
            }
        });
        this.selectionChanged();
    }

    public void setList(String[] stringArray) {
        if (this.list != null) {
            this.list.removeAll();
        }
        int n = 0;
        while (n < stringArray.length) {
            this.list.add(stringArray[n]);
            ++n;
        }
    }

    public void setSelection(int n) {
        if (this.list.getItemCount() > 0) {
            this.list.setSelection(n);
        }
        this.selectionChanged();
    }

    public void setSelection() {
        if (this.list.getItemCount() > 0) {
            this.list.setSelection(0);
        }
    }

    public void removeAll() {
        if (this.list != null) {
            this.list.removeAll();
        }
    }

    public String[] getItems() {
        return this.list.getItems();
    }

    private void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Widget widget = selectionEvent.widget;
                if (widget == FileListControl.this.addItem) {
                    FileListControl.this.addPressed();
                } else if (widget == FileListControl.this.deleteItem) {
                    FileListControl.this.removePressed();
                } else if (widget == FileListControl.this.moveUpItem) {
                    FileListControl.this.upPressed();
                } else if (widget == FileListControl.this.moveDownItem) {
                    FileListControl.this.downPressed();
                } else if (widget == FileListControl.this.list) {
                    FileListControl.this.selectionChanged();
                } else if (widget == FileListControl.this.editItem) {
                    FileListControl.this.editSelection();
                }
            }
        };
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    private void addPressed() {
        String string = this.getNewInputObject();
        if (string != null && string.length() > 0) {
            int n = this.list.getSelectionIndex();
            if (n >= 0) {
                this.list.add(string, n + 1);
                this.list.setSelection(n + 1);
            } else {
                this.list.add(string, 0);
                this.list.setSelection(0);
            }
        }
        this.selectionChanged();
    }

    private void removePressed() {
        int n = this.list.getSelectionIndex();
        if (this.browseType == 2 || this.browseType == 1) {
            String string = ManagedBuilderUIMessages.getResourceString("FileListControl.deletedialog.message");
            String string2 = ManagedBuilderUIMessages.getResourceString("FileListControl.deletedialog.title");
            boolean bl = MessageDialog.openQuestion((Shell)this.list.getShell(), (String)string2, (String)string);
            if (bl && n != -1) {
                this.list.remove(n);
            }
        } else if (n != -1) {
            this.list.remove(n);
        }
        this.selectionChanged();
    }

    private void upPressed() {
        int n = this.list.getSelectionIndex();
        String string = this.list.getItem(n);
        String string2 = this.list.getItem(n - 1);
        this.list.setItem(n - 1, string);
        this.list.setItem(n, string2);
        this.list.setSelection(n - 1);
        this.selectionChanged();
    }

    private void downPressed() {
        int n = this.list.getSelectionIndex();
        String string = this.list.getItem(n);
        String string2 = this.list.getItem(n + 1);
        this.list.setItem(n + 1, string);
        this.list.setItem(n, string2);
        this.list.setSelection(n + 1);
        this.selectionChanged();
    }

    private void editSelection() {
        int n = this.list.getSelectionIndex();
        if (n != -1) {
            String string = this.list.getItem(n);
            String string2 = ManagedBuilderUIMessages.getResourceString("FileListControl.editdialog.title");
            if (string != null) {
                InputDialog inputDialog = new InputDialog(null, string2, this.compTitle, string, null);
                String string3 = null;
                if (inputDialog.open() == 0 && (string3 = inputDialog.getValue()) != null && !string3.equals(string)) {
                    this.list.setItem(n, string3);
                    this.selectionChanged();
                }
            }
        }
    }

    public void selectionChanged() {
        int n = this.list.getSelectionIndex();
        int n2 = this.list.getItemCount();
        this.deleteItem.setEnabled(n2 > 0);
        this.moveUpItem.setEnabled(n2 > 1 && n > 0);
        this.moveDownItem.setEnabled(n2 > 1 && n >= 0 && n < n2 - 1);
        this.editItem.setEnabled(n2 > 0);
    }

    public List getListControl() {
        return this.list;
    }

    public void setPath(IPath iPath) {
        this.path = iPath;
    }

    public void setType(int n) {
        this.browseType = n;
    }

    private String getNewInputObject() {
        String string = null;
        String string2 = new String();
        String string3 = new String();
        String string4 = new String();
        if (this.browseType == 2) {
            string2 = DIR_TITLE;
            string3 = DIR_MSG;
            string4 = this.path == null ? string4 : this.path.toString();
        } else if (this.browseType == 1) {
            string2 = FILE_TITLE;
            string3 = FILE_MSG;
            string4 = this.path == null ? string4 : this.path.toString();
        } else {
            string2 = TITLE;
            string3 = this.compTitle;
        }
        SelectPathInputDialog selectPathInputDialog = new SelectPathInputDialog(this.getListControl().getShell(), string2, string3, string4, null, this.browseType);
        if (selectPathInputDialog.open() == 0) {
            string = selectPathInputDialog.getValue();
        }
        if (string != null && string.length() > 0 && (this.browseType == 2 || this.browseType == 1)) {
            int n = string.indexOf(" ");
            int n2 = string.indexOf("\\");
            if (n != -1 || n2 != -1) {
                string = "\"" + string + "\"";
            }
        }
        return string;
    }

    class SelectPathInputDialog
    extends InputDialog {
        private static final String BROWSE = "BuildPropertyCommon.label.browse";
        private int type;

        public SelectPathInputDialog(Shell shell, String string, String string2, String string3, IInputValidator iInputValidator, int n) {
            super(shell, string, string2, string3, iInputValidator);
            this.type = n;
        }

        protected void createButtonsForButtonBar(Composite composite) {
            super.createButtonsForButtonBar(composite);
            if (this.type != 0) {
                Button button = this.createButton(composite, 3, ManagedBuilderUIMessages.getResourceString(BROWSE), false);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ SelectPathInputDialog this$1;
                    {
                        this.this$1 = selectPathInputDialog;
                    }

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        switch (SelectPathInputDialog.access$0(this.this$1)) {
                            case 2: {
                                String string;
                                DirectoryDialog directoryDialog = new DirectoryDialog(SelectPathInputDialog.access$1(this.this$1), 4096);
                                String string2 = SelectPathInputDialog.access$2(this.this$1).getText();
                                if (string2 != null && string2.trim().length() != 0) {
                                    directoryDialog.setFilterPath(string2);
                                }
                                if ((string = directoryDialog.open()) == null) break;
                                SelectPathInputDialog.access$2(this.this$1).setText(string);
                                break;
                            }
                            case 1: {
                                String string;
                                FileDialog fileDialog = new FileDialog(SelectPathInputDialog.access$1(this.this$1));
                                String string3 = SelectPathInputDialog.access$2(this.this$1).getText();
                                if (string3 != null && string3.trim().length() != 0) {
                                    fileDialog.setFilterPath(string3);
                                }
                                if ((string = fileDialog.open()) == null) break;
                                SelectPathInputDialog.access$2(this.this$1).setText(string);
                            }
                        }
                    }
                });
            }
        }

        static /* synthetic */ int access$0(SelectPathInputDialog selectPathInputDialog) {
            return selectPathInputDialog.type;
        }

        static /* synthetic */ Shell access$1(SelectPathInputDialog selectPathInputDialog) {
            return selectPathInputDialog.getParentShell();
        }

        static /* synthetic */ Text access$2(SelectPathInputDialog selectPathInputDialog) {
            return selectPathInputDialog.getText();
        }
    }
}

