/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolsSettingsStore;
import org.eclipse.cdt.managedbuilder.ui.properties.FileListControl;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class FileListControlFieldEditor
extends FieldEditor {
    private FileListControl list;
    private int browseType;
    private GridLayout layout;
    private static final String DEFAULT_SEPERATOR = ";";
    private String[] values = null;

    public FileListControlFieldEditor(String string, String string2, Composite composite, int n) {
        super(string, string2, composite);
        this.browseType = n;
        this.list.setType(n);
    }

    public FileListControlFieldEditor(String string, String string2, Composite composite, String string3, int n) {
        this(string, string2, composite, n);
        this.browseType = n;
        this.values = this.parseString(string3);
    }

    protected void doFillIntoGrid(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        this.layout = new GridLayout();
        this.layout.numColumns = n;
        this.layout.marginWidth = 7;
        this.layout.marginHeight = 5;
        this.layout.makeColumnsEqualWidth = false;
        composite2.setLayout((Layout)this.layout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        this.list = new FileListControl(composite2, this.getLabelText(), this.getType());
        composite2.setLayout((Layout)this.layout);
    }

    private int getType() {
        return this.browseType;
    }

    protected List getListControl() {
        return this.list.getListControl();
    }

    protected void doLoad() {
        IPreferenceStore iPreferenceStore;
        if (this.list != null && (iPreferenceStore = this.getPreferenceStore()) != null) {
            IResource iResource;
            IConfiguration iConfiguration;
            String string = iPreferenceStore.getString(this.getPreferenceName());
            String[] stringArray = this.parseString(string);
            this.list.setList(stringArray);
            this.list.setSelection(0);
            if (iPreferenceStore instanceof BuildToolsSettingsStore && (iConfiguration = ((BuildToolsSettingsStore)iPreferenceStore).getOwner()) != null && (iResource = iConfiguration.getOwner()) != null) {
                this.list.setPath(iResource.getLocation());
            }
        }
        this.list.selectionChanged();
    }

    protected void doLoadDefault() {
        if (this.list != null) {
            this.list.removeAll();
            String string = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            String[] stringArray = this.parseString(string);
            this.list.setList(stringArray);
            this.list.selectionChanged();
        }
    }

    protected void doStore() {
        String string = this.createList(this.list.getItems());
        if (string != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), string);
        }
    }

    public int getNumberOfControls() {
        return 1;
    }

    private String createList(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n < stringArray.length - 1) {
                stringBuffer.append(DEFAULT_SEPERATOR);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private String[] parseString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DEFAULT_SEPERATOR);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (stringTokenizer.hasMoreElements()) {
            arrayList.add(stringTokenizer.nextElement());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void setStyle() {
        this.layout.marginWidth = 0;
    }

    protected void adjustForNumColumns(int n) {
    }
}

