/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.ui.properties.NewConfigurationDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ManageConfigDialog
extends Dialog {
    private static final String CMN_PREFIX = "BuildPropertyCommon";
    private static final String CMN_LABEL = "BuildPropertyCommon.label";
    private static final String NEW = "BuildPropertyCommon.label.new";
    private static final String REMOVE = "BuildPropertyCommon.label.remove";
    private static final String PREFIX = "ManageConfig";
    private static final String LABEL = "ManageConfig.label";
    private static final String RESTORE = "ManageConfig.label.restore";
    private static final String GROUP = "ManageConfig.label.makecmdgroup";
    private static final String DEF_BTN = "ManageConfig.label.makecmddef";
    private static final String OUTPUT_GROUP = "ManageConfig.label.output.group";
    private static final String OUTPUT_EXT = "ManageConfig.label.output.extension";
    private static final String OUTPUT_NAME = "ManageConfig.label.output.name";
    private static final String CONFIGS = "ManageConfig.label.configs";
    private static final String CURRENT_CONFIGS = "ManageConfig.label.configs.current";
    private static final String DELETED_CONFIGS = "ManageConfig.label.configs.deleted";
    private static final String CONF_DLG = "ManageConfig.label.new.config.dialog";
    private String artifactExt;
    private String artifactName;
    private SortedMap deletedConfigs;
    private SortedMap existingConfigs;
    private String makeCommand;
    private ITarget managedTarget;
    private SortedMap newConfigs;
    private String title = "";
    private boolean useDefaultMake;
    protected Text buildArtifactExt;
    protected Text buildArtifactName;
    protected List currentConfigList;
    protected List deletedConfigList;
    protected Button makeCommandDefault;
    protected Text makeCommandEntry;
    protected Button newBtn;
    protected Button okBtn;
    protected Button removeBtn;
    protected Button restoreBtn;

    protected ManageConfigDialog(Shell shell, String string, ITarget iTarget) {
        super(shell);
        this.title = string;
        this.managedTarget = iTarget;
        this.setMakeCommand();
        this.artifactExt = this.managedTarget.getArtifactExtension();
        this.artifactName = this.managedTarget.getArtifactName();
        this.getExistingConfigs().clear();
        IConfiguration[] iConfigurationArray = this.managedTarget.getConfigurations();
        int n = 0;
        while (n < iConfigurationArray.length) {
            IConfiguration iConfiguration = iConfigurationArray[n];
            this.getExistingConfigs().put(iConfiguration.getName(), iConfiguration.getId());
            ++n;
        }
        this.getDeletedConfigs().clear();
        this.getNewConfigs().clear();
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.useDefaultMake = this.makeCommandDefault.getSelection();
            this.makeCommand = this.makeCommandEntry.getText().trim();
            this.artifactName = this.buildArtifactName.getText().trim();
            this.artifactExt = this.buildArtifactExt.getText().trim();
        } else {
            this.useDefaultMake = true;
            this.artifactName = this.managedTarget.getArtifactName();
        }
        super.buttonPressed(n);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    private void createBuildArtifactGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setFont(composite.getFont());
        group.setText(ManagedBuilderUIMessages.getResourceString(OUTPUT_GROUP));
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 16384);
        label.setFont(group.getFont());
        label.setText(ManagedBuilderUIMessages.getResourceString(OUTPUT_NAME));
        label.setLayoutData((Object)new GridData(768));
        Label label2 = new Label((Composite)group, 0x1000000);
        label2.setText(new String());
        label2.setLayoutData((Object)new GridData());
        Label label3 = new Label((Composite)group, 16384);
        label3.setFont(group.getFont());
        label3.setText(ManagedBuilderUIMessages.getResourceString(OUTPUT_EXT));
        label3.setLayoutData((Object)new GridData(768));
        this.buildArtifactName = new Text((Composite)group, 2052);
        this.buildArtifactName.setFont(group.getFont());
        this.buildArtifactName.setText(this.artifactName);
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        this.buildArtifactName.setLayoutData((Object)gridData);
        this.buildArtifactName.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ManageConfigDialog.this.buildArtifactName = null;
            }
        });
        this.buildArtifactName.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = ManagedBuilderUIMessages.getResourceString(ManageConfigDialog.OUTPUT_NAME);
            }
        });
        Label label4 = new Label((Composite)group, 0x1000000);
        label4.setFont(group.getFont());
        label4.setText(new String("."));
        label4.setLayoutData((Object)new GridData());
        this.buildArtifactExt = new Text((Composite)group, 2052);
        this.buildArtifactExt.setFont(group.getFont());
        this.buildArtifactExt.setText(this.artifactExt);
        gridData = new GridData(768);
        gridData.widthHint = 100;
        this.buildArtifactExt.setLayoutData((Object)gridData);
        this.buildArtifactExt.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ManageConfigDialog.this.buildArtifactExt = null;
            }
        });
        this.buildArtifactExt.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = ManagedBuilderUIMessages.getResourceString(ManageConfigDialog.OUTPUT_EXT);
            }
        });
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.okBtn = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
    }

    private void createConfigListGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setFont(composite.getFont());
        group.setText(ManagedBuilderUIMessages.getResourceString(CONFIGS));
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(1808));
        Label label = new Label((Composite)group, 16384);
        label.setFont(group.getFont());
        label.setText(ManagedBuilderUIMessages.getResourceString(CURRENT_CONFIGS));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        Label label2 = new Label((Composite)group, 16384);
        label2.setFont(group.getFont());
        label2.setText(ManagedBuilderUIMessages.getResourceString(DELETED_CONFIGS));
        label2.setLayoutData((Object)new GridData());
        this.currentConfigList = new List((Composite)group, 2820);
        this.currentConfigList.setFont(group.getFont());
        gridData = new GridData(1808);
        gridData.widthHint = 100;
        this.currentConfigList.setLayoutData((Object)gridData);
        this.currentConfigList.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ManageConfigDialog.this.currentConfigList = null;
            }
        });
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setFont(group.getFont());
        composite2.setLayout((Layout)new GridLayout(1, true));
        composite2.setLayoutData((Object)new GridData(1040));
        this.newBtn = new Button(composite2, 8);
        this.newBtn.setFont(composite2.getFont());
        this.newBtn.setText(ManagedBuilderUIMessages.getResourceString(NEW));
        this.setButtonLayoutData(this.newBtn);
        this.newBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManageConfigDialog.this.handleNewPressed();
            }
        });
        this.newBtn.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ManageConfigDialog.this.newBtn = null;
            }
        });
        this.removeBtn = new Button(composite2, 8);
        this.removeBtn.setFont(composite2.getFont());
        this.removeBtn.setText(ManagedBuilderUIMessages.getResourceString(REMOVE));
        this.setButtonLayoutData(this.removeBtn);
        this.removeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManageConfigDialog.this.handleRemovePressed();
            }
        });
        this.removeBtn.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ManageConfigDialog.this.removeBtn = null;
            }
        });
        this.restoreBtn = new Button(composite2, 8);
        this.restoreBtn.setFont(composite2.getFont());
        this.restoreBtn.setText(ManagedBuilderUIMessages.getResourceString(RESTORE));
        this.setButtonLayoutData(this.restoreBtn);
        this.restoreBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManageConfigDialog.this.handleRestorePressed();
            }
        });
        this.restoreBtn.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ManageConfigDialog.this.restoreBtn = null;
            }
        });
        this.deletedConfigList = new List((Composite)group, 2820);
        this.deletedConfigList.setFont(group.getFont());
        gridData = new GridData(1808);
        gridData.widthHint = 100;
        this.deletedConfigList.setLayoutData((Object)gridData);
        this.deletedConfigList.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ManageConfigDialog.this.deletedConfigList = null;
            }
        });
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayout((Layout)new GridLayout(1, true));
        composite2.setLayoutData((Object)new GridData(1808));
        this.createBuildArtifactGroup(composite2);
        this.createMakeCommandGroup(composite2);
        this.createConfigListGroup(composite2);
        this.currentConfigList.setItems(this.getConfigurationNames());
        this.currentConfigList.select(0);
        this.newBtn.setFocus();
        return composite2;
    }

    private void createMakeCommandGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setFont(composite.getFont());
        group.setText(ManagedBuilderUIMessages.getResourceString(GROUP));
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)new GridData(768));
        this.makeCommandDefault = new Button((Composite)group, 16416);
        this.makeCommandDefault.setFont(group.getFont());
        this.makeCommandDefault.setText(ManagedBuilderUIMessages.getResourceString(DEF_BTN));
        this.setButtonLayoutData(this.makeCommandDefault);
        this.makeCommandDefault.setBackground(group.getBackground());
        this.makeCommandDefault.setForeground(group.getForeground());
        this.makeCommandDefault.setSelection(!this.managedTarget.hasOverridenMakeCommand());
        this.makeCommandDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ManageConfigDialog.this.handleUseDefaultPressed();
            }
        });
        this.makeCommandDefault.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ManageConfigDialog.this.makeCommandDefault = null;
            }
        });
        this.makeCommandEntry = new Text((Composite)group, 2052);
        this.makeCommandEntry.setFont(group.getFont());
        this.makeCommandEntry.setEditable(!this.makeCommandDefault.getSelection());
        this.makeCommandEntry.setText(this.makeCommand);
        this.makeCommandEntry.setLayoutData((Object)new GridData(768));
        this.makeCommandEntry.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ManageConfigDialog.this.makeCommandEntry = null;
            }
        });
    }

    public String getBuildArtifaceExtension() {
        return this.artifactExt;
    }

    public String getBuildArtifactName() {
        return this.artifactName;
    }

    private String[] getConfigurationNames() {
        return this.getExistingConfigs().keySet().toArray(new String[this.getExistingConfigs().size()]);
    }

    protected SortedMap getDeletedConfigs() {
        if (this.deletedConfigs == null) {
            this.deletedConfigs = new TreeMap();
        }
        return this.deletedConfigs;
    }

    public ArrayList getDeletedConfigIds() {
        return new ArrayList(this.getDeletedConfigs().values());
    }

    protected SortedMap getExistingConfigs() {
        if (this.existingConfigs == null) {
            this.existingConfigs = new TreeMap();
        }
        return this.existingConfigs;
    }

    public String getMakeCommand() {
        return this.makeCommand;
    }

    public SortedMap getNewConfigs() {
        if (this.newConfigs == null) {
            this.newConfigs = new TreeMap();
        }
        return this.newConfigs;
    }

    private IProject getProject() {
        return this.managedTarget.getOwner().getProject();
    }

    protected void handleNewPressed() {
        Object object;
        ITarget[] iTargetArray = ManagedBuildManager.getDefinedTargets((IProject)this.getProject());
        int n = 0;
        while (n < iTargetArray.length) {
            object = iTargetArray[n];
            if (object.getId().equals(this.managedTarget.getParent().getId())) {
                break;
            }
            ++n;
        }
        NewConfigurationDialog newConfigurationDialog = new NewConfigurationDialog(this.getShell(), this.managedTarget, ManagedBuilderUIMessages.getResourceString(CONF_DLG));
        if (newConfigurationDialog.open() == 0) {
            object = newConfigurationDialog.getNewName();
            this.getNewConfigs().put(object, newConfigurationDialog.getParentConfiguration());
            this.currentConfigList.add((String)object);
            this.currentConfigList.setSelection(this.currentConfigList.getItemCount() - 1);
        }
        this.updateButtons();
    }

    protected void handleRemovePressed() {
        int n = this.currentConfigList.getSelectionIndex();
        if (n != -1) {
            String string = this.currentConfigList.getItem(n);
            String string2 = null;
            if (this.getNewConfigs().containsKey(string)) {
                IConfiguration iConfiguration = (IConfiguration)this.getNewConfigs().get(string);
                string2 = iConfiguration.getId();
                this.getNewConfigs().remove(string);
            } else {
                string2 = (String)this.getExistingConfigs().get(string);
            }
            this.getDeletedConfigs().put(string, string2);
            this.currentConfigList.remove(n);
            this.currentConfigList.setSelection(n - 1);
            this.deletedConfigList.add(string);
            this.deletedConfigList.setSelection(this.deletedConfigList.getItemCount() - 1);
            this.updateButtons();
        }
    }

    protected void handleRestorePressed() {
        int n = this.deletedConfigList.getSelectionIndex();
        if (n != -1) {
            String string = this.deletedConfigList.getItem(n);
            String string2 = (String)this.getDeletedConfigs().get(string);
            if (!this.getExistingConfigs().containsKey(string)) {
                IConfiguration iConfiguration = this.managedTarget.getConfiguration(string2);
                this.getNewConfigs().put(string, iConfiguration);
            }
            this.getDeletedConfigs().remove(string);
            this.deletedConfigList.remove(n);
            this.deletedConfigList.setSelection(n - 1);
            this.currentConfigList.add(string);
            this.currentConfigList.setSelection(this.currentConfigList.getItemCount());
            this.updateButtons();
        }
    }

    protected void handleUseDefaultPressed() {
        boolean bl = this.makeCommandDefault.getSelection();
        if (bl) {
            this.managedTarget.resetMakeCommand();
            this.setMakeCommand();
            this.makeCommandEntry.setText(this.makeCommand);
            this.makeCommandEntry.setEditable(false);
        } else {
            this.makeCommandEntry.setEditable(true);
        }
    }

    private void setMakeCommand() {
        this.makeCommand = this.managedTarget.getMakeCommand();
        String string = this.managedTarget.getMakeArguments();
        if (string.length() > 0) {
            this.makeCommand = String.valueOf(this.makeCommand) + " " + string;
        }
    }

    private void updateButtons() {
        this.removeBtn.setEnabled(this.currentConfigList.getItemCount() > 1);
        this.restoreBtn.setEnabled(this.deletedConfigList.getItemCount() > 0);
    }

    public boolean useDefaultMakeCommand() {
        return this.useDefaultMake;
    }
}

