/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.ErrorParserBlock;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedProjectOptionBlock;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.PropertyPage;

public class ManagedBuilderPropertyPage
extends PropertyPage
implements ICOptionContainer {
    protected ManagedProjectOptionBlock fOptionBlock;
    protected ITarget displayedTarget;
    private static final String MSG_CLOSEDPROJECT = "MngMakeProjectPropertyPage.closedproject";

    public void setContainer(IPreferencePageContainer iPreferencePageContainer) {
        super.setContainer(iPreferencePageContainer);
        if (this.fOptionBlock == null) {
            this.fOptionBlock = new ManagedProjectOptionBlock(this);
        }
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FillLayout());
        IProject iProject = this.getProject();
        if (!iProject.isOpen()) {
            this.contentForClosedProject(composite2);
        } else {
            this.contentForCProject(composite2);
        }
        return composite2;
    }

    private void contentForCProject(Composite composite) {
        this.fOptionBlock.createContents(composite);
    }

    private void contentForClosedProject(Composite composite) {
        Label label = new Label(composite, 16384);
        label.setText(ManagedBuilderUIMessages.getResourceString(MSG_CLOSEDPROJECT));
        label.setFont(composite.getFont());
        this.noDefaultAndApplyButton();
    }

    public boolean performOk() {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                ManagedBuilderPropertyPage.this.fOptionBlock.performApply(iProgressMonitor);
            }
        };
        ITarget iTarget = this.getSelectedTarget();
        if (iTarget != this.displayedTarget) {
            return true;
        }
        WorkspaceModifyDelegatingOperation workspaceModifyDelegatingOperation = new WorkspaceModifyDelegatingOperation(iRunnableWithProgress);
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, true, (IRunnableWithProgress)workspaceModifyDelegatingOperation);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            ManagedBuilderUIPlugin.errorDialog(this.getShell(), ManagedBuilderUIMessages.getResourceString("ManagedProjectPropertyPage.internalError"), throwable.toString(), throwable);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        IProject iProject = this.getProject();
        ManagedBuildManager.saveBuildInfo((IProject)iProject, (boolean)false);
        return true;
    }

    public IProject getProject() {
        IAdaptable iAdaptable = this.getElement();
        if (iAdaptable instanceof IProject) {
            return (IProject)iAdaptable;
        }
        return null;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.fOptionBlock.setVisible(bl);
        if (bl) {
            ErrorParserBlock errorParserBlock = this.fOptionBlock.getErrorParserBlock();
            errorParserBlock.updateValues();
            this.displayedTarget = this.getSelectedTarget();
        }
    }

    protected ITarget getSelectedTarget() {
        IProject iProject = this.getProject();
        ITarget iTarget = ManagedBuildManager.getSelectedTarget((IProject)iProject);
        if (iTarget == null) {
            IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
            iTarget = iManagedBuildInfo.getDefaultTarget();
            ManagedBuildManager.setSelectedTarget((IProject)iProject, (ITarget)iTarget);
        }
        return iTarget;
    }

    public void updateContainer() {
        this.fOptionBlock.update();
        this.setValid(this.fOptionBlock.isValid());
        this.setErrorMessage(this.fOptionBlock.getErrorMessage());
    }

    protected void performDefaults() {
        this.fOptionBlock.performDefaults();
        super.performDefaults();
    }

    public boolean isValid() {
        this.updateContainer();
        return super.isValid();
    }

    public Preferences getPreferences() {
        return null;
    }
}

