/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class MultiLineTextFieldEditor
extends FieldEditor {
    private static final String ERROR_MESSAGE = "Multiline.error.message";
    public static final int VALIDATE_ON_KEY_STROKE = 0;
    public static final int VALIDATE_ON_FOCUS_LOST = 1;
    public static int UNLIMITED = -1;
    private boolean isValid;
    private String oldValue;
    private String compTitle;
    private Label title;
    private Text textField;
    private int widthInChars = UNLIMITED;
    private int textLimit = UNLIMITED;
    private String errorMessage;
    private boolean emptyStringAllowed = true;
    private int validateStrategy = 0;

    protected MultiLineTextFieldEditor() {
    }

    public MultiLineTextFieldEditor(String string, String string2, int n, int n2, Composite composite) {
        this.init(string, string2);
        this.widthInChars = n;
        this.setValidateStrategy(n2);
        this.isValid = false;
        this.errorMessage = ManagedBuilderUIMessages.getResourceString(ERROR_MESSAGE);
        this.createControl(composite);
    }

    public MultiLineTextFieldEditor(String string, String string2, int n, Composite composite) {
        this(string, string2, n, 0, composite);
        this.compTitle = string2;
    }

    public MultiLineTextFieldEditor(String string, String string2, Composite composite) {
        this(string, string2, UNLIMITED, composite);
    }

    protected void adjustForNumColumns(int n) {
        GridData gridData = (GridData)this.textField.getLayoutData();
        gridData.horizontalSpan = n - 1;
        gridData.grabExcessHorizontalSpace = gridData.horizontalSpan == 1;
    }

    protected boolean checkState() {
        String string;
        boolean bl = false;
        if (this.emptyStringAllowed) {
            bl = true;
        }
        if (this.textField == null) {
            bl = false;
        }
        if ((string = this.textField.getText()) == null) {
            bl = false;
        }
        bl = string.trim().length() > 0 || this.emptyStringAllowed;
        boolean bl2 = bl = bl && this.doCheckState();
        if (bl) {
            this.clearErrorMessage();
        } else {
            this.showErrorMessage(this.errorMessage);
        }
        return bl;
    }

    protected boolean doCheckState() {
        return true;
    }

    protected void doFillIntoGrid(Composite composite, int n) {
        this.title = new Label(composite, 128);
        this.title.setFont(composite.getFont());
        this.compTitle = this.getLabelText();
        this.title.setText(this.compTitle);
        this.title.setLayoutData((Object)new GridData(2));
        this.textField = this.getTextControl(composite);
        GridData gridData = new GridData(768);
        gridData.widthHint = 100;
        gridData.heightHint = 70;
        this.textField.setLayoutData((Object)gridData);
    }

    protected void doLoad() {
        if (this.textField != null) {
            String string = this.getPreferenceStore().getString(this.getPreferenceName());
            this.textField.setText(string);
            this.oldValue = string;
        }
    }

    protected void doLoadDefault() {
        if (this.textField != null) {
            String string = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.textField.setText(string);
        }
        this.valueChanged();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.textField.getText());
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getNumberOfControls() {
        return 2;
    }

    public String getStringValue() {
        if (this.textField != null) {
            return this.textField.getText();
        }
        return this.getPreferenceStore().getString(this.getPreferenceName());
    }

    protected Text getTextControl() {
        return this.textField;
    }

    public Text getTextControl(Composite composite) {
        if (this.textField == null) {
            this.textField = new Text(composite, 2626);
            this.textField.setFont(composite.getFont());
            switch (this.validateStrategy) {
                case 0: {
                    this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent keyEvent) {
                            MultiLineTextFieldEditor.this.valueChanged();
                        }
                    });
                    this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent focusEvent) {
                            MultiLineTextFieldEditor.this.refreshValidState();
                        }

                        public void focusLost(FocusEvent focusEvent) {
                            MultiLineTextFieldEditor.this.clearErrorMessage();
                        }
                    });
                    break;
                }
                case 1: {
                    this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent keyEvent) {
                            MultiLineTextFieldEditor.this.clearErrorMessage();
                        }
                    });
                    this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent focusEvent) {
                            MultiLineTextFieldEditor.this.refreshValidState();
                        }

                        public void focusLost(FocusEvent focusEvent) {
                            MultiLineTextFieldEditor.this.valueChanged();
                            MultiLineTextFieldEditor.this.clearErrorMessage();
                        }
                    });
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"Unknown validate strategy");
                }
            }
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    MultiLineTextFieldEditor.this.textField = null;
                }
            });
            if (this.textLimit > 0) {
                this.textField.setTextLimit(this.textLimit);
            }
        } else {
            this.checkParent((Control)this.textField, composite);
        }
        return this.textField;
    }

    public boolean isEmptyStringAllowed() {
        return this.emptyStringAllowed;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void refreshValidState() {
        this.isValid = this.checkState();
    }

    public void setEmptyStringAllowed(boolean bl) {
        this.emptyStringAllowed = bl;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public void setFocus() {
        if (this.textField != null) {
            this.textField.setFocus();
        }
    }

    public void setStringValue(String string) {
        if (this.textField != null) {
            if (string == null) {
                string = "";
            }
            this.oldValue = this.textField.getText();
            if (!this.oldValue.equals(string)) {
                this.textField.setText(string);
                this.valueChanged();
            }
        }
    }

    public void setTextLimit(int n) {
        this.textLimit = n;
        if (this.textField != null) {
            this.textField.setTextLimit(n);
        }
    }

    public void setValidateStrategy(int n) {
        Assert.isTrue((n == 1 || n == 0 ? 1 : 0) != 0);
        this.validateStrategy = n;
    }

    public void showErrorMessage() {
        this.showErrorMessage(this.errorMessage);
    }

    protected void valueChanged() {
        String string;
        this.setPresentsDefaultValue(false);
        boolean bl = this.isValid;
        this.refreshValidState();
        if (this.isValid != bl) {
            this.fireStateChanged("field_editor_is_valid", bl, this.isValid);
        }
        if (!(string = this.textField.getText()).equals(this.oldValue)) {
            this.fireValueChanged("field_editor_value", this.oldValue, string);
            this.oldValue = string;
        }
    }
}

