/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewConfigurationDialog
extends Dialog {
    private static final String PREFIX = "NewConfiguration";
    private static final String LABEL = "NewConfiguration.label";
    private static final String ERROR = "NewConfiguration.error";
    private static final String NAME = "NewConfiguration.label.name";
    private static final String GROUP = "NewConfiguration.label.group";
    private static final String COPY = "NewConfiguration.label.copy";
    private static final String CLONE = "NewConfiguration.label.clone";
    private static final String TITLE = "NewConfiguration.error.title";
    private static final String DUPLICATE = "NewConfiguration.error.duplicateName";
    private Button btnClone;
    private Button btnCopy;
    private Button btnOk;
    private Text configName;
    private Combo copyConfigSelector;
    private Combo cloneConfigSelector;
    private boolean clone;
    private IConfiguration[] defaultConfigs;
    private IConfiguration[] definedConfigs;
    private IConfiguration parentConfig;
    private ITarget target;
    private String newName;
    private String title = "";

    protected NewConfigurationDialog(Shell shell, ITarget iTarget, String string) {
        super(shell);
        this.title = string;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.newName = new String();
        this.parentConfig = null;
        this.target = iTarget;
        this.clone = true;
        this.definedConfigs = this.target.getConfigurations();
        ITarget iTarget2 = this.target.getParent();
        this.defaultConfigs = iTarget2.getConfigurations();
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.newName = this.configName.getText().trim();
            String string = new String();
            if (this.clone) {
                string = this.cloneConfigSelector.getItem(this.cloneConfigSelector.getSelectionIndex());
                int n2 = 0;
                while (n2 < this.definedConfigs.length) {
                    IConfiguration iConfiguration = this.definedConfigs[n2];
                    if (iConfiguration.getName().equals(string)) {
                        this.parentConfig = iConfiguration;
                        break;
                    }
                    ++n2;
                }
            } else {
                string = this.copyConfigSelector.getItem(this.copyConfigSelector.getSelectionIndex());
                int n3 = 0;
                while (n3 < this.defaultConfigs.length) {
                    IConfiguration iConfiguration = this.defaultConfigs[n3];
                    if (iConfiguration.getName().equals(string)) {
                        this.parentConfig = iConfiguration;
                        break;
                    }
                    ++n3;
                }
            }
        } else {
            this.newName = null;
            this.parentConfig = null;
        }
        super.buttonPressed(n);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.btnOk = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.configName.setFocus();
        if (this.configName != null) {
            this.configName.setText(this.newName);
        }
        this.updateButtonState();
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 16384);
        label.setFont(composite.getFont());
        label.setText(ManagedBuilderUIMessages.getResourceString(NAME));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.configName = new Text(composite2, 2052);
        this.configName.setFont(composite2.getFont());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        this.configName.setLayoutData((Object)gridData);
        this.configName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewConfigurationDialog.this.updateButtonState();
            }
        });
        Group group = new Group(composite2, 0);
        group.setFont(composite2.getFont());
        group.setText(ManagedBuilderUIMessages.getResourceString(GROUP));
        GridLayout gridLayout = new GridLayout(3, false);
        group.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        group.setLayoutData((Object)gridData);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewConfigurationDialog.this.clone = NewConfigurationDialog.this.btnClone.getSelection();
                NewConfigurationDialog.this.updateComboState();
            }
        };
        this.btnCopy = new Button((Composite)group, 16);
        this.btnCopy.setFont(group.getFont());
        this.btnCopy.setText(ManagedBuilderUIMessages.getResourceString(COPY));
        this.setButtonLayoutData(this.btnCopy);
        this.btnCopy.addSelectionListener((SelectionListener)selectionAdapter);
        this.copyConfigSelector = new Combo((Composite)group, 2060);
        this.copyConfigSelector.setFont(group.getFont());
        this.copyConfigSelector.setItems(this.getDefaultConfigNames());
        int n = this.copyConfigSelector.indexOf(this.newName);
        this.copyConfigSelector.select(n < 0 ? 0 : n);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        this.copyConfigSelector.setLayoutData((Object)gridData);
        this.copyConfigSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewConfigurationDialog.this.updateButtonState();
            }
        });
        this.copyConfigSelector.setEnabled(false);
        this.btnClone = new Button((Composite)group, 16);
        this.btnClone.setFont(group.getFont());
        this.btnClone.setText(ManagedBuilderUIMessages.getResourceString(CLONE));
        this.setButtonLayoutData(this.btnClone);
        this.btnClone.addSelectionListener((SelectionListener)selectionAdapter);
        this.btnClone.setSelection(true);
        this.cloneConfigSelector = new Combo((Composite)group, 2060);
        this.cloneConfigSelector.setFont(group.getFont());
        this.cloneConfigSelector.setItems(this.getDefinedConfigNames());
        n = this.cloneConfigSelector.indexOf(this.newName);
        this.cloneConfigSelector.select(n < 0 ? 0 : n);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        this.cloneConfigSelector.setLayoutData((Object)gridData);
        this.cloneConfigSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewConfigurationDialog.this.updateButtonState();
            }
        });
        return composite2;
    }

    public IConfiguration getParentConfiguration() {
        return this.parentConfig;
    }

    private String[] getDefaultConfigNames() {
        String[] stringArray = new String[this.defaultConfigs.length];
        int n = 0;
        while (n < this.defaultConfigs.length) {
            IConfiguration iConfiguration = this.defaultConfigs[n];
            stringArray[n] = iConfiguration.getName();
            ++n;
        }
        return stringArray;
    }

    private String[] getDefinedConfigNames() {
        String[] stringArray = new String[this.definedConfigs.length];
        int n = 0;
        while (n < this.definedConfigs.length) {
            IConfiguration iConfiguration = this.definedConfigs[n];
            stringArray[n] = iConfiguration.getName();
            ++n;
        }
        return stringArray;
    }

    public String getNewName() {
        return this.newName;
    }

    protected boolean isDuplicateName(String string) {
        IConfiguration[] iConfigurationArray = this.target.getConfigurations();
        int n = 0;
        while (n < iConfigurationArray.length) {
            IConfiguration iConfiguration = iConfigurationArray[n];
            if (iConfiguration.getName() == string) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void updateButtonState() {
        if (this.btnOk != null) {
            int n = this.copyConfigSelector.getSelectionIndex();
            this.btnOk.setEnabled(this.validateName() && n != -1);
        }
    }

    protected void updateComboState() {
        this.cloneConfigSelector.setEnabled(this.clone);
        this.copyConfigSelector.setEnabled(!this.clone);
    }

    private boolean validateName() {
        String string = this.configName.getText().trim();
        int n = string.length();
        if (this.isDuplicateName(string)) {
            MessageDialog.openError((Shell)this.getShell(), (String)ManagedBuilderUIMessages.getResourceString(TITLE), (String)ManagedBuilderUIMessages.getFormattedString(DUPLICATE, string));
            return false;
        }
        return n > 0;
    }
}

