/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.ui.wizards.ConfigurationContentProvider;
import org.eclipse.cdt.managedbuilder.ui.wizards.ConfigurationLabelProvider;
import org.eclipse.cdt.managedbuilder.ui.wizards.NewManagedProjectWizard;
import org.eclipse.cdt.ui.wizards.NewCProjectWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.help.WorkbenchHelp;

public class CProjectPlatformPage
extends WizardPage {
    private static final String PREFIX = "PlatformBlock";
    private static final String LABEL = "PlatformBlock.label";
    private static final String TIP = "PlatformBlock.tip";
    private static final String CONFIG_LABEL = "PlatformBlock.label.configs";
    private static final String SHOWALL_LABEL = "PlatformBlock.label.showall";
    private static final String TARGET_LABEL = "PlatformBlock.label.platform";
    private static final String TARGET_TIP = "PlatformBlock.tip.platform";
    protected NewManagedProjectWizard parentWizard;
    protected Combo platformSelection;
    private ArrayList selectedConfigurations;
    protected ITarget selectedTarget;
    protected Button showAll;
    protected CheckboxTableViewer tableViewer;
    protected String[] targetNames;
    protected ArrayList targets;

    public CProjectPlatformPage(String string, NewManagedProjectWizard newManagedProjectWizard) {
        super(string);
        this.setPageComplete(false);
        this.selectedTarget = null;
        this.selectedConfigurations = new ArrayList(0);
        this.parentWizard = newManagedProjectWizard;
    }

    public boolean canFlipToNextPage() {
        return this.validatePage();
    }

    private void createConfigSelectionGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite2, 16384);
        label.setFont(composite2.getFont());
        label.setText(ManagedBuilderUIMessages.getResourceString(CONFIG_LABEL));
        Table table = new Table(composite2, 2854);
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        TableLayout tableLayout = new TableLayout();
        table.setHeaderVisible(false);
        table.setLayout((Layout)tableLayout);
        this.tableViewer = new CheckboxTableViewer(table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ConfigurationContentProvider());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                CProjectPlatformPage.this.handleConfigurationSelectionChange();
            }
        });
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        WorkbenchHelp.setHelp((Control)composite2, (String)"org.eclipse.cdt.ui.new_proj_wiz_m_target");
        this.createTargetSelectGroup(composite2);
        this.createConfigSelectionGroup(composite2);
        this.createShowAllGroup(composite2);
        this.populateTargets();
        this.platformSelection.select(0);
        this.handleTargetSelection();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite2);
    }

    private void createShowAllGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(768));
        this.showAll = new Button(composite2, 16416);
        this.showAll.setFont(composite2.getFont());
        this.showAll.setText(ManagedBuilderUIMessages.getResourceString(SHOWALL_LABEL));
        this.showAll.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CProjectPlatformPage.this.populateTargets();
                CProjectPlatformPage.this.platformSelection.select(0);
                CProjectPlatformPage.this.handleTargetSelection();
            }
        });
        this.showAll.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                CProjectPlatformPage.this.showAll = null;
            }
        });
    }

    private void createTargetSelectGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 16384);
        label.setFont(composite2.getFont());
        label.setText(ManagedBuilderUIMessages.getResourceString(TARGET_LABEL));
        this.platformSelection = new Combo(composite2, 2060);
        this.platformSelection.setFont(composite2.getFont());
        this.platformSelection.setToolTipText(ManagedBuilderUIMessages.getResourceString(TARGET_TIP));
        this.platformSelection.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CProjectPlatformPage.this.handleTargetSelection();
            }
        });
        this.platformSelection.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                CProjectPlatformPage.this.platformSelection = null;
            }
        });
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.platformSelection.setLayoutData((Object)gridData);
    }

    public IProject getProject() {
        return ((NewCProjectWizard)this.getWizard()).getNewProject();
    }

    public IConfiguration[] getSelectedConfigurations() {
        return this.selectedConfigurations.toArray(new IConfiguration[this.selectedConfigurations.size()]);
    }

    public ITarget getSelectedTarget() {
        return this.selectedTarget;
    }

    private void handleConfigurationSelectionChange() {
        this.selectedConfigurations.clear();
        this.selectedConfigurations.addAll(Arrays.asList(this.tableViewer.getCheckedElements()));
        this.setPageComplete(this.validatePage());
    }

    protected void handleTargetSelection() {
        int n;
        if (this.platformSelection != null && (n = this.platformSelection.getSelectionIndex()) != -1 && this.selectedTarget != (ITarget)this.targets.get(n)) {
            this.selectedTarget = (ITarget)this.targets.get(n);
            this.parentWizard.updateTargetProperties();
        }
        this.populateConfigurations();
        this.setPageComplete(this.validatePage());
    }

    private void populateConfigurations() {
        this.tableViewer.setInput((Object)this.selectedTarget);
        this.tableViewer.setAllChecked(true);
        this.handleConfigurationSelectionChange();
    }

    private void populateTargetNames() {
        this.targetNames = new String[this.targets.size()];
        ListIterator listIterator = this.targets.listIterator();
        int n = 0;
        while (listIterator.hasNext()) {
            this.targetNames[n++] = ((ITarget)listIterator.next()).getName();
        }
        this.platformSelection.removeAll();
        this.platformSelection.setItems(this.targetNames);
    }

    private void populateTargets() {
        ITarget[] iTargetArray = ManagedBuildManager.getDefinedTargets(null);
        this.targets = new ArrayList();
        String string = Platform.getOS();
        String string2 = Platform.getOSArch();
        int n = 0;
        while (n < iTargetArray.length) {
            ITarget iTarget = iTargetArray[n];
            if (!iTarget.isAbstract() && !iTarget.isTestTarget()) {
                if (this.showAll != null && this.showAll.getSelection()) {
                    this.targets.add(iTarget);
                } else {
                    List<String> list;
                    List<String> list2 = Arrays.asList(iTarget.getTargetOSList());
                    if ((list2.contains("all") || list2.contains(string)) && ((list = Arrays.asList(iTarget.getTargetArchList())).contains("all") || list.contains(string2))) {
                        this.targets.add(iTarget);
                    }
                }
            }
            ++n;
        }
        this.targets.trimToSize();
        this.populateTargetNames();
    }

    private boolean validatePage() {
        if (this.tableViewer.getCheckedElements().length > 0) {
            this.setErrorMessage(null);
            return true;
        }
        this.setErrorMessage(ManagedBuilderUIMessages.getResourceString("PlatformBlock.message.error.noconfigs"));
        return false;
    }
}

