/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.installhandlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeatureContentProvider;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.PluginEntry;

public class CustomContent {
    private static final String CUSTOM_CONTENT_DIR = "custom_content";
    private static final String ZIPPED_CONTENT_FILE_EXT = "jar";
    private static final String COMMAND_CONTENT_FILE_EXT = "bat";
    private static final String EXECUTABLE_CONTENT_FILE_EXT = "exe";
    private static final String DEFAULT_PREFS_FILE_NAME = "default.prefs";
    private String applicableCommandScript;
    private IPath zippedFile;
    private IPath commandScript;
    private IPath executable;
    private Properties defaultPrefs = new Properties();

    public CustomContent(String string) {
        this.applicableCommandScript = string;
    }

    public IPath getZippedContent() {
        return this.zippedFile;
    }

    public IPath getCommandScript() {
        return this.commandScript;
    }

    public IPath getExecutable() {
        return this.executable;
    }

    public Properties getDefaultPrefs() {
        return this.defaultPrefs;
    }

    public void getCustomContent(IPluginEntry iPluginEntry, URL uRL, IFeatureContentProvider iFeatureContentProvider) throws CoreException {
        ContentReference[] contentReferenceArray = iFeatureContentProvider.getPluginEntryContentReferences(iPluginEntry, null);
        String string = iPluginEntry instanceof PluginEntry ? ((PluginEntry)iPluginEntry).getVersionedIdentifier().toString() : "";
        Path path = new Path(this.localizedPathFromURL(uRL));
        path = path.append("plugins");
        path = path.append(string);
        int n = 0;
        while (n < contentReferenceArray.length) {
            ContentReference contentReference = contentReferenceArray[n];
            if (contentReference.getIdentifier().startsWith(CUSTOM_CONTENT_DIR)) {
                IPath iPath = path.append(contentReference.getIdentifier());
                if (ZIPPED_CONTENT_FILE_EXT.equals(iPath.getFileExtension())) {
                    this.zippedFile = iPath;
                } else if (COMMAND_CONTENT_FILE_EXT.equals(iPath.getFileExtension()) && iPath.toFile().getName().equals(String.valueOf(this.applicableCommandScript) + "." + COMMAND_CONTENT_FILE_EXT)) {
                    this.commandScript = iPath;
                } else if (EXECUTABLE_CONTENT_FILE_EXT.equals(iPath.getFileExtension())) {
                    this.executable = iPath;
                } else if (DEFAULT_PREFS_FILE_NAME.equals(iPath.toFile().getName())) {
                    try {
                        FileInputStream fileInputStream = new FileInputStream(iPath.toFile());
                        this.defaultPrefs.load(fileInputStream);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {
                        Status status = new Status(4, "", 0, iOException.getLocalizedMessage(), null);
                        throw new CoreException((IStatus)status);
                    }
                }
            }
            ++n;
        }
    }

    public static String zippedFileBaseName(IPath iPath) {
        File file = iPath.toFile();
        String string = file.getName();
        if (ZIPPED_CONTENT_FILE_EXT.equals(iPath.getFileExtension())) {
            string = string.substring(0, string.length() - (ZIPPED_CONTENT_FILE_EXT.length() + 1));
        }
        return string;
    }

    private String localizedPathFromURL(URL uRL) {
        String string = uRL.getPath();
        String string2 = System.getProperty("os.arch");
        if (string2 != null && string2.equals("x86") && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return string;
    }
}

