/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.installhandlers;

import com.palmsource.eclipse.installhandlers.CustomContent;
import com.palmsource.eclipse.installhandlers.StreamGobbler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.core.BaseInstallHandler;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IFeatureContentProvider;
import org.eclipse.update.core.IInstallHandlerEntry;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.InstallMonitor;
import org.osgi.service.prefs.BackingStoreException;

public class CustomInstallHandler
extends BaseInstallHandler {
    private Writer installOut;
    private Properties defaultPrefs;
    private static final String INSTALLHANDLER_PLUGIN_ID = "com.palmsource.eclipse.installhandlers";
    private static final String UPDATE_TRACE_FILE = "install.log";
    private static final String TRACING_FLAG = "com.palmsource.eclipse.installhandlers/debug/trace";
    private static final String DEBUG_FLAG = "com.palmsource.eclipse.installhandlers/debug/debug";
    private static final String FEATURES_PREFERENCE_SET = "com.palmsource.eclipse.features";
    private static final String KEY_PATH = "PATH";
    private static final String KEY_TMPDIR = "java.io.tmpdir";
    private static final String KEY_DRIVE = "DRIVE";
    private static final String KEY_VERSION = "VERSION";
    private static final String KEY_CURRENT_VERSION = "CURRENT_VERSION";
    private static final String KEY_IS_FEATURE = "IS_FEATURE";
    private static final String KEY_REG_PATH = "REG_PATH";
    private static final String DEFAULT_TMPDIR = "\\Temp";
    private static final String DEFAULT_DRIVE = "C:";
    private static final String CURRENT_VERSION_UNKNOWN = "0.0.0.0";
    private static final String SPACE = " ";
    private static final String ERR_INVALID_PARAMETER = "Invalid parameter";
    private static final String ERR_BAD_FILE = "Bad file ";
    private static final String ERR_CANNOT_CREATE = "Cannot create ";
    private static final String ERR_CANNOT_EXTRACT = "Unable to determine valid destination for extracted content";
    private static final String ERR_BAD_INSTALL = "Cannot locate Palm OS Developer Suite setup.exe";
    private static final String MSG_EXTRACTING_CONTENTS = "Installing content: ";
    private static final String MSG_DELETING_CONTENTS = "Deleting content: ";
    private static final String MSG_EXE_COMMAND = "Executing command: ";
    private static final String MSG_FILE = "files:";
    private static final String LINE_SEPARATOR;
    private static final boolean DEBUG;
    private static final boolean TRACE;

    static {
        String string = System.getProperty("line.separator");
        LINE_SEPARATOR = string == null ? "\n" : string;
        String string2 = Platform.getDebugOption((String)DEBUG_FLAG);
        DEBUG = string2 != null ? Boolean.valueOf(string2) : false;
        String string3 = Platform.getDebugOption((String)TRACING_FLAG);
        TRACE = string3 != null ? Boolean.valueOf(string3) : false;
    }

    public void initialize(int n, IFeature iFeature, IInstallHandlerEntry iInstallHandlerEntry, InstallMonitor installMonitor) throws CoreException {
        Object object;
        if (DEBUG || TRACE) {
            try {
                File file;
                object = Platform.getConfigurationLocation();
                URL uRL = object.getURL();
                URL uRL2 = new URL(uRL, INSTALLHANDLER_PLUGIN_ID);
                File file2 = new File(uRL2.getFile());
                if (!file2.exists()) {
                    file2.mkdir();
                }
                if (!(file = new File(uRL2.getFile(), UPDATE_TRACE_FILE)).exists()) {
                    file.createNewFile();
                }
                this.installOut = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
            }
            catch (Exception exception) {
                this.installOut = this.logForStream(System.err);
            }
        }
        if (TRACE) {
            object = null;
            object = n == 2 ? "HANDLER_ACTION_CONFIGURE" : (n == 1 ? "HANDLER_ACTION_INSTALL" : (n == 3 ? "HANDLER_ACTION_UNCONFIGURE" : "HANDLER_ACTION_UNINSTALL"));
            this.traceWrite((String)object);
        }
        super.initialize(n, iFeature, iInstallHandlerEntry, installMonitor);
    }

    public void installInitiated() throws CoreException {
        this.traceWrite("installInitiated");
        super.installInitiated();
    }

    public void completeInstall(IFeatureContentConsumer iFeatureContentConsumer) throws CoreException {
        Object object;
        this.traceWrite("completeInstall");
        super.completeInstall(iFeatureContentConsumer);
        this.feature.getFeatureContentProvider();
        int n = 0;
        while (n < this.pluginEntries.length) {
            object = this.pluginEntries[n];
            IPath iPath = this.installCustomContent((IPluginEntry)object, iFeatureContentConsumer.getFeature(), this.feature.getFeatureContentProvider(), "install");
            String string = object.getVersionedIdentifier().getIdentifier();
            String string2 = object.getVersionedIdentifier().getVersion().toString();
            this.setProperty(string, KEY_CURRENT_VERSION, string2);
            if (iPath != null) {
                this.setProperty(string, KEY_PATH, iPath.toString());
            }
            ++n;
        }
        String string = this.feature.getVersionedIdentifier().getIdentifier();
        object = this.feature.getVersionedIdentifier().getVersion().toString();
        this.setProperty(FEATURES_PREFERENCE_SET, string, (String)object);
    }

    public void installCompleted(boolean bl) throws CoreException {
        this.traceWrite("installCompleted");
        super.installCompleted(bl);
    }

    public void configureInitiated() throws CoreException {
        this.traceWrite("configureInitiated");
        super.configureInitiated();
    }

    public void completeConfigure() throws CoreException {
        String string;
        Object object;
        String string2;
        IPluginEntry iPluginEntry;
        this.traceWrite("completeConfigure");
        super.completeConfigure();
        String string3 = this.feature.getVersionedIdentifier().getIdentifier();
        PluginVersionIdentifier pluginVersionIdentifier = this.feature.getVersionedIdentifier().getVersion();
        PluginVersionIdentifier pluginVersionIdentifier2 = new PluginVersionIdentifier(this.getProperty(FEATURES_PREFERENCE_SET, string3, CURRENT_VERSION_UNKNOWN));
        if (pluginVersionIdentifier2.isGreaterThan(pluginVersionIdentifier)) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        IPluginEntry[] iPluginEntryArray = this.feature.getPluginEntries();
        int n = 0;
        while (n < iPluginEntryArray.length) {
            iPluginEntry = iPluginEntryArray[n];
            string2 = iPluginEntry.getVersionedIdentifier().getIdentifier();
            object = iPluginEntry.getVersionedIdentifier().getVersion().toString();
            string = null;
            if (!((String)object).equals(this.getProperty(string2, KEY_CURRENT_VERSION, CURRENT_VERSION_UNKNOWN))) {
                if (((String)object).equals(this.getProperty(string2, KEY_VERSION, CURRENT_VERSION_UNKNOWN))) {
                    CustomContent customContent = new CustomContent("configure");
                    customContent.getCustomContent(iPluginEntry, this.feature.getSite().getURL(), this.feature.getFeatureContentProvider());
                    Properties properties = customContent.getDefaultPrefs();
                    String string4 = properties.getProperty(String.valueOf(string2) + "/" + KEY_IS_FEATURE);
                    if (string4 != null && !arrayList.contains(string4)) {
                        arrayList.add(string4);
                    }
                } else {
                    string = this.installCustomContent(iPluginEntry, this.feature, this.feature.getFeatureContentProvider(), "configure");
                }
                this.setProperty(string2, KEY_CURRENT_VERSION, (String)object);
                if (string != null) {
                    this.setProperty(string2, KEY_PATH, string.toString());
                }
            }
            ++n;
        }
        if (!arrayList.isEmpty()) {
            String string5 = this.getProperty(INSTALLHANDLER_PLUGIN_ID, KEY_PATH, null);
            if (string5 == null) {
                iPluginEntry = new Status(4, INSTALLHANDLER_PLUGIN_ID, 0, ERR_BAD_INSTALL, null);
                string2 = new CoreException((IStatus)iPluginEntry);
                throw string2;
            }
            iPluginEntry = new Path(string5);
            iPluginEntry = iPluginEntry.append("setup.exe");
            string2 = new String();
            object = arrayList.iterator();
            while (object.hasNext()) {
                string = (String)object.next();
                string2 = string2.concat(String.valueOf(string) + ",");
            }
            if (string2.endsWith(",")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            this.execCommand(iPluginEntry.toOSString(), new String[]{"/z", "-r=" + string2});
        }
        String string6 = this.feature.getVersionedIdentifier().getVersion().toString();
        this.setProperty(FEATURES_PREFERENCE_SET, string3, string6);
    }

    public void configureCompleted(boolean bl) throws CoreException {
        this.traceWrite("configureCompleted");
        super.configureCompleted(bl);
    }

    public void unconfigureInitiated() throws CoreException {
        this.traceWrite("unconfigureInitiated");
        super.unconfigureInitiated();
    }

    public void completeUnconfigure() throws CoreException {
        this.traceWrite("completeUnconfigure");
        super.completeUnconfigure();
        String string = this.feature.getVersionedIdentifier().getIdentifier();
        String string2 = this.feature.getVersionedIdentifier().getVersion().toString();
        if (string2.equals(this.getProperty(FEATURES_PREFERENCE_SET, string, CURRENT_VERSION_UNKNOWN))) {
            this.setProperty(FEATURES_PREFERENCE_SET, string, CURRENT_VERSION_UNKNOWN);
        }
    }

    public void unconfigureCompleted(boolean bl) throws CoreException {
        this.traceWrite("unconfigureCompleted");
        super.unconfigureCompleted(bl);
    }

    public void uninstallInitiated() throws CoreException {
        this.traceWrite("uninstallInitiated");
        super.uninstallInitiated();
    }

    public void completeUninstall() throws CoreException {
        this.traceWrite("completeUninstall");
        super.completeUninstall();
        String string = this.feature.getVersionedIdentifier().getIdentifier();
        String string2 = this.feature.getVersionedIdentifier().getVersion().toString();
        if (string2.equals(this.getProperty(FEATURES_PREFERENCE_SET, string, CURRENT_VERSION_UNKNOWN))) {
            this.setProperty(FEATURES_PREFERENCE_SET, string, CURRENT_VERSION_UNKNOWN);
        }
    }

    public void uninstallCompleted(boolean bl) throws CoreException {
        this.traceWrite("uninstallCompleted");
        super.uninstallCompleted(bl);
    }

    public void nonPluginDataDownloaded(INonPluginEntry[] iNonPluginEntryArray, IVerificationListener iVerificationListener) throws CoreException {
        this.traceWrite("nonPluginDataDownloaded");
        super.nonPluginDataDownloaded(iNonPluginEntryArray, iVerificationListener);
    }

    public void pluginsDownloaded(IPluginEntry[] iPluginEntryArray) throws CoreException {
        this.traceWrite("pluginsDownloaded");
        int n = 0;
        while (n < iPluginEntryArray.length) {
            this.debugWrite(iPluginEntryArray[n].getVersionedIdentifier().toString());
            ++n;
        }
        super.pluginsDownloaded(iPluginEntryArray);
    }

    private IPath installCustomContent(IPluginEntry iPluginEntry, IFeature iFeature, IFeatureContentProvider iFeatureContentProvider, String string) throws CoreException {
        IPath iPath;
        IPath iPath2;
        CustomContent customContent = new CustomContent(string);
        customContent.getCustomContent(iPluginEntry, iFeature.getSite().getURL(), iFeatureContentProvider);
        this.defaultPrefs = customContent.getDefaultPrefs();
        IPath iPath3 = null;
        IPath iPath4 = customContent.getZippedContent();
        if (iPath4 != null) {
            iPath3 = this.extractZippedContent(iPath4);
        }
        if ((iPath2 = customContent.getExecutable()) != null) {
            iPath3 = this.executeExecutable(iPath2, iPluginEntry.getVersionedIdentifier().getIdentifier());
        }
        if ((iPath = customContent.getCommandScript()) != null) {
            IPath iPath5 = this.transformFile(iPath);
            this.execCommand(iPath5.toOSString(), null);
            File file = iPath5.toFile();
            file.delete();
        }
        return iPath3;
    }

    private void uninstallCustomContent(IPluginEntry iPluginEntry, IFeature iFeature, IFeatureContentProvider iFeatureContentProvider) throws CoreException {
        IPath iPath;
        CustomContent customContent = new CustomContent("uninstall");
        customContent.getCustomContent(iPluginEntry, iFeature.getSite().getURL(), iFeatureContentProvider);
        this.defaultPrefs = customContent.getDefaultPrefs();
        IPath iPath2 = customContent.getCommandScript();
        if (iPath2 != null) {
            iPath = this.transformFile(iPath2);
            this.execCommand(iPath.toOSString(), null);
            File file = iPath.toFile();
            file.delete();
        }
        if ((iPath = customContent.getZippedContent()) != null) {
            this.deleteZippedContent(iPath);
        }
    }

    private void setProperty(String string, String string2, String string3) throws CoreException {
        if (string == null || string3 == null) {
            return;
        }
        ConfigurationScope configurationScope = new ConfigurationScope();
        IEclipsePreferences iEclipsePreferences = configurationScope.getNode(string);
        iEclipsePreferences.put(string2, string3);
        try {
            iEclipsePreferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            Status status = new Status(4, INSTALLHANDLER_PLUGIN_ID, 0, backingStoreException.getLocalizedMessage(), null);
            CoreException coreException = new CoreException((IStatus)status);
            throw coreException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getProperty(String string, String string2, String string3) throws CoreException {
        String string4;
        block12: {
            Path path;
            String string5;
            if (INSTALLHANDLER_PLUGIN_ID.equals(string) && KEY_DRIVE.equals(string2)) {
                return this.getEclipseInstallDir().getDevice();
            }
            if (INSTALLHANDLER_PLUGIN_ID.equals(string) && KEY_TMPDIR.equals(string2)) {
                return System.getProperty(KEY_TMPDIR, DEFAULT_TMPDIR);
            }
            IPreferencesService iPreferencesService = Platform.getPreferencesService();
            string4 = iPreferencesService.getString(string, string2, null, null);
            if (string4 != null || (string5 = System.getProperty("PODSPrefsDir")) == null || !(path = new Path(string5)).toFile().exists() || !(path = path.append(String.valueOf(string) + ".prefs")).toFile().exists()) break block12;
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(path.toFile());
                    if (fileInputStream != null) {
                        properties.load(fileInputStream);
                    }
                }
                catch (IOException iOException) {
                    Status status = new Status(4, INSTALLHANDLER_PLUGIN_ID, 0, iOException.getLocalizedMessage(), null);
                    CoreException coreException = new CoreException((IStatus)status);
                    throw coreException;
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                try {
                    if (fileInputStream == null) throw throwable;
                    ((InputStream)fileInputStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var13_15 = null;
            }
            try {}
            catch (IOException iOException) {}
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            string4 = properties.getProperty(string2);
        }
        if (string4 != null) return string4;
        return string3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IPath transformFile(IPath iPath) throws CoreException {
        String string;
        File file = new File(System.getProperty(KEY_TMPDIR, DEFAULT_TMPDIR));
        File file2 = new File(file, string = iPath.toFile().getName());
        if (file2 == null) {
            Status status = new Status(4, INSTALLHANDLER_PLUGIN_ID, 0, ERR_BAD_FILE + file + string, null);
            CoreException coreException = new CoreException((IStatus)status);
            throw coreException;
        }
        if (file2.exists()) {
            file2.delete();
        }
        try {
            file2.createNewFile();
        }
        catch (IOException iOException) {
            Status status = new Status(4, INSTALLHANDLER_PLUGIN_ID, 0, ERR_CANNOT_CREATE + file2.getName(), null);
            CoreException coreException = new CoreException((IStatus)status);
            throw coreException;
        }
        File file3 = iPath.toFile();
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            try {
                String string2;
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file3)));
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file2)));
                block10: while ((string2 = bufferedReader.readLine()) != null) {
                    String string3 = string2;
                    while (true) {
                        int n;
                        int n2;
                        if ((n2 = string3.indexOf("???")) == -1 || (n = string3.indexOf("???", n2 + 3)) == -1) {
                            bufferedWriter.write(string3);
                            bufferedWriter.newLine();
                            continue block10;
                        }
                        String string4 = INSTALLHANDLER_PLUGIN_ID;
                        String string5 = string3.substring(n2 + 3, n);
                        int n3 = string5.indexOf(47);
                        if (n3 != -1) {
                            string4 = string5.substring(0, n3);
                            string5 = string5.substring(n3 + 1);
                        }
                        String string6 = null;
                        String string7 = null;
                        string7 = KEY_REG_PATH.equals(string5) ? KEY_PATH : string5;
                        string6 = this.getProperty(string4, string7, this.defaultPrefs.getProperty(String.valueOf(string4) + "/" + string7));
                        if (string6 != null && string7.equals(KEY_PATH)) {
                            Path path = new Path(string6);
                            if (path.getDevice() == null || path.getDevice().length() == 0) {
                                String string8 = this.getProperty(INSTALLHANDLER_PLUGIN_ID, KEY_DRIVE, DEFAULT_DRIVE);
                                path = new Path(string8, string6);
                            }
                            string6 = path.toOSString();
                            if (KEY_REG_PATH.equals(string5)) {
                                string6 = CustomInstallHandler.escapePath(string6);
                            }
                        }
                        if (string6 != null) {
                            string3 = String.valueOf(string3.substring(0, n2)) + string6 + string3.substring(n + 3);
                            continue;
                        }
                        string3 = String.valueOf(string3.substring(0, n2)) + string3.substring(n + 3);
                    }
                }
            }
            catch (Exception exception) {
                file2.delete();
                Status status = new Status(4, INSTALLHANDLER_PLUGIN_ID, 0, exception.getMessage(), (Throwable)exception);
                CoreException coreException = new CoreException((IStatus)status);
                throw coreException;
            }
        }
        catch (Throwable throwable) {
            Object var19_27 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (bufferedWriter == null) throw throwable;
                bufferedWriter.flush();
                bufferedWriter.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var19_28 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (bufferedReader != null) {
            bufferedReader.close();
        }
        if (bufferedWriter == null) return new Path(file2.getAbsolutePath());
        bufferedWriter.flush();
        bufferedWriter.close();
        return new Path(file2.getAbsolutePath());
    }

    /*
     * Exception decompiling
     */
    private IPath extractZippedContent(IPath var1_1) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 570->573)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void deleteZippedContent(IPath var1_1) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 418->422)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteEmptyDirs(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                File file2 = fileArray[n];
                if (file2 != null && file2.isDirectory()) {
                    this.deleteEmptyDirs(file2);
                }
                ++n;
            }
        }
        if ((fileArray = file.listFiles()) == null || fileArray.length == 0) {
            file.delete();
        }
    }

    private IPath executeExecutable(IPath iPath, String string) throws CoreException {
        if (iPath == null) {
            Status status = new Status(4, INSTALLHANDLER_PLUGIN_ID, 0, ERR_INVALID_PARAMETER, null);
            throw new CoreException((IStatus)status);
        }
        String string2 = iPath.toFile().getAbsolutePath();
        if (this.monitor != null) {
            this.monitor.setTaskName(MSG_EXTRACTING_CONTENTS + iPath.toFile().getName());
        }
        this.debugWrite(MSG_EXTRACTING_CONTENTS + iPath.toOSString());
        String string3 = this.getProperty(string, KEY_PATH, this.defaultPrefs.getProperty(String.valueOf(string) + "/" + KEY_PATH));
        if (string3 == null) {
            Status status = new Status(4, INSTALLHANDLER_PLUGIN_ID, 0, ERR_CANNOT_EXTRACT, null);
            throw new CoreException((IStatus)status);
        }
        Path path = new Path(string3);
        if (path == null) {
            Status status = new Status(4, INSTALLHANDLER_PLUGIN_ID, 0, ERR_CANNOT_EXTRACT, null);
            throw new CoreException((IStatus)status);
        }
        string2 = String.valueOf('\"') + string2 + '\"';
        String string4 = "-d \"" + path.toOSString() + '\"';
        try {
            this.debugWrite(MSG_EXE_COMMAND + string2 + SPACE + string4);
            String[] stringArray = new String[]{string2, "-o", "-d", String.valueOf('\"') + path.toOSString() + '\"'};
            Process process = Runtime.getRuntime().exec(stringArray);
            StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream());
            StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream());
            streamGobbler.start();
            streamGobbler2.start();
            int n = process.waitFor();
            this.debugWrite("OutputStream - " + streamGobbler2.getStreamContents().toString());
            this.debugWrite("ErrorStream - " + streamGobbler.getStreamContents().toString());
            if (n != 0) {
                Status status = new Status(4, INSTALLHANDLER_PLUGIN_ID, 0, "Installation error " + n, null);
                throw new CoreException((IStatus)status);
            }
        }
        catch (IOException iOException) {
            this.debugWrite("==>IOException " + iOException.toString());
            Status status = new Status(4, INSTALLHANDLER_PLUGIN_ID, 0, iOException.getMessage(), (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
        catch (InterruptedException interruptedException) {
            this.debugWrite("==>InterruptedException " + interruptedException.toString());
            Status status = new Status(4, INSTALLHANDLER_PLUGIN_ID, 0, interruptedException.getMessage(), (Throwable)interruptedException);
            throw new CoreException((IStatus)status);
        }
        return path;
    }

    private void execCommand(String string, String[] stringArray) throws CoreException {
        if (string == null) {
            Status status = new Status(4, INSTALLHANDLER_PLUGIN_ID, 0, ERR_INVALID_PARAMETER, null);
            throw new CoreException((IStatus)status);
        }
        int n = stringArray == null ? 0 : stringArray.length;
        String string2 = new String();
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                string2 = string2.concat(String.valueOf(' ') + stringArray[n2]);
                ++n2;
            }
        }
        try {
            this.debugWrite("Executing command: \"" + string + '\"' + SPACE + string2);
            String[] stringArray2 = new String[n + 1];
            stringArray2[0] = String.valueOf('\"') + string + '\"';
            if (n > 0) {
                System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
            }
            Process process = Runtime.getRuntime().exec(stringArray2);
            StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream());
            StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream());
            streamGobbler.start();
            streamGobbler2.start();
            int n3 = process.waitFor();
            this.debugWrite("OutputStream - " + streamGobbler2.getStreamContents().toString());
            this.debugWrite("ErrorStream - " + streamGobbler.getStreamContents().toString());
            if (n3 != 0) {
                Status status = new Status(4, INSTALLHANDLER_PLUGIN_ID, 0, "Installation error " + n3, null);
                throw new CoreException((IStatus)status);
            }
        }
        catch (IOException iOException) {
            this.debugWrite("==>IOException " + iOException.toString());
            Status status = new Status(4, INSTALLHANDLER_PLUGIN_ID, 0, iOException.getMessage(), (Throwable)iOException);
            throw new CoreException((IStatus)status);
        }
        catch (InterruptedException interruptedException) {
            this.debugWrite("==>InterruptedException " + interruptedException.toString());
            Status status = new Status(4, INSTALLHANDLER_PLUGIN_ID, 0, interruptedException.getMessage(), (Throwable)interruptedException);
            throw new CoreException((IStatus)status);
        }
    }

    private static String escapePath(String string) {
        String string2 = string;
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n = 0;
            while (n < string.length()) {
                int n2 = string.indexOf(92, n);
                if (n2 == -1) {
                    stringBuffer.append(string.toCharArray(), n, string.length() - n);
                    break;
                }
                stringBuffer.append(string.toCharArray(), n, n2 - n);
                stringBuffer.append('\\');
                stringBuffer.append('\\');
                n = n2 + 1;
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private IPath getEclipseInstallDir() {
        String string = ConfiguratorUtils.getInstallURL().getPath();
        String string2 = System.getProperty("os.arch");
        if (string2 != null && string2.equals("x86") && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return new Path(string);
    }

    private Writer logForStream(OutputStream outputStream) {
        if (outputStream == null) {
            return null;
        }
        try {
            return new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new BufferedWriter(new OutputStreamWriter(outputStream));
        }
    }

    private void debugWrite(String string) {
        if (DEBUG) {
            try {
                if (string != null) {
                    this.installOut.write("   ***");
                    this.installOut.write(string);
                    this.installOut.write(LINE_SEPARATOR);
                    this.installOut.flush();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void traceWrite(String string) {
        if (TRACE) {
            try {
                if (string != null) {
                    this.installOut.write(String.valueOf(this.feature.getVersionedIdentifier().getIdentifier()) + '_' + this.feature.getVersionedIdentifier().getVersion() + ": ");
                    this.installOut.write(string);
                    this.installOut.write(LINE_SEPARATOR);
                    this.installOut.flush();
                }
            }
            catch (Exception exception) {}
        }
    }
}

