/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.tools.restools.internal.tools;

import com.palmsource.eclipse.tools.restools.ResToolsPlugin;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class XRDGenerate {
    public static final int GENERATE_NONE = 0;
    public static final int GENERATE_UNKNOWN_RESOURCES = 2;
    public static final int GENERATE_RAW_RESOURCES = 4;
    public static final int GENERATE_DATABASE_HEADER = 8;
    public static final int GENERATE_CODE_RESOURCES = 16;
    public static final int GENERATE_EXTERNAL_FILES = 32;
    IPath input;
    IPath output;
    IPath workdir;
    IPath datadir;
    String target;
    String locale;
    int options = 0;

    public XRDGenerate(IPath iPath, IPath iPath2) {
        this.input = iPath;
        this.output = iPath2;
    }

    public XRDGenerate(IPath iPath, IPath iPath2, IPath iPath3) {
        this.input = iPath;
        this.output = iPath2;
        this.workdir = iPath3;
    }

    public IStatus execute() {
        Status status;
        File file = this.getWorkdir().toFile();
        if (file.isFile()) {
            file = file.getParentFile();
        }
        String string = "XRDGenerate";
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            Process process = Runtime.getRuntime().exec(this.getCommand(), null, file);
            this.copyStream(process.getInputStream(), byteArrayOutputStream);
            process.waitFor();
            int n = process.exitValue();
            if (n == 0) {
                status = new Status(0, string, n, "", null);
            } else {
                String[] stringArray = byteArrayOutputStream.toString().split("\n");
                MultiStatus multiStatus = new MultiStatus(string, n, String.valueOf(ResToolsPlugin.getResourceString("XRDGenerate.error_failed")) + n, null);
                int n2 = 0;
                while (n2 < stringArray.length) {
                    multiStatus.add((IStatus)new Status(4, string, n, stringArray[n2], null));
                    ++n2;
                }
                status = multiStatus;
            }
        }
        catch (Exception exception) {
            status = new Status(4, string, -1, exception.getMessage(), (Throwable)exception);
        }
        return status;
    }

    private String[] getCommand() {
        ArrayList<String> arrayList = new ArrayList<String>();
        IPath iPath = this.getToolsDirectory();
        Path path = new Path(".");
        if (iPath == null) {
            throw new IllegalArgumentException(ResToolsPlugin.getResourceString("XRDGenerate.error_invalid_tools_path"));
        }
        IPath iPath2 = iPath.append(ResToolsPlugin.getResourceString("XRDGenerate.command"));
        if (!iPath2.toFile().exists()) {
            throw new IllegalArgumentException(ResToolsPlugin.getResourceString("XRDGenerate.error_command_not_found"));
        }
        if (!this.input.toFile().exists()) {
            throw new IllegalArgumentException(ResToolsPlugin.getResourceString("XRDGenerate.error_input_not_found"));
        }
        arrayList.add(iPath2.toOSString());
        arrayList.add(this.input.toOSString());
        arrayList.add("-o");
        arrayList.add(path.append(this.output).toOSString());
        if (this.target != null) {
            arrayList.add("-target");
            arrayList.add(this.target);
        }
        if (this.locale != null) {
            arrayList.add("-locale");
            arrayList.add(this.locale);
        }
        if ((this.options & 2) != 0) {
            arrayList.add("-noUnknown");
        }
        if ((this.options & 4) != 0) {
            arrayList.add("-raw");
        }
        if ((this.options & 8) != 0) {
            arrayList.add("-d");
        }
        if ((this.options & 0x10) != 0) {
            arrayList.add("-s");
        }
        if ((this.options & 0x20) != 0) {
            arrayList.add("-externDataFiles");
            if (this.datadir != null && !this.datadir.isEmpty()) {
                arrayList.add("-externFilesDir");
                arrayList.add(path.append(this.datadir).toOSString());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private IPath getToolsDirectory() {
        String string = ResToolsPlugin.getResToolsPath();
        if (string == null) {
            return null;
        }
        Path path = new Path(string);
        if (path == null) {
            return null;
        }
        return path.addTrailingSeparator();
    }

    private void copyStream(InputStream inputStream, OutputStream outputStream) {
        final InputStream inputStream2 = inputStream;
        final OutputStream outputStream2 = outputStream;
        Thread thread = new Thread("copyStream"){

            public void run() {
                try {
                    byte[] byArray = new byte[128];
                    while (inputStream2.read(byArray) != -1) {
                        outputStream2.write(byArray);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        thread.start();
    }

    private void printList(List list, PrintStream printStream) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            printStream.print(iterator.next() + " ");
        }
        printStream.println("");
    }

    public IPath getInput() {
        return this.input;
    }

    public void setInput(IPath iPath) {
        this.input = iPath;
    }

    public IPath getOutput() {
        return this.output;
    }

    public void setOutput(IPath iPath) {
        this.output = iPath;
    }

    public IPath getWorkdir() {
        return this.workdir != null ? this.workdir : this.output;
    }

    public void setWorkdir(IPath iPath) {
        this.workdir = iPath;
    }

    public int getOptions() {
        return this.options;
    }

    public void setOptions(int n) {
        this.options = n;
    }

    public IPath getDataDirectory() {
        return this.datadir;
    }

    public void setDataDirectory(IPath iPath) {
        this.datadir = iPath;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String string) {
        this.locale = string;
    }
}

