/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.tools.restools.ui.wizards;

import com.palmsource.eclipse.tools.restools.ResToolsPlugin;
import com.palmsource.eclipse.tools.restools.internal.tools.XRDGenerate;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.dialogs.WizardResourceImportPage;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class XRDImportWizardPage
extends WizardResourceImportPage {
    private static final String DEFAULT_XRD_FOLDER = "rsc";
    private static final String DEFAULT_XRD_EXTENSION = "xrd";
    private static final String[] RESOURCE_EXTENSIONS = new String[]{"*.PRC;*.RSRC;*.XRD"};
    private static final String XRD = "XRDImportWizard.";
    private static final String XRDtitle = "XRDImportWizard.title";
    private static final String XRDdescription = "XRDImportWizard.description";
    private static final String XRDfrom = "XRDImportWizard.from";
    private static final String XRDdest = "XRDImportWizard.dest";
    private static final String XRDbrowse = "XRDImportWizard.browse";
    private static final String XRDtarget = "XRDImportWizard.target";
    private static final String XRDlocale = "XRDImportWizard.locale";
    private static final String XRDunknownResources = "XRDImportWizard.unknownResources";
    private static final String XRDrawResources = "XRDImportWizard.rawResources";
    private static final String XRDdatabaseHeader = "XRDImportWizard.databaseHeader";
    private static final String XRDcodeResources = "XRDImportWizard.codeResources";
    private static final String XRDexternalResources = "XRDImportWizard.externalResources";
    private static final String XRDexternalDir = "XRDImportWizard.externalDir";
    private static final String XRDexternalDirTitle = "XRDImportWizard.externalDirTitle";
    private static final String XRDexternalDirMsg = "XRDImportWizard.externalDirMsg";
    private static final String XRDnoSourceMsg = "XRDImportWizard.msg.noSource";
    private static final String XRDnoDestinationMsg = "XRDImportWizard.msg.noDestination";
    private static final String XRDwrongFileTypeMsg = "XRDImportWizard.msg.wrongFileType";
    private static final String XRDimportFailedMsg = "XRDImportWizard.msg.importFailed";
    private static final String XRDgenerateFailedMsg = "XRDImportWizard.msg.generateFailed";
    protected Text sourceText;
    protected Button browseButton;
    protected Text destText;
    protected Combo targetCombo;
    protected Combo localeCombo;
    protected Button noUnknownResourcesButton;
    protected Button rawResourcesButton;
    protected Button databaseHeaderButton;
    protected Button codeResourcesButton;
    protected Button externalFilesButton;
    protected Label externalDirLabel;
    protected Text externalDirText;
    protected Button externalDirButton;
    protected Composite externalDir;
    protected IPath project = null;

    public XRDImportWizardPage(String string, IStructuredSelection iStructuredSelection) {
        super(string, iStructuredSelection);
        this.setTitle(XRDImportWizardPage.getText(XRDtitle));
        this.setDescription(XRDImportWizardPage.getText(XRDdescription));
    }

    protected void createSourceGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setText(XRDImportWizardPage.getText(XRDfrom));
        label.setLayoutData((Object)new GridData(256));
        this.sourceText = new Text(composite2, 2052);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.sourceText.setLayoutData((Object)gridData);
        this.sourceText.addListener(24, (Listener)this);
        this.browseButton = new Button(composite2, 8);
        this.browseButton.setText(XRDImportWizardPage.getText(XRDbrowse));
        this.setButtonLayoutData(this.browseButton);
        this.browseButton.addListener(13, (Listener)this);
        this.createSpacer(composite);
        Label label2 = new Label(composite2, 0);
        label2.setText(XRDImportWizardPage.getText(XRDdest));
        label2.setLayoutData((Object)new GridData(256));
        this.destText = new Text(composite2, 2052);
        gridData = new GridData(768);
        gridData.widthHint = 250;
        this.destText.setLayoutData((Object)gridData);
        this.destText.addListener(24, (Listener)this);
    }

    protected void createOptionsGroupButtons(Group group) {
        group.setLayout((Layout)new GridLayout(4, true));
        this.createSpacer((Composite)group, 4);
        Label label = new Label((Composite)group, 0);
        label.setText(XRDImportWizardPage.getText(XRDtarget));
        GridData gridData = new GridData(128);
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.targetCombo = new Combo((Composite)group, 0);
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.targetCombo.setLayoutData((Object)gridData);
        this.initComboFromResources(this.targetCombo, XRDtarget);
        this.createSpacer((Composite)group, 4);
        Label label2 = new Label((Composite)group, 0);
        label2.setText(XRDImportWizardPage.getText(XRDlocale));
        gridData = new GridData(128);
        gridData.horizontalSpan = 1;
        label2.setLayoutData((Object)gridData);
        this.localeCombo = new Combo((Composite)group, 0);
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.localeCombo.setLayoutData((Object)gridData);
        this.initComboFromResources(this.localeCombo, XRDlocale);
        this.createSpacer((Composite)group, 4);
        this.noUnknownResourcesButton = new Button((Composite)group, 32);
        this.noUnknownResourcesButton.setText(XRDImportWizardPage.getText(XRDunknownResources));
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.noUnknownResourcesButton.setLayoutData((Object)gridData);
        this.databaseHeaderButton = new Button((Composite)group, 32);
        this.databaseHeaderButton.setText(XRDImportWizardPage.getText(XRDdatabaseHeader));
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.databaseHeaderButton.setLayoutData((Object)gridData);
        this.rawResourcesButton = new Button((Composite)group, 32);
        this.rawResourcesButton.setText(XRDImportWizardPage.getText(XRDrawResources));
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.rawResourcesButton.setLayoutData((Object)gridData);
        this.codeResourcesButton = new Button((Composite)group, 32);
        this.codeResourcesButton.setText(XRDImportWizardPage.getText(XRDcodeResources));
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.codeResourcesButton.setLayoutData((Object)gridData);
        this.createSpacer((Composite)group, 4);
        this.externalFilesButton = new Button((Composite)group, 32);
        this.externalFilesButton.setText(XRDImportWizardPage.getText(XRDexternalResources));
        gridData = new GridData(256);
        gridData.horizontalSpan = 4;
        this.externalFilesButton.setLayoutData((Object)gridData);
        this.externalFilesButton.addListener(13, (Listener)this);
        this.externalDir = new Composite((Composite)group, 0);
        this.externalDir.setLayout((Layout)new GridLayout(3, false));
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.externalDir.setLayoutData((Object)gridData);
        this.externalDirLabel = new Label(this.externalDir, 0);
        this.externalDirLabel.setText(XRDImportWizardPage.getText(XRDexternalDir));
        this.externalDirLabel.setLayoutData((Object)new GridData(256));
        this.externalDirText = new Text(this.externalDir, 2052);
        gridData = new GridData(768);
        gridData.widthHint = 250;
        this.externalDirText.setLayoutData((Object)gridData);
        this.externalDirText.addListener(24, (Listener)this);
        this.externalDirButton = new Button(this.externalDir, 8);
        this.externalDirButton.setText(XRDImportWizardPage.getText(XRDbrowse));
        this.setButtonLayoutData(this.externalDirButton);
        this.externalDirButton.addListener(13, (Listener)this);
        this.createSpacer((Composite)group, 4);
    }

    private Label createSpacer(Composite composite, int n) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private void initComboFromResources(Combo combo, String string) {
        String string2 = XRDImportWizardPage.getText(String.valueOf(string) + "Default");
        String string3 = XRDImportWizardPage.getText(String.valueOf(string) + "List");
        String[] stringArray = string3.split(" ");
        combo.select(0);
        int n = 0;
        while (n < stringArray.length) {
            String string4 = stringArray[n];
            String string5 = XRDImportWizardPage.getText(String.valueOf(string) + "." + string4);
            combo.add(string5);
            combo.setData(string5, (Object)string4);
            if (stringArray[n].equals(string2)) {
                combo.select(n);
            }
            ++n;
        }
    }

    public void handleEvent(Event event) {
        Widget widget = event.widget;
        if (widget == this.browseButton) {
            this.handleSourceBrowse(event);
        } else if (widget == this.externalDirButton) {
            this.handleExternalDirBrowse(event);
        } else if (widget == this.sourceText) {
            this.handleSourceChange(event);
        }
        super.handleEvent(event);
    }

    private void handleSourceBrowse(Event event) {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        String string = this.sourceText.getText();
        fileDialog.setFileName(string);
        fileDialog.setFilterExtensions(RESOURCE_EXTENSIONS);
        string = fileDialog.open();
        if (string != null) {
            this.sourceText.setText(string);
        }
    }

    private void handleExternalDirBrowse(Event event) {
        IPath iPath = this.queryForContainer(this.getSpecifiedContainer(), XRDImportWizardPage.getText(XRDexternalDirTitle), XRDImportWizardPage.getText(XRDexternalDirMsg));
        if (iPath != null) {
            IPath iPath2 = this.getResourcePath();
            int n = iPath.matchingFirstSegments(iPath2);
            iPath = iPath.removeFirstSegments(n);
            this.externalDirText.setText(iPath.makeRelative().toString());
        }
    }

    private void handleSourceChange(Event event) {
        String string;
        String string2;
        IPath iPath = this.getSourcePath();
        if (iPath.isEmpty()) {
            string2 = "";
            string = "";
        } else {
            string2 = iPath.removeFileExtension().lastSegment();
            string = String.valueOf(string2) + "." + DEFAULT_XRD_EXTENSION;
        }
        this.destText.setText(string);
        this.externalDirText.setText(string2);
    }

    protected boolean validateSourceGroup() {
        IPath iPath = this.getSourcePath();
        IPath iPath2 = this.getDestPath();
        if (iPath.isEmpty()) {
            this.setErrorMessage(XRDImportWizardPage.getText(XRDnoSourceMsg));
            return false;
        }
        if (iPath2.isEmpty()) {
            this.setErrorMessage(XRDImportWizardPage.getText(XRDnoDestinationMsg));
            return false;
        }
        if (!"XRD".equalsIgnoreCase(iPath2.getFileExtension())) {
            this.setErrorMessage(XRDImportWizardPage.getText(XRDwrongFileTypeMsg));
            return false;
        }
        return true;
    }

    protected boolean validateOptionsGroup() {
        return true;
    }

    public boolean finish() {
        IPath iPath = this.getTempPath();
        IPath iPath2 = this.getProjectPath();
        IPath iPath3 = this.getResourceFolder();
        IPath iPath4 = this.getSourcePath();
        IPath iPath5 = this.getDestPath();
        IPath iPath6 = iPath.append(iPath3);
        IPath iPath7 = this.getDataDirPath();
        iPath6.toFile().mkdirs();
        XRDGenerate xRDGenerate = new XRDGenerate(iPath4, iPath5, iPath6);
        xRDGenerate.setTarget(this.getComboOption(this.targetCombo));
        xRDGenerate.setLocale(this.getComboOption(this.localeCombo));
        xRDGenerate.setOptions(this.getGenerateOptions());
        xRDGenerate.setDataDirectory(iPath7);
        IStatus iStatus = xRDGenerate.execute();
        if (!iStatus.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)XRDImportWizardPage.getText(XRDimportFailedMsg), null, (IStatus)iStatus);
            return false;
        }
        ArrayList arrayList = new ArrayList();
        this.collectPaths(arrayList, iPath, iPath3);
        ImportOperation importOperation = new ImportOperation(iPath2, (Object)iPath.toFile(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (IOverwriteQuery)this, arrayList);
        importOperation.setContext(this.getShell());
        importOperation.setCreateContainerStructure(false);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)importOperation);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.displayErrorDialog(invocationTargetException.getTargetException());
            return false;
        }
        this.deleteAll(iPath.toFile());
        iStatus = importOperation.getStatus();
        if (!iStatus.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)XRDImportWizardPage.getText(XRDimportFailedMsg), null, (IStatus)iStatus);
            return false;
        }
        return true;
    }

    private String getComboOption(Combo combo) {
        String string = combo.getText();
        if (string == null) {
            return null;
        }
        return (String)combo.getData(string);
    }

    private int getGenerateOptions() {
        int n = 0;
        if (!this.noUnknownResourcesButton.getSelection()) {
            n |= 2;
        }
        if (this.rawResourcesButton.getSelection()) {
            n |= 4;
        }
        if (this.databaseHeaderButton.getSelection()) {
            n |= 8;
        }
        if (this.codeResourcesButton.getSelection()) {
            n |= 0x10;
        }
        if (this.externalFilesButton.getSelection()) {
            n |= 0x20;
        }
        return n;
    }

    public IPath getSourcePath() {
        return this.getPathFromText(this.sourceText);
    }

    public IPath getDestPath() {
        return this.getPathFromText(this.destText).makeRelative();
    }

    public IPath getDataDirPath() {
        return this.getPathFromText(this.externalDirText);
    }

    public IPath getProjectPath() {
        IPath iPath = this.getResourcePath();
        if (iPath == null) {
            return null;
        }
        return iPath.makeRelative().uptoSegment(1);
    }

    public IPath getResourceFolder() {
        IPath iPath = this.getResourcePath();
        if (iPath == null) {
            return null;
        }
        iPath = iPath.segmentCount() <= 1 ? this.getDefaultResourceFolder() : iPath.removeFirstSegments(1);
        return iPath;
    }

    private IPath getDefaultResourceFolder() {
        IPath iPath = this.getProjectPath();
        if (iPath == null) {
            return null;
        }
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (iWorkspaceRoot == null) {
            return null;
        }
        String string = iPath.lastSegment();
        if (string == null) {
            return null;
        }
        IProject iProject = iWorkspaceRoot.getProject(string);
        if (iProject == null) {
            return null;
        }
        try {
            IResource[] iResourceArray = iProject.members();
            int n = 0;
            while (n < iResourceArray.length) {
                IPath iPath2;
                if (iResourceArray[n].getType() == 2 && DEFAULT_XRD_FOLDER.equalsIgnoreCase((iPath2 = iResourceArray[n].getProjectRelativePath()).toString())) {
                    return new Path(iResourceArray[n].getName());
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return new Path(DEFAULT_XRD_FOLDER);
    }

    private IPath getParentPath(IPath iPath) {
        if (iPath == null) {
            return null;
        }
        int n = iPath.segmentCount();
        if (n > 1) {
            iPath = iPath.uptoSegment(n - 1);
        }
        return iPath;
    }

    private IPath getTempPath() {
        Path path = new Path(System.getProperty("java.io.tmpdir", File.pathSeparator));
        return path.append("palmsource-tmp-" + System.currentTimeMillis());
    }

    private void collectPaths(List list, IPath iPath, IPath iPath2) {
        File file = iPath.append(iPath2).toFile();
        list.add(file);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                this.collectPaths(list, iPath, iPath2.append(fileArray[n].getName()));
                ++n;
            }
        }
    }

    private void deleteAll(File file) {
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                this.deleteAll(fileArray[n]);
                ++n;
            }
            file.delete();
        }
    }

    protected void updateWidgetEnablements() {
        super.updateWidgetEnablements();
        if (this.databaseHeaderButton == null || this.codeResourcesButton == null) {
            return;
        }
        boolean bl = this.validateSourceType();
        this.databaseHeaderButton.setEnabled(bl);
        this.codeResourcesButton.setEnabled(bl);
        boolean bl2 = this.externalFilesButton.getSelection();
        this.externalDirLabel.setEnabled(bl2);
        this.externalDirText.setEnabled(bl2);
        this.externalDirButton.setEnabled(bl2);
        IPath iPath = this.getResourcePath();
        if (!iPath.equals((Object)this.project)) {
            if (iPath.segmentCount() == 1) {
                iPath = iPath.append(this.getDefaultResourceFolder());
                this.setContainerFieldValue(iPath.makeRelative().toString());
            }
            this.project = iPath;
        }
    }

    private boolean validateSourceType() {
        IPath iPath;
        String string;
        return this.sourceText != null && (string = (iPath = this.getSourcePath()).getFileExtension()) != null && string.equalsIgnoreCase("PRC");
    }

    protected void restoreWidgetValues() {
        super.restoreWidgetValues();
        this.noUnknownResourcesButton.setSelection(true);
        this.rawResourcesButton.setSelection(false);
        this.databaseHeaderButton.setSelection(false);
        this.codeResourcesButton.setSelection(false);
        this.externalFilesButton.setSelection(true);
    }

    protected void saveWidgetValues() {
        super.saveWidgetValues();
    }

    protected ITreeContentProvider getFileProvider() {
        return null;
    }

    protected ITreeContentProvider getFolderProvider() {
        return null;
    }

    private static String getText(String string) {
        return ResToolsPlugin.getResourceString(string);
    }
}

