/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.tools.psi.ui.wizards;

import com.palmsource.eclipse.palmoscore.CorePlugin;
import com.palmsource.eclipse.palmoscore.projects.IPalmOSConfiguration;
import com.palmsource.eclipse.palmoscore.projects.IPalmOSProject;
import com.palmsource.eclipse.palmoscore.projects.IPalmOSTarget;
import com.palmsource.eclipse.tools.psi.PSIPlugin;
import com.palmsource.eclipse.tools.psi.internal.tools.PSIPackageBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class PSIExportOptionsPage
extends WizardPage {
    private static final String PACKAGE_FILE_NAME = "package.psml";
    private static final String PACKAGE_EXTENSION = ".psml";
    private TreeViewer projectList;
    private IStructuredSelection selection;

    protected PSIExportOptionsPage(String string, IStructuredSelection iStructuredSelection) {
        super(string);
        this.selection = iStructuredSelection;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, true));
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 16384);
        label.setText(PSIPlugin.getResourceString("PSIExportOptionsPage.installDefFile"));
        this.createProjectList(composite2);
        this.setControl((Control)composite2);
    }

    public boolean isPageComplete() {
        return this.selectedProject() != null;
    }

    public boolean finish() {
        File file;
        Project project = this.selectedProject();
        if (project == null) {
            return false;
        }
        IPalmOSProject iPalmOSProject = CorePlugin.getPalmOSProject((IProject)project);
        if (iPalmOSProject == null) {
            return false;
        }
        IPath iPath = project.getLocation();
        IPath iPath2 = iPath.append(PACKAGE_FILE_NAME);
        File file2 = iPath2.toFile();
        if (!file2.exists() && !this.checkStatus(this.addPackageFile(file2, iPalmOSProject))) {
            return false;
        }
        IPalmOSConfiguration iPalmOSConfiguration = this.getConfiguration(iPalmOSProject);
        if (iPalmOSConfiguration == null) {
            this.postError((IStatus)new Status(4, "com.palmsource.eclipse.tools.psi.win32", -1, PSIPlugin.getResourceString("PSIExportOptionsPage.error.configError"), null));
            return false;
        }
        iPath = iPalmOSConfiguration.getOutputDirectory();
        if (!iPath.toFile().isDirectory()) {
            this.postError((IStatus)new Status(4, "com.palmsource.eclipse.tools.psi.win32", -1, PSIPlugin.getResourceString("PSIExportOptionsPage.error.noOutputDir"), null));
            return false;
        }
        try {
            file = File.createTempFile("pkg", PACKAGE_EXTENSION, iPath.toFile());
        }
        catch (IOException iOException) {
            this.postError((IStatus)new Status(4, "com.palmsource.eclipse.tools.psi.win32", -1, PSIPlugin.getResourceString("PSIExportOptionsPage.error.packageTmpFailed"), (Throwable)iOException));
            return false;
        }
        if (!this.checkStatus(this.copyFile(file2, file))) {
            return false;
        }
        PSIPackageBuilder pSIPackageBuilder = new PSIPackageBuilder();
        pSIPackageBuilder.setWorkdir(iPath);
        pSIPackageBuilder.setOptions(new String[]{file.getName()});
        boolean bl = this.checkStatus(pSIPackageBuilder.execute());
        file.delete();
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException coreException) {}
        return bl;
    }

    private void createProjectList(Composite composite) {
        this.projectList = new TreeViewer(composite, 2052);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        this.projectList.getTree().setLayoutData((Object)gridData);
        this.projectList.setContentProvider((IContentProvider)new PalmProjectContentProvider());
        this.projectList.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.projectList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (!selectionChangedEvent.getSelection().isEmpty()) {
                    PSIExportOptionsPage.this.setPageComplete(true);
                }
            }
        });
        this.projectList.setInput((Object)ResourcesPlugin.getWorkspace());
        this.projectList.setSelection((ISelection)this.selection, true);
    }

    private Project selectedProject() {
        Project project = null;
        ISelection iSelection = this.projectList.getSelection();
        if (iSelection == null || iSelection.equals(StructuredSelection.EMPTY)) {
            return null;
        }
        Object object = ((IStructuredSelection)iSelection).getFirstElement();
        if (object instanceof Project) {
            project = (Project)object;
        }
        return project;
    }

    private IStatus addPackageFile(File file, IPalmOSProject iPalmOSProject) {
        IPath iPath = iPalmOSProject.getProject().getLocation();
        IPalmOSConfiguration iPalmOSConfiguration = this.getConfiguration(iPalmOSProject);
        if (iPalmOSConfiguration == null) {
            return new Status(4, "com.palmsource.eclipse.tools.psi.win32", -1, PSIPlugin.getResourceString("PSIExportOptionsPage.error.configError"), null);
        }
        IPath iPath2 = iPalmOSConfiguration.getArtifact();
        String string = iPath2 != null ? iPath2.removeFileExtension().lastSegment() : iPalmOSProject.getProject().getName();
        PSIPackageBuilder pSIPackageBuilder = new PSIPackageBuilder();
        pSIPackageBuilder.setWorkdir(iPath);
        pSIPackageBuilder.setOptions(new String[]{"-s", string});
        IStatus iStatus = pSIPackageBuilder.execute();
        if (!iStatus.isOK()) {
            return iStatus;
        }
        File file2 = iPath.append(String.valueOf(string) + PACKAGE_EXTENSION).toFile();
        if (!file2.exists() || !file2.renameTo(file)) {
            return new Status(4, "com.palmsource.eclipse.tools.psi.win32", -1, PSIPlugin.getResourceString("PSIExportOptionsPage.error.packageDefFailed"), null);
        }
        return Status.OK_STATUS;
    }

    private IStatus copyFile(File file, File file2) {
        if (!file.exists()) {
            return new Status(4, "com.palmsource.eclipse.tools.psi.win32", -1, PSIPlugin.getResourceString("PSIExportOptionsPage.error.packageNotFound"), null);
        }
        if (!file2.getParentFile().exists()) {
            return new Status(4, "com.palmsource.eclipse.tools.psi.win32", -1, PSIPlugin.getResourceString("PSIExportOptionsPage.error.noOutputDir"), null);
        }
        try {
            int n;
            FileReader fileReader = new FileReader(file);
            FileWriter fileWriter = new FileWriter(file2);
            char[] cArray = new char[1024];
            while ((n = fileReader.read(cArray)) != -1) {
                fileWriter.write(cArray, 0, n);
            }
            fileReader.close();
            fileWriter.close();
        }
        catch (Exception exception) {
            return new Status(4, "com.palmsource.eclipse.tools.psi.win32", -1, PSIPlugin.getResourceString("PSIExportOptionsPage.error.packageCopyFailed"), (Throwable)exception);
        }
        return Status.OK_STATUS;
    }

    private IPalmOSConfiguration getConfiguration(IPalmOSProject iPalmOSProject) {
        IPalmOSTarget iPalmOSTarget = iPalmOSProject.getActiveTarget();
        return iPalmOSTarget != null ? iPalmOSTarget.getActiveConfiguration() : null;
    }

    private boolean checkStatus(IStatus iStatus) {
        if (!iStatus.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)PSIPlugin.getResourceString("PSIExportOptionsPage.error.exportFailed"), null, (IStatus)iStatus);
            return false;
        }
        return true;
    }

    private void postError(IStatus iStatus) {
        if (!iStatus.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)PSIPlugin.getResourceString("PSIExportOptionsPage.error.exportFailed"), null, (IStatus)iStatus);
        }
    }

    private class PalmProjectContentProvider
    extends WorkbenchContentProvider {
        PalmProjectContentProvider() {
        }

        public Object[] getChildren(Object object) {
            ArrayList<IProject> arrayList = new ArrayList<IProject>();
            if (object instanceof IWorkspace) {
                IWorkspace iWorkspace = (IWorkspace)object;
                IProject[] iProjectArray = iWorkspace.getRoot().getProjects();
                int n = 0;
                while (n < iProjectArray.length) {
                    IProject iProject = iProjectArray[n];
                    try {
                        IPalmOSProject iPalmOSProject;
                        if (iProject.hasNature("com.palmsource.eclipse.palmoscore.palmOSNature") && !(iPalmOSProject = CorePlugin.getPalmOSProject((IProject)iProject)).isStaticLibraryProject()) {
                            arrayList.add(iProject);
                        }
                    }
                    catch (Exception exception) {}
                    ++n;
                }
            }
            return arrayList.toArray(new Object[arrayList.size()]);
        }

        public Object getParent(Object object) {
            if (object instanceof IProject) {
                IProject iProject = (IProject)object;
                return iProject.getWorkspace();
            }
            return null;
        }
    }
}

