/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.IExternalScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.internal.core.BuildInfoFactory;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.cdt.make.internal.core.makefile.gnu.GNUMakefile;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathManager;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerConfigInfoFactory;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class MakeCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.make.core";
    public static final String MAKE_PROJECT_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".make";
    public static final String OLD_BUILDER_ID = "org.eclipse.cdt.core.cbuilder";
    public static final String EXTERNAL_SI_PROVIDER_SIMPLE_ID = "ExternalScannerInfoProvider";
    public static final String SI_CONSOLE_PARSER_SIMPLE_ID = "ScannerInfoConsoleParser";
    public static final String DEFAULT_EXTERNAL_SI_PROVIDER_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".DefaultExternalScannerInfoProvider";
    public static final String GCC_SPECS_CONSOLE_PARSER_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".GCCSpecsConsoleParser";
    public static final String GCC_SCANNER_INFO_CONSOLE_PARSER_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".GCCScannerInfoConsoleParser";
    private MakeTargetManager fTargetManager;
    private DiscoveredPathManager fDiscoveryPathManager;
    private static MakeCorePlugin plugin;
    private static final String SCANNER_CONFIG;

    static {
        SCANNER_CONFIG = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + "/debug/scdiscovery";
    }

    public MakeCorePlugin() {
        plugin = this;
    }

    public static MakeCorePlugin getDefault() {
        return plugin;
    }

    public static void log(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        Object object = null;
        object = throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : new Status(4, MakeCorePlugin.getUniqueIdentifier(), 0, throwable.getMessage(), throwable);
        MakeCorePlugin.log(object);
    }

    public static void log(IStatus iStatus) {
        ResourcesPlugin.getPlugin().getLog().log(iStatus);
    }

    public static String getUniqueIdentifier() {
        if (MakeCorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return MakeCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static IMakeBuilderInfo createBuildInfo(Preferences preferences, String string, boolean bl) {
        return BuildInfoFactory.create(preferences, string, bl);
    }

    public static IMakeBuilderInfo createBuildInfo(IProject iProject, String string) throws CoreException {
        return BuildInfoFactory.create(iProject, string);
    }

    public static IMakeBuilderInfo createBuildInfo(Map map, String string) {
        return BuildInfoFactory.create(map, string);
    }

    public IMakeTargetManager getTargetManager() {
        if (this.fTargetManager == null) {
            this.fTargetManager = new MakeTargetManager();
            this.fTargetManager.startup();
        }
        return this.fTargetManager;
    }

    public IMakefile createMakefile(IFile iFile) {
        GNUMakefile gNUMakefile = new GNUMakefile();
        try {
            String string;
            gNUMakefile.parse(iFile.getLocation().toOSString());
            String[] stringArray = gNUMakefile.getIncludeDirectories();
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string = iFile.getLocation().removeLastSegments(1).toOSString();
            gNUMakefile.setIncludeDirectories(stringArray2);
        }
        catch (IOException iOException) {}
        return gNUMakefile;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext bundleContext) throws Exception {
        try {
            if (this.fTargetManager != null) {
                this.fTargetManager.shutdown();
                this.fTargetManager = null;
            }
            if (this.fDiscoveryPathManager != null) {
                this.fDiscoveryPathManager.shutdown();
                this.fDiscoveryPathManager = null;
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.stop(bundleContext);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        super.stop(bundleContext);
    }

    public static IScannerConfigBuilderInfo createScannerConfigBuildInfo(Preferences preferences, String string, boolean bl) {
        return ScannerConfigInfoFactory.create(preferences, string, bl);
    }

    public static IScannerConfigBuilderInfo createScannerConfigBuildInfo(IProject iProject, String string) throws CoreException {
        return ScannerConfigInfoFactory.create(iProject, string);
    }

    public static IScannerConfigBuilderInfo createScannerConfigBuildInfo(Map map, String string) {
        return ScannerConfigInfoFactory.create(map, string);
    }

    public static IPath getWorkingDirectory() {
        return MakeCorePlugin.getDefault().getStateLocation();
    }

    public IDiscoveredPathManager getDiscoveryManager() {
        if (this.fDiscoveryPathManager == null) {
            this.fDiscoveryPathManager = new DiscoveredPathManager();
            this.fDiscoveryPathManager.startup();
        }
        return this.fDiscoveryPathManager;
    }

    public IExternalScannerInfoProvider getExternalScannerInfoProvider(String string) {
        try {
            IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, EXTERNAL_SI_PROVIDER_SIMPLE_ID);
            if (iExtensionPoint != null) {
                IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                int n = 0;
                while (n < iExtensionArray.length) {
                    String string2 = iExtensionArray[n].getUniqueIdentifier();
                    if (string2 != null && string2.equals(string)) {
                        IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                        int n2 = 0;
                        while (n2 < iConfigurationElementArray.length) {
                            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[n2].getChildren("run");
                            if (iConfigurationElementArray2.length > 0) {
                                IExternalScannerInfoProvider iExternalScannerInfoProvider = (IExternalScannerInfoProvider)iConfigurationElementArray2[0].createExecutableExtension("class");
                                return iExternalScannerInfoProvider;
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
            }
        }
        catch (CoreException coreException) {
            MakeCorePlugin.log(coreException);
        }
        return null;
    }

    public String[] getScannerInfoConsoleParserIds(String string) {
        IExtensionPoint iExtensionPoint;
        String[] stringArray = new String[]{};
        if (string == null || string.length() == 0) {
            string = "all";
        }
        if ((iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, SI_CONSOLE_PARSER_SIMPLE_ID)) != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            ArrayList<String> arrayList = new ArrayList<String>(iExtensionArray.length);
            int n = 0;
            while (n < iExtensionArray.length) {
                IConfigurationElement[] iConfigurationElementArray;
                String string2;
                String string3 = iExtensionArray[n].getUniqueIdentifier();
                if (string3 != null && (string2 = (iConfigurationElementArray = iExtensionArray[n].getConfigurationElements())[0].getAttribute("commandId")) != null && (string2.equals(string) || string2.equals("all"))) {
                    arrayList.add(string3);
                }
                ++n;
            }
            return arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public IScannerInfoConsoleParser getScannerInfoConsoleParser(String string) {
        try {
            IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, SI_CONSOLE_PARSER_SIMPLE_ID);
            if (iExtensionPoint != null) {
                IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                int n = 0;
                while (n < iExtensionArray.length) {
                    String string2 = iExtensionArray[n].getUniqueIdentifier();
                    if (string2 != null && string2.equals(string)) {
                        IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                        IScannerInfoConsoleParser iScannerInfoConsoleParser = (IScannerInfoConsoleParser)iConfigurationElementArray[0].createExecutableExtension("class");
                        return iScannerInfoConsoleParser;
                    }
                    ++n;
                }
            }
        }
        catch (CoreException coreException) {
            MakeCorePlugin.log(coreException);
        }
        return null;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.configurePluginDebugOptions();
    }

    private void configurePluginDebugOptions() {
        String string;
        if (this.isDebugging() && (string = Platform.getDebugOption((String)SCANNER_CONFIG)) != null) {
            TraceUtil.SCANNER_CONFIG = string.equalsIgnoreCase("true");
        }
    }
}

