/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.MakeBuilder;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class MakeProjectNature
implements IProjectNature {
    public static final String NATURE_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".makeNature";
    private IProject fProject;

    public static void addNature(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        String[] stringArray = iProjectDescription.getNatureIds();
        int n = 0;
        while (n < stringArray.length) {
            if (NATURE_ID.equals(stringArray[n])) {
                return;
            }
            ++n;
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = NATURE_ID;
        iProjectDescription.setNatureIds(stringArray2);
        iProject.setDescription(iProjectDescription, iProgressMonitor);
    }

    public static ICommand getBuildSpec(IProjectDescription iProjectDescription, String string) throws CoreException {
        ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
        int n = 0;
        while (n < iCommandArray.length) {
            if (iCommandArray[n].getBuilderName().equals(string)) {
                return iCommandArray[n];
            }
            ++n;
        }
        return null;
    }

    public static IProjectDescription setBuildSpec(IProjectDescription iProjectDescription, ICommand iCommand) throws CoreException {
        ICommand[] iCommandArray;
        ICommand[] iCommandArray2 = iProjectDescription.getBuildSpec();
        ICommand iCommand2 = MakeProjectNature.getBuildSpec(iProjectDescription, iCommand.getBuilderName());
        if (iCommand2 == null) {
            iCommandArray = new ICommand[iCommandArray2.length + 1];
            System.arraycopy(iCommandArray2, 0, iCommandArray, 1, iCommandArray2.length);
            iCommandArray[0] = iCommand;
        } else {
            int n = 0;
            int n2 = iCommandArray2.length;
            while (n < n2) {
                if (iCommandArray2[n].getBuilderName().equals(iCommand2.getBuilderName())) {
                    iCommandArray2[n] = iCommand;
                    break;
                }
                ++n;
            }
            iCommandArray = iCommandArray2;
        }
        iProjectDescription.setBuildSpec(iCommandArray);
        return iProjectDescription;
    }

    public static void addToBuildSpec(IProject iProject, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
        boolean bl = false;
        int n = 0;
        while (n < iCommandArray.length) {
            if (iCommandArray[n].getBuilderName().equals(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            ICommand iCommand = iProjectDescription.newCommand();
            iCommand.setBuilderName(string);
            ICommand[] iCommandArray2 = new ICommand[iCommandArray.length + 1];
            System.arraycopy(iCommandArray, 0, iCommandArray2, 1, iCommandArray.length);
            iCommandArray2[0] = iCommand;
            iProjectDescription.setBuildSpec(iCommandArray2);
            iProject.setDescription(iProjectDescription, iProgressMonitor);
        }
    }

    public static void removeFromBuildSpec(IProject iProject, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
        int n = 0;
        while (n < iCommandArray.length) {
            if (iCommandArray[n].getBuilderName().equals(string)) {
                ICommand[] iCommandArray2 = new ICommand[iCommandArray.length - 1];
                System.arraycopy(iCommandArray, 0, iCommandArray2, 0, n);
                System.arraycopy(iCommandArray, n + 1, iCommandArray2, n, iCommandArray.length - n - 1);
                iProjectDescription.setBuildSpec(iCommandArray2);
                break;
            }
            ++n;
        }
        iProject.setDescription(iProjectDescription, iProgressMonitor);
    }

    public void addBuildSpec() throws CoreException {
        MakeProjectNature.addToBuildSpec(this.getProject(), MakeBuilder.BUILDER_ID, null);
    }

    public void configure() throws CoreException {
        this.addBuildSpec();
        IMakeBuilderInfo iMakeBuilderInfo = MakeCorePlugin.createBuildInfo(MakeCorePlugin.getDefault().getPluginPreferences(), MakeBuilder.BUILDER_ID, false);
        IMakeBuilderInfo iMakeBuilderInfo2 = MakeCorePlugin.createBuildInfo(this.getProject(), MakeBuilder.BUILDER_ID);
        iMakeBuilderInfo2.setBuildLocation(iMakeBuilderInfo.getBuildLocation());
        iMakeBuilderInfo2.setUseDefaultBuildCmd(iMakeBuilderInfo.isDefaultBuildCmd());
        iMakeBuilderInfo2.setStopOnError(iMakeBuilderInfo.isStopOnError());
        iMakeBuilderInfo2.setBuildCommand(iMakeBuilderInfo.getBuildCommand());
        iMakeBuilderInfo2.setAutoBuildEnable(iMakeBuilderInfo.isAutoBuildEnable());
        iMakeBuilderInfo2.setAutoBuildTarget(iMakeBuilderInfo.getAutoBuildTarget());
        iMakeBuilderInfo2.setIncrementalBuildEnable(iMakeBuilderInfo.isIncrementalBuildEnabled());
        iMakeBuilderInfo2.setIncrementalBuildTarget(iMakeBuilderInfo.getIncrementalBuildTarget());
        iMakeBuilderInfo2.setFullBuildEnable(iMakeBuilderInfo.isFullBuildEnabled());
        iMakeBuilderInfo2.setFullBuildTarget(iMakeBuilderInfo.getFullBuildTarget());
        iMakeBuilderInfo2.setCleanBuildEnable(iMakeBuilderInfo.isCleanBuildEnabled());
        iMakeBuilderInfo2.setCleanBuildTarget(iMakeBuilderInfo.getCleanBuildTarget());
        iMakeBuilderInfo2.setErrorParsers(iMakeBuilderInfo.getErrorParsers());
    }

    public void removeBuildSpec() throws CoreException {
        MakeProjectNature.removeFromBuildSpec(this.getProject(), MakeBuilder.BUILDER_ID, null);
    }

    public void deconfigure() throws CoreException {
        this.removeBuildSpec();
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject iProject) {
        this.fProject = iProject;
    }
}

