/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.resources.ScannerProvider;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeScannerInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MakeScannerProvider
extends ScannerProvider {
    public static final String INTERFACE_IDENTITY = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".MakeScannerProvider";
    private static final QualifiedName scannerInfoProperty = new QualifiedName(MakeCorePlugin.getUniqueIdentifier(), "makeBuildInfo");
    private static final String CDESCRIPTOR_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".makeScannerInfo";
    public static final String INCLUDE_PATH = "includePath";
    public static final String PATH = "path";
    public static final String DEFINED_SYMBOL = "definedSymbol";
    public static final String SYMBOL = "symbol";
    private static MakeScannerProvider defaultProvider;

    public static MakeScannerProvider getDefault() {
        if (defaultProvider == null) {
            defaultProvider = new MakeScannerProvider();
        }
        return defaultProvider;
    }

    public MakeScannerInfo getMakeScannerInfo(IProject iProject, boolean bl) throws CoreException {
        MakeScannerInfo makeScannerInfo = null;
        makeScannerInfo = (MakeScannerInfo)iProject.getSessionProperty(scannerInfoProperty);
        if (makeScannerInfo != null) {
            return makeScannerInfo;
        }
        makeScannerInfo = this.loadScannerInfo(iProject);
        if (makeScannerInfo != null && bl) {
            iProject.setSessionProperty(scannerInfoProperty, (Object)makeScannerInfo);
        }
        if (makeScannerInfo != null) {
            MakeScannerProvider.updateScannerInfo(makeScannerInfo);
        }
        ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iProject);
        iCDescriptor.remove("org.eclipse.cdt.core.ScannerInfoProvider");
        return makeScannerInfo;
    }

    public IScannerInfo getScannerInformation(IResource iResource) {
        try {
            this.getMakeScannerInfo(iResource.getProject(), true);
        }
        catch (CoreException coreException) {}
        return super.getScannerInformation(iResource);
    }

    private MakeScannerInfo loadScannerInfo(IProject iProject) throws CoreException {
        ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iProject);
        Node node = iCDescriptor.getProjectData(CDESCRIPTOR_ID).getFirstChild();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (node != null) {
            if (node.getNodeName().equals(INCLUDE_PATH)) {
                arrayList.add(((Element)node).getAttribute(PATH));
            } else if (node.getNodeName().equals(DEFINED_SYMBOL)) {
                arrayList2.add(((Element)node).getAttribute(SYMBOL));
            }
            node = node.getNextSibling();
        }
        MakeScannerInfo makeScannerInfo = new MakeScannerInfo(iProject);
        makeScannerInfo.setIncludePaths(arrayList.toArray(new String[arrayList.size()]));
        makeScannerInfo.setPreprocessorSymbols(arrayList2.toArray(new String[arrayList2.size()]));
        return makeScannerInfo;
    }

    private static void migrateToCPathEntries(MakeScannerInfo makeScannerInfo) throws CoreException {
        IIncludeEntry iIncludeEntry;
        int n;
        Map map = makeScannerInfo.getDefinedSymbols();
        String[] stringArray = makeScannerInfo.getIncludePaths();
        ICProject iCProject = CoreModel.getDefault().create(makeScannerInfo.getProject());
        IPathEntry[] iPathEntryArray = iCProject.getRawPathEntries();
        ArrayList<IPathEntry> arrayList = new ArrayList<IPathEntry>(Arrays.asList(iPathEntryArray));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            n = ((IPathEntry)iterator.next()).getEntryKind();
            if (n != 4 && n != 6) continue;
            iterator.remove();
        }
        n = 0;
        while (n < stringArray.length) {
            iIncludeEntry = CoreModel.newIncludeEntry((IPath)makeScannerInfo.getProject().getFullPath(), null, (IPath)new Path(stringArray[n]));
            if (!arrayList.contains(iIncludeEntry)) {
                arrayList.add((IPathEntry)iIncludeEntry);
            }
            ++n;
        }
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            iIncludeEntry = iterator2.next();
            IMacroEntry iMacroEntry = CoreModel.newMacroEntry((IPath)makeScannerInfo.getProject().getFullPath(), (String)((String)iIncludeEntry.getKey()), (String)((String)iIncludeEntry.getValue()));
            if (arrayList.contains(iMacroEntry)) continue;
            arrayList.add((IPathEntry)iMacroEntry);
        }
        iCProject.setRawPathEntries(arrayList.toArray(new IPathEntry[arrayList.size()]), null);
    }

    public static void removeScannerInfo(IResource iResource) {
        try {
            iResource.getProject().setSessionProperty(scannerInfoProperty, null);
        }
        catch (CoreException coreException) {}
    }

    public static void updateScannerInfo(final MakeScannerInfo makeScannerInfo) throws CoreException {
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                IProject iProject = makeScannerInfo.getProject();
                ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iProject);
                Element element = iCDescriptor.getProjectData(CDESCRIPTOR_ID);
                Node node = element.getFirstChild();
                while (node != null) {
                    element.removeChild(node);
                    node = element.getFirstChild();
                }
                iCDescriptor.saveProjectData();
                MakeScannerProvider.migrateToCPathEntries(makeScannerInfo);
            }
        }, null);
    }
}

