/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core.scannerconfig;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.make.core.MakeScannerInfo;
import org.eclipse.cdt.make.core.scannerconfig.DiscoveredScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class DiscoveredScannerInfo
implements IScannerInfo {
    private IProject project;
    private LinkedHashMap discoveredPaths;
    private LinkedHashMap discoveredSymbols;
    private ArrayList activePaths;
    private ArrayList removedPaths;
    private ArrayList activeSymbols;
    private ArrayList removedSymbols;
    private MakeScannerInfo userInfo;

    public DiscoveredScannerInfo(IProject iProject) {
        this.project = iProject;
    }

    public IProject getProject() {
        return this.project;
    }

    public synchronized Map getDefinedSymbols() {
        Map map = ScannerConfigUtil.scSymbolEntryMap2Map(this.discoveredSymbols);
        map.putAll(this.userInfo.getDefinedSymbols());
        return map;
    }

    public synchronized String[] getIncludePaths() {
        String[] stringArray = new String[this.getUserIncludePaths().length + this.getActiveIncludePaths().length];
        System.arraycopy(this.getUserIncludePaths(), 0, stringArray, 0, this.getUserIncludePaths().length);
        System.arraycopy(this.getActiveIncludePaths(), 0, stringArray, this.getUserIncludePaths().length, this.getActiveIncludePaths().length);
        return stringArray;
    }

    public MakeScannerInfo getUserScannerInfo() {
        return this.userInfo;
    }

    public synchronized void setUserScannerInfo(MakeScannerInfo makeScannerInfo) {
        this.userInfo = makeScannerInfo;
    }

    public LinkedHashMap getDiscoveredIncludePaths() {
        if (this.discoveredPaths == null) {
            return new LinkedHashMap();
        }
        return new LinkedHashMap(this.discoveredPaths);
    }

    public synchronized void setDiscoveredIncludePaths(LinkedHashMap linkedHashMap) {
        this.discoveredPaths = new LinkedHashMap(linkedHashMap);
        this.createPathLists();
    }

    private void createPathLists() {
        List list = this.getActivePathList();
        list.clear();
        List list2 = this.getRemovedPathList();
        list2.clear();
        Iterator iterator = this.discoveredPaths.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Boolean bl = (Boolean)this.discoveredPaths.get(string);
            if (bl == null || !bl.booleanValue()) {
                list.add(string);
                continue;
            }
            list2.add(string);
        }
    }

    public LinkedHashMap getDiscoveredSymbolDefinitions() {
        if (this.discoveredSymbols == null) {
            return new LinkedHashMap();
        }
        return new LinkedHashMap(this.discoveredSymbols);
    }

    public synchronized void setDiscoveredSymbolDefinitions(LinkedHashMap linkedHashMap) {
        this.discoveredSymbols = new LinkedHashMap(linkedHashMap);
        this.createSymbolsLists();
    }

    private void createSymbolsLists() {
        List list = this.getActiveSymbolsList();
        list.clear();
        List list2 = this.getRemovedSymbolsList();
        list2.clear();
        list.addAll(ScannerConfigUtil.scSymbolsSymbolEntryMap2List(this.discoveredSymbols, true));
        list2.addAll(ScannerConfigUtil.scSymbolsSymbolEntryMap2List(this.discoveredSymbols, false));
    }

    public String[] getUserIncludePaths() {
        if (this.userInfo == null) {
            return new String[0];
        }
        return this.userInfo.getIncludePaths();
    }

    public String[] getActiveIncludePaths() {
        return this.getActivePathList().toArray(new String[this.getActivePathList().size()]);
    }

    public String[] getRemovedIncludePaths() {
        return this.getRemovedPathList().toArray(new String[this.getRemovedPathList().size()]);
    }

    public String[] getUserSymbolDefinitions() {
        if (this.userInfo == null) {
            return new String[0];
        }
        return this.userInfo.getPreprocessorSymbols();
    }

    public String[] getActiveSymbolDefinitions() {
        return this.getActiveSymbolsList().toArray(new String[this.getActiveSymbolsList().size()]);
    }

    public String[] getRemovedSymbolDefinitions() {
        return this.getRemovedSymbolsList().toArray(new String[this.getRemovedSymbolsList().size()]);
    }

    public String[] getPreprocessorSymbols() {
        String[] stringArray = this.getUserSymbolDefinitions();
        String[] stringArray2 = this.getActiveSymbolDefinitions();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    private List getActivePathList() {
        if (this.activePaths == null) {
            this.activePaths = new ArrayList();
        }
        return this.activePaths;
    }

    private List getRemovedPathList() {
        if (this.removedPaths == null) {
            this.removedPaths = new ArrayList();
        }
        return this.removedPaths;
    }

    private List getActiveSymbolsList() {
        if (this.activeSymbols == null) {
            this.activeSymbols = new ArrayList();
        }
        return this.activeSymbols;
    }

    private List getRemovedSymbolsList() {
        if (this.removedSymbols == null) {
            this.removedSymbols = new ArrayList();
        }
        return this.removedSymbols;
    }

    public void update() throws CoreException {
        DiscoveredScannerInfoProvider.updateScannerInfo(this);
    }

    public void setUserIncludePaths(List list) {
        this.userInfo.setIncludePaths(list.toArray(new String[list.size()]));
    }

    public void setUserDefinedSymbols(List list) {
        this.userInfo.setPreprocessorSymbols(list.toArray(new String[list.size()]));
    }
}

