/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core.scannerconfig;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.resources.ScannerProvider;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeScannerInfo;
import org.eclipse.cdt.make.core.MakeScannerProvider;
import org.eclipse.cdt.make.core.scannerconfig.DiscoveredScannerInfo;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;

public class DiscoveredScannerInfoProvider
extends ScannerProvider {
    public static final String INTERFACE_IDENTITY = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".DiscoveredScannerInfoProvider";
    private static final QualifiedName scannerInfoProperty = new QualifiedName(MakeCorePlugin.getUniqueIdentifier(), "discoveredMakeBuildInfo");
    private static DiscoveredScannerInfoProvider instance;

    public static DiscoveredScannerInfoProvider getDefault() {
        if (instance == null) {
            instance = new DiscoveredScannerInfoProvider();
        }
        return instance;
    }

    public IScannerInfo getScannerInformation(IResource iResource) {
        try {
            this.getDiscoveredScannerInfo(iResource.getProject(), true);
        }
        catch (CoreException coreException) {}
        return super.getScannerInformation(iResource);
    }

    public void subscribe(IResource iResource, IScannerInfoChangeListener iScannerInfoChangeListener) {
        super.subscribe(iResource, iScannerInfoChangeListener);
    }

    public void unsubscribe(IResource iResource, IScannerInfoChangeListener iScannerInfoChangeListener) {
        super.unsubscribe(iResource, iScannerInfoChangeListener);
    }

    public DiscoveredScannerInfo getDiscoveredScannerInfo(IProject iProject, boolean bl) throws CoreException {
        DiscoveredScannerInfo discoveredScannerInfo = null;
        discoveredScannerInfo = (DiscoveredScannerInfo)iProject.getSessionProperty(scannerInfoProperty);
        MakeScannerInfo makeScannerInfo = MakeScannerProvider.getDefault().getMakeScannerInfo(iProject, bl);
        if (discoveredScannerInfo == null) {
            ICDescriptor iCDescriptor;
            ArrayList<IPathEntry> arrayList;
            discoveredScannerInfo = new DiscoveredScannerInfo(iProject);
            discoveredScannerInfo.setUserScannerInfo(makeScannerInfo);
            IContainerEntry iContainerEntry = CoreModel.newContainerEntry((IPath)DiscoveredPathContainer.CONTAINER_ID);
            ICProject iCProject = CoreModel.getDefault().create(iProject);
            if (iCProject != null && !(arrayList = new ArrayList<IPathEntry>(Arrays.asList(iCDescriptor = iCProject.getRawPathEntries()))).contains(iContainerEntry)) {
                arrayList.add((IPathEntry)iContainerEntry);
                iCProject.setRawPathEntries(arrayList.toArray(new IPathEntry[arrayList.size()]), null);
            }
            iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iProject);
            iCDescriptor.remove("org.eclipse.cdt.core.ScannerInfoProvider");
            iProject.setSessionProperty(scannerInfoProperty, (Object)discoveredScannerInfo);
        }
        return discoveredScannerInfo;
    }

    public static void removeScannerInfo(IResource iResource) {
        try {
            iResource.getProject().setSessionProperty(scannerInfoProperty, null);
        }
        catch (CoreException coreException) {}
    }

    static void updateScannerInfo(DiscoveredScannerInfo discoveredScannerInfo) throws CoreException {
    }
}

