/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core.scannerconfig;

import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigBuilder;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;

public class ScannerConfigNature
implements IProjectNature {
    public static final String NATURE_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".ScannerConfigNature";
    private IProject fProject;

    public void configure() throws CoreException {
        IProjectDescription iProjectDescription = this.getProject().getDescription();
        ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
        int n = 0;
        while (n < iCommandArray.length) {
            if (iCommandArray[n].getBuilderName().equals(ScannerConfigBuilder.BUILDER_ID)) {
                return;
            }
            ++n;
        }
        ICommand iCommand = iProjectDescription.newCommand();
        iCommand.setBuilderName(ScannerConfigBuilder.BUILDER_ID);
        ICommand[] iCommandArray2 = new ICommand[iCommandArray.length + 1];
        System.arraycopy(iCommandArray, 0, iCommandArray2, 0, iCommandArray.length);
        iCommandArray2[iCommandArray.length] = iCommand;
        iProjectDescription.setBuildSpec(iCommandArray2);
        this.getProject().setDescription(iProjectDescription, null);
    }

    public void deconfigure() throws CoreException {
        IProjectDescription iProjectDescription = this.getProject().getDescription();
        ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
        int n = 0;
        while (n < iCommandArray.length) {
            if (iCommandArray[n].getBuilderName().equals(ScannerConfigBuilder.BUILDER_ID)) {
                ICommand[] iCommandArray2 = new ICommand[iCommandArray.length - 1];
                System.arraycopy(iCommandArray, 0, iCommandArray2, 0, n);
                System.arraycopy(iCommandArray, n + 1, iCommandArray2, n, iCommandArray.length - n - 1);
                iProjectDescription.setBuildSpec(iCommandArray2);
                break;
            }
            ++n;
        }
        this.getProject().setDescription(iProjectDescription, null);
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject iProject) {
        this.fProject = iProject;
    }

    public static void addScannerConfigNature(IProject iProject) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        if (iProjectDescription.hasNature(NATURE_ID)) {
            return;
        }
        String[] stringArray = iProjectDescription.getNatureIds();
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = NATURE_ID;
        iProjectDescription.setNatureIds(stringArray2);
        iProject.setDescription(iProjectDescription, null);
    }

    public static void removeScannerConfigNature(IProject iProject) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        if (!iProjectDescription.hasNature(NATURE_ID)) {
            return;
        }
        String[] stringArray = iProjectDescription.getNatureIds();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(NATURE_ID)) {
                String[] stringArray2 = new String[stringArray.length - 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                System.arraycopy(stringArray, n + 1, stringArray2, n, stringArray.length - n - 1);
                iProjectDescription.setNatureIds(stringArray2);
                iProject.setDescription(iProjectDescription, null);
            }
            ++n;
        }
    }

    public static ICommand getBuildSpec(IProjectDescription iProjectDescription, String string) throws CoreException {
        ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
        int n = 0;
        while (n < iCommandArray.length) {
            if (iCommandArray[n].getBuilderName().equals(string)) {
                return iCommandArray[n];
            }
            ++n;
        }
        return null;
    }

    public static IProjectDescription setBuildSpec(IProjectDescription iProjectDescription, ICommand iCommand) throws CoreException {
        ICommand[] iCommandArray;
        ICommand[] iCommandArray2 = iProjectDescription.getBuildSpec();
        ICommand iCommand2 = ScannerConfigNature.getBuildSpec(iProjectDescription, iCommand.getBuilderName());
        if (iCommand2 == null) {
            iCommandArray = new ICommand[iCommandArray2.length + 1];
            System.arraycopy(iCommandArray2, 0, iCommandArray, 0, iCommandArray2.length);
            iCommandArray[iCommandArray2.length] = iCommand;
        } else {
            int n = 0;
            while (n < iCommandArray2.length) {
                if (iCommandArray2[n] == iCommand2) {
                    iCommandArray2[n] = iCommand;
                    break;
                }
                ++n;
            }
            iCommandArray = iCommandArray2;
        }
        iProjectDescription.setBuildSpec(iCommandArray);
        return iProjectDescription;
    }
}

