/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core.scannerconfig;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.SymbolEntry;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;

public final class ScannerConfigUtil {
    private static Random sRandom = new Random();
    private static final QualifiedName discoveredScannerConfigFileNameProperty = new QualifiedName(MakeCorePlugin.getUniqueIdentifier(), "discoveredScannerConfigFileName");

    public static boolean scAddSymbolsList2SymbolEntryMap(Map map, List list, boolean bl) {
        boolean bl2 = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            String string3 = null;
            int n = string2.indexOf("=");
            if (n != -1) {
                string = string2.substring(0, n).trim();
                string3 = string2.substring(n + 1).trim();
            } else {
                string = string2.trim();
            }
            SymbolEntry symbolEntry = (SymbolEntry)map.get(string);
            if (symbolEntry == null) {
                symbolEntry = new SymbolEntry(string, string3, true);
                bl2 = true;
            } else {
                bl2 |= symbolEntry.add(string3, bl);
            }
            map.put(string, symbolEntry);
        }
        return bl2;
    }

    public static List scSymbolsSymbolEntryMap2List(Map map, boolean bl) {
        Set set = map.entrySet();
        ArrayList arrayList = new ArrayList(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            SymbolEntry symbolEntry = (SymbolEntry)iterator.next().getValue();
            if (bl) {
                arrayList.addAll(symbolEntry.getActiveRaw());
                continue;
            }
            arrayList.addAll(symbolEntry.getRemovedRaw());
        }
        return arrayList;
    }

    public static Map scSymbolEntryMap2Map(Map map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            SymbolEntry symbolEntry = (SymbolEntry)map.get(string);
            Iterator iterator2 = symbolEntry.getValuesOnly(true).iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                hashMap.put(string, string2);
            }
        }
        return hashMap;
    }

    public static boolean scAddSymbolString2SymbolEntryMap(Map map, String string, boolean bl) {
        String string2;
        boolean bl2 = false;
        String string3 = null;
        int n = string.indexOf("=");
        if (n != -1) {
            string2 = string.substring(0, n).trim();
            string3 = string.substring(n + 1).trim();
        } else {
            string2 = string.trim();
        }
        SymbolEntry symbolEntry = (SymbolEntry)map.get(string2);
        if (symbolEntry == null) {
            symbolEntry = new SymbolEntry(string2, string3, bl);
            bl2 = true;
        } else {
            bl2 |= symbolEntry.add(string3, bl);
        }
        map.put(string2, symbolEntry);
        return bl2;
    }

    public static boolean scAddSymbolEntryMap2SymbolEntryMap(Map map, Map map2) {
        boolean bl = false;
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            SymbolEntry symbolEntry;
            String string = (String)iterator.next();
            if (map.keySet().contains(string)) {
                Object object;
                symbolEntry = (SymbolEntry)map.get(string);
                SymbolEntry symbolEntry2 = (SymbolEntry)map2.get(string);
                List list = symbolEntry.getActiveRaw();
                Object object2 = symbolEntry2.getActiveRaw().iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    if (list.contains(object)) continue;
                    symbolEntry.add((String)object, true);
                    bl |= true;
                }
                object2 = symbolEntry.getRemovedRaw();
                object = symbolEntry2.getRemovedRaw().iterator();
                while (object.hasNext()) {
                    String string2 = (String)object.next();
                    if (object2.contains(string2)) continue;
                    symbolEntry.add(string2, false);
                    bl |= true;
                }
                continue;
            }
            symbolEntry = (SymbolEntry)map2.get(string);
            map.put(string, symbolEntry);
            bl |= true;
        }
        return bl;
    }

    public static String getSymbolKey(String string) {
        int n = string.indexOf(61);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getSymbolValue(String string) {
        int n = string.indexOf(61);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return null;
    }

    public static void removeSymbolEntryValue(String string, Map map) {
        String string2 = ScannerConfigUtil.getSymbolKey(string);
        String string3 = ScannerConfigUtil.getSymbolValue(string);
        SymbolEntry symbolEntry = (SymbolEntry)map.get(string2);
        if (symbolEntry != null) {
            symbolEntry.remove(string3);
            if (symbolEntry.numberOfValues() == 0) {
                map.remove(string2);
            }
        }
    }

    public static LinkedHashMap swapIncludePaths(LinkedHashMap linkedHashMap, int n, int n2) {
        int n3 = linkedHashMap.size();
        if (n == n2 || n < 0 || n >= n3 || n2 < 0 || n2 >= n3) {
            return linkedHashMap;
        }
        ArrayList arrayList = new ArrayList(linkedHashMap.keySet());
        String string = (String)arrayList.get(n);
        String string2 = (String)arrayList.get(n2);
        arrayList.set(n, string2);
        arrayList.set(n2, string);
        LinkedHashMap linkedHashMap2 = new LinkedHashMap(linkedHashMap.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            linkedHashMap2.put(string3, linkedHashMap.get(string3));
        }
        return linkedHashMap2;
    }

    public static String[] tokenizeStringWithQuotes(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = string.split(string2);
        int n = 0;
        while (n < stringArray.length) {
            if (n % 2 == 0) {
                String[] stringArray2 = stringArray[n].split("\\s");
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    if (stringArray2[n2].length() > 0) {
                        arrayList.add(stringArray2[n2]);
                    }
                    ++n2;
                }
            } else {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] iPathArray2StringArray(IPath[] iPathArray) {
        String[] stringArray = new String[iPathArray.length];
        int n = 0;
        while (n < iPathArray.length) {
            stringArray[n] = iPathArray[n].toString();
            ++n;
        }
        return stringArray;
    }

    public static IPath getDiscoveredScannerConfigStore(IProject iProject, boolean bl) {
        File file;
        String string = null;
        try {
            string = iProject.getPersistentProperty(discoveredScannerConfigFileNameProperty);
        }
        catch (CoreException coreException) {
            MakeCorePlugin.log(coreException.getStatus());
        }
        if (string == null) {
            string = String.valueOf(String.valueOf(sRandom.nextLong())) + ".sc";
            try {
                iProject.setPersistentProperty(discoveredScannerConfigFileNameProperty, string);
            }
            catch (CoreException coreException) {
                MakeCorePlugin.log(coreException.getStatus());
            }
        }
        IPath iPath = MakeCorePlugin.getWorkingDirectory();
        iPath = iPath.append(string);
        if (bl && (file = iPath.toFile()).exists()) {
            file.delete();
        }
        return iPath;
    }
}

