/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICOwner;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;

public class MakeProject
implements ICOwner {
    public void configure(ICDescriptor iCDescriptor) throws CoreException {
        iCDescriptor.remove("org.eclipse.cdt.core.ScannerInfoProvider");
        iCDescriptor.remove("org.eclipse.cdt.core.CBuildModel");
        this.updateBinaryParsers(iCDescriptor);
    }

    public void update(ICDescriptor iCDescriptor, String string) throws CoreException {
        if (string.equals("org.eclipse.cdt.core.BinaryParser")) {
            this.updateBinaryParsers(iCDescriptor);
        }
    }

    private void updateBinaryParsers(ICDescriptor iCDescriptor) throws CoreException {
        iCDescriptor.remove("org.eclipse.cdt.core.BinaryParser");
        Preferences preferences = MakeCorePlugin.getDefault().getPluginPreferences();
        String string = preferences.getString("binaryparser");
        if (string != null && string.length() != 0) {
            String[] stringArray = this.parseStringToArray(string);
            int n = 0;
            while (n < stringArray.length) {
                iCDescriptor.create("org.eclipse.cdt.core.BinaryParser", stringArray[n]);
                ++n;
            }
        }
    }

    private String[] parseStringToArray(String string) {
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            ArrayList<String> arrayList = new ArrayList<String>(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreElements()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return new String[0];
    }
}

