/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class MakeRecon
extends OutputStream {
    IPath make;
    String[] args;
    String[] environ;
    IPath directory;
    IProgressMonitor monitor;
    OutputStream console;
    MyList log;
    StringBuffer currentLine;

    public MakeRecon(IPath iPath, String[] stringArray, String[] stringArray2, IPath iPath2, IProgressMonitor iProgressMonitor, OutputStream outputStream) {
        this(iPath, new String[]{"-n"}, stringArray, stringArray2, iPath2, iProgressMonitor, outputStream);
    }

    public MakeRecon(IPath iPath, String[] stringArray, String[] stringArray2, String[] stringArray3, IPath iPath2, IProgressMonitor iProgressMonitor, OutputStream outputStream) {
        String[] stringArray4;
        this.make = iPath;
        this.args = new String[0];
        if (stringArray != null) {
            stringArray4 = new String[this.args.length + stringArray.length];
            System.arraycopy(this.args, 0, stringArray4, 0, this.args.length);
            System.arraycopy(stringArray, 0, stringArray4, this.args.length, stringArray.length);
            this.args = stringArray4;
        }
        if (stringArray2 != null) {
            stringArray4 = new String[this.args.length + stringArray2.length];
            System.arraycopy(this.args, 0, stringArray4, 0, this.args.length);
            System.arraycopy(stringArray2, 0, stringArray4, this.args.length, stringArray2.length);
            this.args = stringArray4;
        }
        this.environ = stringArray3;
        this.directory = iPath2;
        this.monitor = iProgressMonitor;
        this.console = outputStream;
        this.currentLine = new StringBuffer();
        this.log = new MyList();
        this.invokeMakeRecon();
    }

    private void invokeMakeRecon() {
        int n = 0;
        String[] stringArray = new String[this.args.length + 1];
        stringArray[0] = this.make.toOSString();
        System.arraycopy(this.args, 0, stringArray, 1, this.args.length);
        try {
            Process process = ProcessFactory.getFactory().exec(stringArray, this.environ, this.directory.toFile());
            InputStream inputStream = process.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    this.log.add(string);
                    ++n;
                }
            }
            catch (IOException iOException) {}
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            process.destroy();
            this.log.trimToSize();
        }
        catch (IOException iOException) {
            n = -1;
        }
        this.monitor.beginTask("", n);
    }

    public void close() throws IOException {
        if (this.console != null) {
            this.console.close();
        }
        this.monitor.done();
    }

    public void flush() throws IOException {
        if (this.console != null) {
            this.console.flush();
        }
    }

    public synchronized void write(int n) throws IOException {
        this.currentLine.append((char)n);
        this.checkProgress(false);
        if (this.console != null) {
            this.console.write(n);
        }
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n != 0 || n2 < 0 || n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.currentLine.append(new String(byArray, 0, n2));
        this.checkProgress(false);
        if (this.console != null) {
            this.console.write(byArray, n, n2);
        }
    }

    private void checkProgress(boolean bl) {
        String string = this.currentLine.toString();
        int n = 0;
        while ((n = string.indexOf("\n")) != -1) {
            String string2 = string.substring(0, n).trim();
            this.processLine(string2);
            string = string.substring(n + 1);
        }
        this.currentLine.setLength(0);
        if (bl) {
            if (string.length() > 0) {
                this.processLine(string);
            }
        } else {
            this.currentLine.append(string);
        }
    }

    private void processLine(String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.log.size()) {
            String string2 = (String)this.log.get(n2);
            if (string2.startsWith(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n != -1) {
            String string3 = (String)this.log.get(n);
            if (string3.length() > 50) {
                string3 = string3.substring(0, 50);
            }
            this.monitor.subTask(string3);
            this.monitor.worked(n + 1);
            this.log.removeInterval(0, n + 1);
        }
    }

    class MyList
    extends ArrayList {
        MyList() {
        }

        public void removeInterval(int n, int n2) {
            this.removeRange(n, n2);
        }
    }
}

