/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.SubProgressMonitor;

public class MakeTarget
extends PlatformObject
implements IMakeTarget {
    private final MakeTargetManager manager;
    private String name;
    private String target;
    private String buildArguments;
    private IPath buildCommand;
    private boolean isDefaultBuildCmd;
    private boolean isStopOnError;
    private boolean runAllBuidlers = true;
    private String targetBuilderID;
    private IContainer container;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    MakeTarget(MakeTargetManager makeTargetManager, IProject iProject, String string, String string2) throws CoreException {
        this.manager = makeTargetManager;
        this.targetBuilderID = string;
        this.name = string2;
        IMakeBuilderInfo iMakeBuilderInfo = MakeCorePlugin.createBuildInfo(iProject, makeTargetManager.getBuilderID(string));
        this.buildCommand = iMakeBuilderInfo.getBuildCommand();
        this.buildArguments = iMakeBuilderInfo.getBuildArguments();
        this.isDefaultBuildCmd = iMakeBuilderInfo.isDefaultBuildCmd();
        this.isStopOnError = iMakeBuilderInfo.isStopOnError();
    }

    public void setContainer(IContainer iContainer) {
        this.container = iContainer;
    }

    void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getTargetBuilderID() {
        return this.targetBuilderID;
    }

    public boolean isStopOnError() {
        return this.isStopOnError;
    }

    public void setStopOnError(boolean bl) throws CoreException {
        this.isStopOnError = bl;
        this.manager.updateTarget(this);
    }

    public boolean isDefaultBuildCmd() {
        return this.isDefaultBuildCmd;
    }

    public void setUseDefaultBuildCmd(boolean bl) throws CoreException {
        this.isDefaultBuildCmd = bl;
        this.manager.updateTarget(this);
    }

    public IPath getBuildCommand() {
        return this.buildCommand != null ? this.buildCommand : new Path("");
    }

    public void setBuildCommand(IPath iPath) throws CoreException {
        this.buildCommand = iPath;
        this.manager.updateTarget(this);
    }

    public String getBuildArguments() {
        return this.buildArguments != null ? this.buildArguments : "";
    }

    public void setBuildArguments(String string) throws CoreException {
        this.buildArguments = string;
        this.manager.updateTarget(this);
    }

    public IContainer getContainer() {
        return this.container;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MakeTarget) {
            MakeTarget makeTarget = (MakeTarget)object;
            return (this.container != null ? this.container.equals((Object)makeTarget.getContainer()) : makeTarget.getContainer() == null) && this.name.equals(makeTarget.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.container.hashCode() * 17 + this.name.hashCode();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(IProgressMonitor iProgressMonitor) throws CoreException {
        final IProject iProject = this.container.getProject();
        final String string = this.manager.getBuilderID(this.targetBuilderID);
        final HashMap hashMap = new HashMap();
        IMakeBuilderInfo iMakeBuilderInfo = MakeCorePlugin.createBuildInfo(hashMap, string);
        if (this.buildArguments != null) {
            iMakeBuilderInfo.setBuildArguments(this.buildArguments);
        }
        if (this.buildCommand != null) {
            iMakeBuilderInfo.setBuildCommand(this.buildCommand);
        }
        iMakeBuilderInfo.setUseDefaultBuildCmd(this.isDefaultBuildCmd);
        iMakeBuilderInfo.setStopOnError(this.isStopOnError);
        iMakeBuilderInfo.setFullBuildEnable(true);
        iMakeBuilderInfo.setFullBuildTarget(this.target);
        if (this.container != null) {
            iMakeBuilderInfo.setBuildLocation(this.container.getFullPath());
        }
        IMakeBuilderInfo iMakeBuilderInfo2 = MakeCorePlugin.createBuildInfo(iProject, string);
        iMakeBuilderInfo.setErrorParsers(iMakeBuilderInfo2.getErrorParsers());
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                if (MakeTarget.this.runAllBuidlers) {
                    ICommand[] iCommandArray = iProject.getDescription().getBuildSpec();
                    iProgressMonitor.beginTask("", iCommandArray.length);
                    int n = 0;
                    while (n < iCommandArray.length) {
                        if (iCommandArray[n].getBuilderName().equals(string)) {
                            iProject.build(6, string, (Map)hashMap, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        } else {
                            iProject.build(6, iCommandArray[n].getBuilderName(), iCommandArray[n].getArguments(), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        }
                        ++n;
                    }
                    iProgressMonitor.done();
                } else {
                    iProject.build(6, string, (Map)hashMap, iProgressMonitor);
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, iProgressMonitor);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        iProgressMonitor.done();
    }

    public void setBuildTarget(String string) throws CoreException {
        this.target = string;
        this.manager.updateTarget(this);
    }

    public String getBuildTarget() {
        return this.target != null ? this.target : "";
    }

    public void setRunAllBuilders(boolean bl) {
        this.runAllBuidlers = bl;
    }

    public boolean runAllBuilders() {
        return this.runAllBuidlers;
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return this.container.getProject();
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz3)) {
            return this.container;
        }
        return super.getAdapter(clazz);
    }
}

