/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.MakeTarget;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProjectTargets {
    private static final String MAKE_TARGET_KEY = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".buildtargets";
    private static final String TARGETS_EXT = "targets";
    private static final String BUILD_TARGET_ELEMENT = "buildTargets";
    private static final String TARGET_ELEMENT = "target";
    private static final String TARGET_ATTR_ID = "targetID";
    private static final String TARGET_ATTR_PATH = "path";
    private static final String TARGET_ATTR_NAME = "name";
    private static final String TARGET_STOP_ON_ERROR = "stopOnError";
    private static final String TARGET_USE_DEFAULT_CMD = "useDefaultCommand";
    private static final String TARGET_ARGUMENTS = "buildArguments";
    private static final String TARGET_COMMAND = "buildCommand";
    private static final String BAD_TARGET = "buidlTarget";
    private static final String TARGET = "buildTarget";
    private HashMap targetMap = new HashMap();
    private IProject project;

    public ProjectTargets(MakeTargetManager makeTargetManager, IProject iProject) throws CoreException {
        Object object;
        boolean bl = false;
        File file = null;
        this.project = iProject;
        Document document = this.translateCDTProjectToDocument();
        if (document == null || !document.hasChildNodes()) {
            object = MakeCorePlugin.getDefault().getStateLocation().append(iProject.getName()).addFileExtension(TARGETS_EXT);
            file = object.toFile();
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                document = this.translateInputStreamToDocument(fileInputStream);
                bl = true;
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        if (document != null) {
            this.extractMakeTargetsFromDocument(document, makeTargetManager);
            if (bl) {
                try {
                    object = this.getAsXML();
                    this.translateDocumentToCDTProject((Document)object);
                }
                catch (Exception exception) {
                    file = null;
                }
                if (file != null) {
                    file.delete();
                }
            }
        }
    }

    protected String getString(Node node, String string) {
        Node node2 = this.searchNode(node, string);
        return node2 != null ? (node2.getFirstChild() == null ? null : node2.getFirstChild().getNodeValue()) : null;
    }

    protected Node searchNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeName().equals(string)) {
                return nodeList.item(n);
            }
            ++n;
        }
        return null;
    }

    public IMakeTarget[] get(IContainer iContainer) {
        ArrayList arrayList = (ArrayList)this.targetMap.get(iContainer);
        if (arrayList != null) {
            return arrayList.toArray(new IMakeTarget[arrayList.size()]);
        }
        return new IMakeTarget[0];
    }

    public IMakeTarget findTarget(IContainer iContainer, String string) {
        ArrayList arrayList = (ArrayList)this.targetMap.get(iContainer);
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                IMakeTarget iMakeTarget = (IMakeTarget)iterator.next();
                if (!iMakeTarget.getName().equals(string)) continue;
                return iMakeTarget;
            }
        }
        return null;
    }

    public void add(MakeTarget makeTarget) throws CoreException {
        ArrayList<MakeTarget> arrayList = (ArrayList<MakeTarget>)this.targetMap.get(makeTarget.getContainer());
        if (arrayList != null && arrayList.contains(makeTarget)) {
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("MakeTargetManager.target_exists"), null));
        }
        if (arrayList == null) {
            arrayList = new ArrayList<MakeTarget>();
            this.targetMap.put(makeTarget.getContainer(), arrayList);
        }
        arrayList.add(makeTarget);
    }

    public boolean contains(MakeTarget makeTarget) {
        ArrayList arrayList = (ArrayList)this.targetMap.get(makeTarget.getContainer());
        return arrayList != null && arrayList.contains(makeTarget);
    }

    public boolean remove(IMakeTarget iMakeTarget) {
        ArrayList arrayList = (ArrayList)this.targetMap.get(iMakeTarget.getContainer());
        if (arrayList == null || !arrayList.contains(iMakeTarget)) {
            return false;
        }
        boolean bl = arrayList.remove(iMakeTarget);
        if (arrayList.size() == 0) {
            this.targetMap.remove(arrayList);
        }
        return bl;
    }

    public IProject getProject() {
        return this.project;
    }

    protected Document getAsXML() throws IOException {
        Document document;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Error creating new XML storage document");
        }
        Element element = document.createElement(BUILD_TARGET_ELEMENT);
        document.appendChild(element);
        Iterator iterator = this.targetMap.entrySet().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next().getValue();
            int n = 0;
            while (n < list.size()) {
                MakeTarget makeTarget = (MakeTarget)list.get(n);
                element.appendChild(this.createTargetElement(document, makeTarget));
                ++n;
            }
        }
        return document;
    }

    private Node createTargetElement(Document document, MakeTarget makeTarget) {
        Element element = document.createElement(TARGET_ELEMENT);
        element.setAttribute(TARGET_ATTR_NAME, makeTarget.getName());
        element.setAttribute(TARGET_ATTR_ID, makeTarget.getTargetBuilderID());
        element.setAttribute(TARGET_ATTR_PATH, makeTarget.getContainer().getProjectRelativePath().toString());
        Element element2 = document.createElement(TARGET_COMMAND);
        element.appendChild(element2);
        element2.appendChild(document.createTextNode(makeTarget.getBuildCommand().toString()));
        if (makeTarget.getBuildArguments().length() > 0) {
            element2 = document.createElement(TARGET_ARGUMENTS);
            element2.appendChild(document.createTextNode(makeTarget.getBuildArguments()));
            element.appendChild(element2);
        }
        if (makeTarget.getBuildTarget().length() > 0) {
            element2 = document.createElement(TARGET);
            element2.appendChild(document.createTextNode(makeTarget.getBuildTarget()));
            element.appendChild(element2);
        }
        element2 = document.createElement(TARGET_STOP_ON_ERROR);
        element2.appendChild(document.createTextNode(new Boolean(makeTarget.isStopOnError()).toString()));
        element.appendChild(element2);
        element2 = document.createElement(TARGET_USE_DEFAULT_CMD);
        element2.appendChild(document.createTextNode(new Boolean(makeTarget.isDefaultBuildCmd()).toString()));
        element.appendChild(element2);
        return element;
    }

    public void saveTargets() throws IOException {
        Document document = this.getAsXML();
        try {
            this.translateDocumentToCDTProject(document);
        }
        catch (Exception exception) {
            IPath iPath = MakeCorePlugin.getDefault().getStateLocation().append(this.project.getName()).addFileExtension(TARGETS_EXT);
            File file = iPath.toFile();
            try {
                this.saveTargets(document, new FileOutputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            catch (TransformerException transformerException) {}
        }
    }

    protected void saveTargets(Document document, OutputStream outputStream) throws IOException, TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(outputStream);
        transformer.transform(dOMSource, streamResult);
    }

    protected void translateDocumentToCDTProject(Document document) throws CoreException, IOException {
        ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(this.getProject(), true);
        Element element = iCDescriptor.getProjectData(MAKE_TARGET_KEY);
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            element.removeChild(nodeList.item(n));
            --n;
            ++n;
        }
        Node node = document.getFirstChild();
        if (node.hasChildNodes()) {
            Node node2 = element.getOwnerDocument().importNode(node, true);
            element.appendChild(node2);
        }
        iCDescriptor.saveProjectData();
    }

    protected Document translateCDTProjectToDocument() {
        Object object;
        Document document = null;
        Element element = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            object = CCorePlugin.getDefault().getCProjectDescription(this.getProject(), true);
            element = object.getProjectData(MAKE_TARGET_KEY);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return document;
        }
        catch (CoreException coreException) {
            return document;
        }
        object = element.getChildNodes();
        int n = 0;
        while (n < object.getLength()) {
            if (object.item(n).getNodeType() == 1) {
                Node node = document.importNode(object.item(n), true);
                document.appendChild(node);
                break;
            }
            ++n;
        }
        return document;
    }

    protected Document translateInputStreamToDocument(InputStream inputStream) {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
        }
        catch (Exception exception) {
            MakeCorePlugin.log(exception);
        }
        return document;
    }

    protected void extractMakeTargetsFromDocument(Document document, MakeTargetManager makeTargetManager) {
        Node node = document.getFirstChild();
        if (node != null && node.getNodeName().equals(BUILD_TARGET_ELEMENT)) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                node = nodeList.item(n);
                if (node.getNodeName().equals(TARGET_ELEMENT)) {
                    Object object = null;
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    String string = namedNodeMap.getNamedItem(TARGET_ATTR_PATH).getNodeValue();
                    object = string != null && !string.equals("") ? this.project.getFolder(string) : this.project;
                    try {
                        MakeTarget makeTarget = new MakeTarget(makeTargetManager, this.project, namedNodeMap.getNamedItem(TARGET_ATTR_ID).getNodeValue(), namedNodeMap.getNamedItem(TARGET_ATTR_NAME).getNodeValue());
                        makeTarget.setContainer((IContainer)object);
                        String string2 = this.getString(node, TARGET_STOP_ON_ERROR);
                        if (string2 != null) {
                            makeTarget.setStopOnError(Boolean.valueOf(string2));
                        }
                        if ((string2 = this.getString(node, TARGET_USE_DEFAULT_CMD)) != null) {
                            makeTarget.setUseDefaultBuildCmd(Boolean.valueOf(string2));
                        }
                        if ((string2 = this.getString(node, TARGET_COMMAND)) != null) {
                            makeTarget.setBuildCommand((IPath)new Path(string2));
                        }
                        if ((string2 = this.getString(node, TARGET_ARGUMENTS)) != null) {
                            makeTarget.setBuildArguments(string2);
                        }
                        if ((string2 = this.getString(node, BAD_TARGET)) != null) {
                            makeTarget.setBuildTarget(string2);
                        }
                        if ((string2 = this.getString(node, TARGET)) != null) {
                            makeTarget.setBuildTarget(string2);
                        }
                        this.add(makeTarget);
                    }
                    catch (CoreException coreException) {
                        MakeCorePlugin.log(coreException);
                    }
                }
                ++n;
            }
        }
    }
}

