/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.makefile.gnu;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.make.core.makefile.IBadDirective;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IMakefileValidator;
import org.eclipse.cdt.make.core.makefile.ISpecialRule;
import org.eclipse.cdt.make.core.makefile.gnu.IConditional;
import org.eclipse.cdt.make.core.makefile.gnu.ITerminal;
import org.eclipse.cdt.make.core.makefile.gnu.IVariableDefinition;
import org.eclipse.cdt.make.internal.core.makefile.MakefileMessages;
import org.eclipse.cdt.make.internal.core.makefile.gnu.GNUMakefile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class GNUMakefileValidator
implements IMakefileValidator {
    IMarkerGenerator reporter;

    public GNUMakefileValidator() {
    }

    public GNUMakefileValidator(IMarkerGenerator iMarkerGenerator) {
        this.setMarkerGenerator(iMarkerGenerator);
    }

    public void setMarkerGenerator(IMarkerGenerator iMarkerGenerator) {
        this.reporter = iMarkerGenerator;
    }

    public IMarkerGenerator getMarkerGenerator() {
        if (this.reporter == null) {
            this.reporter = new IMarkerGenerator(){

                public void addMarker(IResource iResource, int n, String string, int n2, String string2) {
                    String string3 = "Makefile";
                    if (iResource != null) {
                        string3 = iResource.getName();
                    }
                    StringBuffer stringBuffer = new StringBuffer(string3);
                    stringBuffer.append(':').append(n).append(':').append(this.getSeverity(n2));
                    if (string != null) {
                        stringBuffer.append(':').append(string);
                    }
                    if (string2 != null) {
                        stringBuffer.append(':').append(string2);
                    }
                    stringBuffer.append('\n');
                    System.out.println(stringBuffer.toString());
                }

                public String getSeverity(int n) {
                    if (n == 3) {
                        return MakefileMessages.getString("MakefileValidator.errorBuild");
                    }
                    if (n == 2) {
                        return MakefileMessages.getString("MakefileValidator.errorResource");
                    }
                    if (n == 0) {
                        return MakefileMessages.getString("MakefileValidator.warningInfo");
                    }
                    if (n == 1) {
                        return MakefileMessages.getString("MakefileValidator.warning");
                    }
                    return MakefileMessages.getString("MakefileValidator.unknown");
                }
            };
        }
        return this.reporter;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkFile(IFile iFile, IProgressMonitor iProgressMonitor) {
        block9: {
            String string = String.valueOf(MakefileMessages.getString("MakefileValidator.checkingFile")) + iFile.getFullPath().toString();
            iProgressMonitor.subTask(string);
            GNUMakefile gNUMakefile = new GNUMakefile();
            InputStream inputStream = null;
            try {
                try {
                    inputStream = iFile.getContents();
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    gNUMakefile.parse(iFile.getFullPath().toString(), inputStreamReader);
                    this.validateDirectives((IResource)iFile, gNUMakefile.getDirectives());
                }
                catch (CoreException coreException) {
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var7_9 = null;
                if (inputStream == null) break block9;
            }
            try {}
            catch (IOException iOException) {}
            inputStream.close();
        }
        iProgressMonitor.subTask(MakefileMessages.getString("MakefileValidator.fileChecked"));
        iProgressMonitor.done();
    }

    public void validateDirectives(IResource iResource, IDirective[] iDirectiveArray) {
        IMarkerGenerator iMarkerGenerator = this.getMarkerGenerator();
        int n = 0;
        int n2 = 0;
        IDirective iDirective = null;
        int n3 = 0;
        while (n3 < iDirectiveArray.length) {
            String string;
            iDirective = iDirectiveArray[n3];
            if (iDirective instanceof IConditional) {
                IConditional iConditional = (IConditional)iDirective;
                this.validateCondition(iConditional);
                if (!iConditional.isElse()) {
                    ++n;
                } else if (n == 0) {
                    int n4 = iConditional.getStartLine();
                    String string2 = MakefileMessages.getString("MakefileValidator.error.elseMissingIfCondition");
                    int n5 = 2;
                    string = iConditional.toString().trim();
                    iMarkerGenerator.addMarker(iResource, n4, string2, n5, string);
                }
            } else if (iDirective instanceof ITerminal) {
                ITerminal iTerminal = (ITerminal)iDirective;
                if (iTerminal.isEndif()) {
                    if (n == 0) {
                        int n6 = iTerminal.getStartLine();
                        String string3 = MakefileMessages.getString("MakefileValidator.error.endifMissingIfElseCondition");
                        int n7 = 2;
                        string = iTerminal.toString().trim();
                        iMarkerGenerator.addMarker(iResource, n6, string3, n7, string);
                    } else {
                        --n;
                    }
                } else if (iTerminal.isEndef()) {
                    if (n2 == 0) {
                        int n8 = iTerminal.getStartLine();
                        String string4 = MakefileMessages.getString("MakefileValidator.error.endefMissingOverrideDefine");
                        int n9 = 2;
                        string = iTerminal.toString().trim();
                        iMarkerGenerator.addMarker(iResource, n8, string4, n9, string);
                    } else {
                        --n2;
                    }
                }
            } else if (iDirective instanceof IVariableDefinition) {
                IVariableDefinition iVariableDefinition = (IVariableDefinition)iDirective;
                if (iVariableDefinition.isMultiLine()) {
                    ++n2;
                }
            } else if (iDirective instanceof IBadDirective) {
                int n10 = iDirective.getStartLine();
                String string5 = MakefileMessages.getString("MakefileValidator.error.unknownDirective");
                int n11 = 2;
                String string6 = iDirective.toString().trim();
                iMarkerGenerator.addMarker(iResource, n10, string5, n11, string6);
            } else if (iDirective instanceof ISpecialRule) {
                this.validateSpecialRule((ISpecialRule)iDirective);
            }
            ++n3;
        }
        if (n > 0) {
            n3 = 0;
            String string = "";
            int n12 = 2;
            int n13 = iDirectiveArray.length - 1;
            while (n13 >= 0) {
                if (iDirectiveArray[n13] instanceof IConditional) {
                    n3 = iDirectiveArray[n13].getStartLine();
                    string = iDirectiveArray[n13].toString().trim();
                    break;
                }
                --n13;
            }
            String string7 = MakefileMessages.getString("MakefileValidator.error.noMatchingEndifForCondition");
            iMarkerGenerator.addMarker(iResource, n3, string7, n12, string);
        }
        if (n2 > 0) {
            n3 = 0;
            String string = "";
            int n14 = 2;
            int n15 = iDirectiveArray.length - 1;
            while (n15 >= 0) {
                IVariableDefinition iVariableDefinition;
                if (iDirectiveArray[n15] instanceof IVariableDefinition && (iVariableDefinition = (IVariableDefinition)iDirectiveArray[n15]).isMultiLine()) {
                    n3 = iVariableDefinition.getStartLine();
                    string = iVariableDefinition.toString().trim();
                    break;
                }
                --n15;
            }
            String string8 = MakefileMessages.getString("MakefileValidator.error.noMatchingEndefForOverrideDefine");
            iMarkerGenerator.addMarker(iResource, n3, string8, n14, string);
        }
    }

    public void validateCondition(IConditional iConditional) {
    }

    public void validateSpecialRule(ISpecialRule iSpecialRule) {
    }
}

