/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;

public class ConsoleOutputStreamSniffer {
    private int nOpens = 0;
    private OutputStream consoleOutputStream;
    private IScannerInfoConsoleParser[] parsers;

    public ConsoleOutputStreamSniffer(IScannerInfoConsoleParser[] iScannerInfoConsoleParserArray) {
        this.parsers = iScannerInfoConsoleParserArray;
    }

    public ConsoleOutputStreamSniffer(OutputStream outputStream, IScannerInfoConsoleParser[] iScannerInfoConsoleParserArray) {
        this(iScannerInfoConsoleParserArray);
        this.consoleOutputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        this.incNOpens();
        return new ConsoleOutputStream();
    }

    public OutputStream getErrorStream() {
        this.incNOpens();
        return new ConsoleOutputStream();
    }

    private synchronized void incNOpens() {
        ++this.nOpens;
    }

    public synchronized void closeConsoleOutputStream(ConsoleOutputStream consoleOutputStream) throws IOException {
        if (this.nOpens > 0 && --this.nOpens == 0) {
            consoleOutputStream.checkLine(true);
            if (this.consoleOutputStream != null) {
                this.consoleOutputStream.close();
            }
        }
        int n = 0;
        while (n < this.parsers.length) {
            this.parsers[n].shutdown();
            ++n;
        }
    }

    public void flushConsoleOutputStream() throws IOException {
        if (this.consoleOutputStream != null) {
            this.consoleOutputStream.flush();
        }
    }

    private class ConsoleOutputStream
    extends OutputStream {
        private StringBuffer currentLine = new StringBuffer();

        ConsoleOutputStream() {
        }

        public void write(int n) throws IOException {
            this.currentLine.append((char)n);
            this.checkLine(false);
            if (ConsoleOutputStreamSniffer.this.consoleOutputStream != null) {
                ConsoleOutputStreamSniffer.this.consoleOutputStream.write(n);
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n != 0 || n2 < 0 || n2 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            this.currentLine.append(new String(byArray, 0, n2));
            this.checkLine(false);
            if (ConsoleOutputStreamSniffer.this.consoleOutputStream != null) {
                ConsoleOutputStreamSniffer.this.consoleOutputStream.write(byArray, n, n2);
            }
        }

        public void close() throws IOException {
            ConsoleOutputStreamSniffer.this.closeConsoleOutputStream(this);
        }

        private void checkLine(boolean bl) {
            String string = this.currentLine.toString();
            int n = 0;
            while ((n = string.indexOf(10)) != -1) {
                String string2 = string.substring(0, n).trim();
                if (string2.length() > 0) {
                    this.processLine(string2);
                }
                string = string.substring(n + 1);
            }
            this.currentLine.setLength(0);
            if (bl) {
                if (string.length() > 0) {
                    this.processLine(string);
                }
            } else {
                this.currentLine.append(string);
            }
        }

        private void processLine(String string) {
            int n = 0;
            while (n < ConsoleOutputStreamSniffer.this.parsers.length) {
                ConsoleOutputStreamSniffer.this.parsers[n].processLine(string);
                ++n;
            }
        }
    }
}

