/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IExternalScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.StreamMonitor;
import org.eclipse.cdt.make.internal.core.scannerconfig.ConsoleOutputStreamSniffer;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerInfoConsoleParserFactory;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.GCCScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class DefaultExternalScannerInfoProvider
implements IExternalScannerInfoProvider,
IMarkerGenerator {
    private static final String EXTERNAL_SI_PROVIDER_ERROR = "ExternalScannerInfoProvider.Provider_Error";
    private static final String EXTERNAL_SI_PROVIDER_CONSOLE_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".ExternalScannerInfoProviderConsole";
    private static final String LANG_ENV_VAR = "LANG";
    private IPath fWorkingDirectory;
    private IPath fCompileCommand;
    private String[] fCompileArguments;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean invokeProvider(IProgressMonitor iProgressMonitor, IProject iProject, IScannerConfigBuilderInfo iScannerConfigBuilderInfo, IPath iPath, String string, List arrayList, IScannerInfoCollector iScannerInfoCollector) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        if (!this.initialize(iProject, iScannerConfigBuilderInfo, iPath, string)) {
            return false;
        }
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(MakeMessages.getString("ExternalScannerInfoProvider.Reading_Specs"), 100);
        try {
            try {
                IConsole iConsole = CCorePlugin.getDefault().getConsole(EXTERNAL_SI_PROVIDER_CONSOLE_ID);
                iConsole.start(iProject);
                Object object = iConsole.getOutputStream();
                iProgressMonitor.subTask(MakeMessages.getString("ExternalScannerInfoProvider.Reading_Specs"));
                String string2 = null;
                CommandLauncher commandLauncher = new CommandLauncher();
                commandLauncher.showCommand(true);
                String[] stringArray = this.fCompileArguments;
                if (iScannerConfigBuilderInfo.isDefaultESIProviderCmd()) {
                    stringArray = this.prepareArguments(arrayList);
                }
                String string3 = this.coligate(stringArray);
                iProgressMonitor.subTask(String.valueOf(MakeMessages.getString("ExternalScannerInfoProvider.Invoking_Command")) + this.fCompileCommand.toString() + string3);
                object = new StreamMonitor((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 70), (OutputStream)object, 100);
                ConsoleOutputStreamSniffer consoleOutputStreamSniffer = ScannerInfoConsoleParserFactory.getESIProviderOutputSniffer((OutputStream)object, iProject, iScannerConfigBuilderInfo, iScannerInfoCollector);
                Object object2 = consoleOutputStreamSniffer == null ? object : consoleOutputStreamSniffer.getOutputStream();
                Object object3 = consoleOutputStreamSniffer == null ? object : consoleOutputStreamSniffer.getErrorStream();
                TraceUtil.outputTrace("Default provider is executing command:", String.valueOf(this.fCompileCommand.toString()) + string3, "");
                Process process = commandLauncher.execute(this.fCompileCommand, stringArray, this.setEnvironment(commandLauncher), this.fWorkingDirectory);
                if (process != null) {
                    try {
                        process.getOutputStream().close();
                    }
                    catch (IOException iOException) {}
                    if (commandLauncher.waitAndRead((OutputStream)object2, (OutputStream)object3, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 0)) != 0) {
                        string2 = commandLauncher.getErrorMessage();
                    }
                    iProgressMonitor.subTask(MakeMessages.getString("ExternalScannerInfoProvider.Parsing_Output"));
                } else {
                    string2 = commandLauncher.getErrorMessage();
                }
                if (string2 != null) {
                    String string4 = MakeMessages.getFormattedString(EXTERNAL_SI_PROVIDER_ERROR, String.valueOf(this.fCompileCommand.toString()) + string3);
                    this.addMarker((IResource)iProject, -1, string4, 1, null);
                }
                iProgressMonitor.subTask(MakeMessages.getString("ExternalScannerInfoProvider.Creating_Markers"));
                ((OutputStream)object2).close();
                ((OutputStream)object3).close();
                ((OutputStream)object).close();
            }
            catch (Exception exception) {
                CCorePlugin.log((Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var19_21 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var19_22 = null;
        }
        iProgressMonitor.done();
        return true;
    }

    private boolean initialize(IProject iProject, IScannerConfigBuilderInfo iScannerConfigBuilderInfo, IPath iPath, String string) {
        boolean bl = false;
        this.fWorkingDirectory = iProject.getLocation();
        String string2 = "dummy";
        try {
            if (iProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                string2 = "specs.cpp";
            } else if (iProject.hasNature("org.eclipse.cdt.core.cnature")) {
                string2 = "specs.c";
            }
        }
        catch (CoreException coreException) {
            MakeCorePlugin.log(coreException.getStatus());
        }
        IPath iPath2 = MakeCorePlugin.getWorkingDirectory().append(string2);
        if (!iPath2.toFile().exists()) {
            GCCScannerConfigUtil.createSpecs();
        }
        this.fCompileCommand = iPath != null ? iPath : iScannerConfigBuilderInfo.getESIProviderCommand();
        if (this.fCompileCommand != null) {
            String string3 = string != null ? string : iScannerConfigBuilderInfo.getESIProviderArguments();
            this.fCompileArguments = ScannerConfigUtil.tokenizeStringWithQuotes(string3, "\"");
            int n = 0;
            while (n < this.fCompileArguments.length) {
                this.fCompileArguments[n] = this.fCompileArguments[n].replaceAll("\\$\\{plugin_state_location\\}", MakeCorePlugin.getWorkingDirectory().toString());
                this.fCompileArguments[n] = this.fCompileArguments[n].replaceAll("\\$\\{specs_file\\}", string2);
                ++n;
            }
            bl = true;
        }
        return bl;
    }

    private String[] prepareArguments(List list) {
        String[] stringArray = null;
        int n = 0;
        if (this.fCompileArguments != null && this.fCompileArguments.length > 0) {
            n = this.fCompileArguments.length;
            stringArray = new String[n + list.size()];
            System.arraycopy(this.fCompileArguments, 0, stringArray, 0, n);
        } else {
            stringArray = new String[list.size()];
        }
        int n2 = 0;
        while (n2 < list.size()) {
            stringArray[n + n2] = (String)list.get(n2);
            ++n2;
        }
        return stringArray;
    }

    private String coligate(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(128);
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(' ');
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        String string = stringBuffer.toString();
        return string;
    }

    private String[] setEnvironment(CommandLauncher commandLauncher) {
        Properties properties = commandLauncher.getEnvironment();
        properties.put("CWD", this.fWorkingDirectory.toOSString());
        properties.put("PWD", this.fWorkingDirectory.toOSString());
        if (properties.containsKey(LANG_ENV_VAR)) {
            properties.put(LANG_ENV_VAR, "en_US.UTF-8");
        }
        String[] stringArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<?> enumeration = properties.propertyNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                arrayList.add(String.valueOf(string) + "=" + properties.getProperty(string));
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
        }
        return stringArray;
    }

    public void addMarker(IResource iResource, int n, String string, int n2, String string2) {
        try {
            IMarker[] iMarkerArray = iResource.findMarkers("org.eclipse.cdt.core.problem", false, 1);
            if (iMarkerArray != null && iMarkerArray.length > 0) {
                int n3 = 0;
                while (n3 < iMarkerArray.length) {
                    int n4 = (Integer)iMarkerArray[n3].getAttribute("location");
                    int n5 = (Integer)iMarkerArray[n3].getAttribute("severity");
                    String string3 = (String)iMarkerArray[n3].getAttribute("message");
                    if (n4 == n && n5 == this.mapMarkerSeverity(n2) && string3.equals(string)) {
                        return;
                    }
                    ++n3;
                }
            }
            IMarker iMarker = iResource.createMarker("org.eclipse.cdt.core.problem");
            iMarker.setAttribute("location", n);
            iMarker.setAttribute("message", (Object)string);
            iMarker.setAttribute("severity", this.mapMarkerSeverity(n2));
            iMarker.setAttribute("lineNumber", n);
            iMarker.setAttribute("charStart", -1);
            iMarker.setAttribute("charEnd", -1);
            if (string2 != null) {
                iMarker.setAttribute("problem.variable", (Object)string2);
            }
        }
        catch (CoreException coreException) {
            CCorePlugin.log((IStatus)coreException.getStatus());
        }
    }

    int mapMarkerSeverity(int n) {
        switch (n) {
            case 2: 
            case 3: {
                return 2;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }
}

