/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DiscoveredPathContainer
implements IPathEntryContainer {
    public static IPath CONTAINER_ID = new Path("org.eclipse.cdt.make.core.DISCOVERED_SCANNER_INFO");
    private final IProject fProject;
    private static Map fgPathEntries;

    public DiscoveredPathContainer(IProject iProject) {
        this.fProject = iProject;
    }

    public static IPathEntry[] getPathEntries(IProject iProject) throws CoreException {
        Object object;
        if (fgPathEntries == null) {
            fgPathEntries = new HashMap(10);
            object = new IDiscoveredPathManager.IDiscoveredInfoListener(){

                public void infoRemoved(IProject iProject) {
                    fgPathEntries.remove(iProject);
                }

                public void infoChanged(IDiscoveredPathManager.IDiscoveredPathInfo iDiscoveredPathInfo) {
                    fgPathEntries.remove(iDiscoveredPathInfo.getProject());
                }
            };
            MakeCorePlugin.getDefault().getDiscoveryManager().addDiscoveredInfoListener((IDiscoveredPathManager.IDiscoveredInfoListener)object);
        }
        if ((object = (IPathEntry[])fgPathEntries.get(iProject)) == null) {
            object = DiscoveredPathContainer.computeNewPathEntries(iProject);
            fgPathEntries.put(iProject, object);
        }
        return object;
    }

    private static IPathEntry[] computeNewPathEntries(IProject iProject) throws CoreException {
        IDiscoveredPathManager.IDiscoveredPathInfo iDiscoveredPathInfo = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(iProject);
        IPath[] iPathArray = iDiscoveredPathInfo.getIncludePaths();
        Map map = iDiscoveredPathInfo.getSymbols();
        ArrayList<Object> arrayList = new ArrayList<Object>(iPathArray.length + map.size());
        int n = 0;
        while (n < iPathArray.length) {
            arrayList.add(CoreModel.newIncludeEntry((IPath)Path.EMPTY, (IPath)Path.EMPTY, (IPath)iPathArray[n]));
            ++n;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            arrayList.add(CoreModel.newMacroEntry((IPath)Path.EMPTY, (String)((String)entry.getKey()), (String)((String)entry.getValue())));
        }
        return arrayList.toArray(new IPathEntry[arrayList.size()]);
    }

    public IPathEntry[] getPathEntries() {
        IPathEntry[] iPathEntryArray;
        try {
            iPathEntryArray = DiscoveredPathContainer.getPathEntries(this.fProject);
        }
        catch (CoreException coreException) {
            MakeCorePlugin.log(coreException);
            return new IPathEntry[0];
        }
        return iPathEntryArray;
    }

    public String getDescription() {
        return MakeMessages.getString("DiscoveredContainer.description");
    }

    public IPath getPath() {
        return CONTAINER_ID;
    }
}

